/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.util;

import com.xceptance.xlt.engine.scripting.util.TextMatchingStrategy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class RegExTextMatchingStrategy
extends TextMatchingStrategy {
    private final boolean caseInsensitive;

    RegExTextMatchingStrategy(boolean caseInsensitiveMatching) {
        this.caseInsensitive = caseInsensitiveMatching;
    }

    RegExTextMatchingStrategy() {
        this(false);
    }

    @Override
    public boolean isAMatch(String searchPattern, String text, boolean strict) {
        int flags = 8;
        if (this.caseInsensitive) {
            flags |= 0x42;
        }
        Pattern pattern = Pattern.compile(searchPattern, flags);
        Matcher matcher = pattern.matcher(text);
        if (strict) {
            return matcher.matches();
        }
        return matcher.find();
    }
}

