/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.ec2;

import com.xceptance.xlt.ec2.MachineInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MachineInfoPrinter {
    public static String prettyPrint(List<MachineInfo> machineInformation, String offset) {
        StringBuilder sb = new StringBuilder();
        String nameHeading = "Name";
        String hostHeading = "Host";
        String typeHeading = "Type";
        String keyNameHeading = "Key-Pair Name";
        String secGroupHeading = "Security Groups";
        String imageHeading = "Image";
        String stateHeading = "State";
        String startTimeHeading = "Launch Time (UTC)";
        String uptimeHeading = "Uptime (h:mm)";
        int maxName = "Host".length();
        int maxHost = "Name".length();
        int maxType = "Type".length();
        int maxKey = "Key-Pair Name".length();
        int maxSecGroup = "Security Groups".length();
        int maxImage = "Image".length();
        int maxState = "State".length();
        int maxStartTime = "Launch Time (UTC)".length();
        int maxUptime = "Uptime (h:mm)".length();
        ArrayList<MachineInfo> machinesSortedByUptime = new ArrayList<MachineInfo>();
        for (MachineInfo info : machineInformation) {
            maxHost = Math.max(maxHost, info.getHost().length());
            maxName = Math.max(maxName, info.getNameTag().length());
            maxStartTime = Math.max(maxStartTime, info.getLaunchTime().length());
            maxUptime = Math.max(maxUptime, info.getUpTime().length());
            maxType = Math.max(maxType, info.getType().length());
            maxKey = Math.max(maxKey, info.getKeyName().length());
            maxSecGroup = Math.max(maxSecGroup, info.getSecurityGroups().length());
            maxImage = Math.max(maxImage, info.getImageName().length());
            maxState = Math.max(maxState, info.getState().length());
            machinesSortedByUptime.add(info);
        }
        Collections.sort(machinesSortedByUptime, new Comparator<MachineInfo>(){

            @Override
            public int compare(MachineInfo o1, MachineInfo o2) {
                return Long.compare(o2.getRuntime(), o1.getRuntime());
            }
        });
        String colSep = " | ";
        int maxLineLength = maxHost + maxName + maxStartTime + maxUptime + maxType + maxKey + maxSecGroup + maxImage + maxState + 8 * " | ".length();
        String dashLine = offset + StringUtils.repeat((char)'-', (int)maxLineLength) + "\n";
        sb.append(dashLine);
        sb.append(offset).append(StringUtils.center((String)"Name", (int)maxName)).append(" | ").append(StringUtils.center((String)"Host", (int)maxHost)).append(" | ").append(StringUtils.center((String)"Type", (int)maxType)).append(" | ").append(StringUtils.center((String)"Key-Pair Name", (int)maxKey)).append(" | ").append(StringUtils.center((String)"Security Groups", (int)maxSecGroup)).append(" | ").append(StringUtils.center((String)"Image", (int)maxImage)).append(" | ").append(StringUtils.center((String)"State", (int)maxState)).append(" | ").append(StringUtils.center((String)"Launch Time (UTC)", (int)maxStartTime)).append(" | ").append(StringUtils.center((String)"Uptime (h:mm)", (int)maxUptime)).append('\n');
        sb.append(dashLine);
        String lineFormat = String.format("%s%%-%ds | %%-%ds | %%-%ds | %%-%ds | %%-%ds | %%-%ds | %%-%ds | %%%ds | %%%ds\n", offset, maxName, maxHost, maxType, maxKey, maxSecGroup, maxImage, maxState, maxStartTime, maxUptime);
        for (MachineInfo info : machinesSortedByUptime) {
            sb.append(String.format(lineFormat, info.getNameTag(), info.getHost(), info.getType(), info.getKeyName(), info.getSecurityGroups(), info.getImageName(), info.getState(), info.getLaunchTime(), info.getUpTime()));
        }
        sb.append(dashLine);
        return sb.toString();
    }
}

