/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.validators;

import com.xceptance.xlt.api.htmlunit.LightWeightPage;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlunit.html.HtmlPage;
import org.junit.Assert;

public class HtmlEndTagValidator {
    private static final String CL_HTML_REGEX = "(?ism)</(?:body|frameset)>(\\s|<!--.*?-->)*</html>(.*)$";
    private static final String REGULAR_TRAILING_CONTENT_REGEX = "(?sm)(\\s|<!--.*?-->)*";
    static final String PROPERTY_NAME = HtmlEndTagValidator.class.getName() + ".enabled";
    private final Pattern pattern = Pattern.compile("(?ism)</(?:body|frameset)>(\\s|<!--.*?-->)*</html>(.*)$");
    private final Pattern trailingContentPattern = Pattern.compile("(?sm)(\\s|<!--.*?-->)*");

    private HtmlEndTagValidator() {
    }

    public void validate(HtmlPage page) {
        String content = page.getWebResponse().getContentAsString();
        this.validate(content);
    }

    public void validate(LightWeightPage page) {
        String content = page.getContent();
        this.validate(content);
    }

    public void validate(String content) {
        String trailingContent;
        Assert.assertNotNull((String)"The page content is null", (Object)content);
        Assert.assertTrue((String)"The page is empty", (content.length() > 0 ? 1 : 0) != 0);
        String truncated = content.substring((int)((double)content.length() * 0.9));
        Matcher matcher = this.pattern.matcher(truncated);
        if (!matcher.find()) {
            matcher = this.pattern.matcher(content);
            Assert.assertTrue((String)"html endtag not found", (boolean)matcher.find());
        }
        if (!(matcher = this.trailingContentPattern.matcher(trailingContent = matcher.group(2))).matches()) {
            XltLogger.runTimeLogger.warn("Only whitespace and XML comments are allowed after closing HTML tag.");
        }
    }

    public static HtmlEndTagValidator getInstance() {
        boolean enabled = XltProperties.getInstance().getProperty(PROPERTY_NAME, false);
        return enabled ? HtmlEndTagValidator_Singleton.instance : HtmlEndTagValidator_Singleton.noopInstance;
    }

    private static final class DisabledHtmlEndTagValidator
    extends HtmlEndTagValidator {
        private DisabledHtmlEndTagValidator() {
        }

        @Override
        public void validate(HtmlPage page) {
        }

        @Override
        public void validate(LightWeightPage page) {
        }

        @Override
        public void validate(String content) {
        }
    }

    private static class HtmlEndTagValidator_Singleton {
        private static final HtmlEndTagValidator instance = new HtmlEndTagValidator();
        private static final HtmlEndTagValidator noopInstance = new DisabledHtmlEndTagValidator();

        private HtmlEndTagValidator_Singleton() {
        }
    }
}

