/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.util;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.api.util.XltRandom;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.htmlunit.WebClient;
import org.junit.Assert;

public class BasicPageUtils {
    public static String getAbsoluteUrl(String baseUrl, String relativePath) throws MalformedURLException {
        ParameterCheckUtils.isNotNullOrEmpty(baseUrl, "baseUrl");
        return BasicPageUtils.getAbsoluteUrl(new URL(baseUrl), relativePath).toString();
    }

    public static String getAbsoluteUrl(URL baseUrl, String relativePath) throws MalformedURLException {
        ParameterCheckUtils.isNotNull(baseUrl, "baseUrl");
        ParameterCheckUtils.isNotNullOrEmpty(relativePath, "relativePath");
        return WebClient.expandUrl(baseUrl, relativePath).toString();
    }

    public static <T> T pickOneRandomly(List<T> elements) {
        return BasicPageUtils.pickOneRandomly(elements, false, false);
    }

    public static <T> T pickOneRandomly(List<T> elements, boolean excludeFirst) {
        return BasicPageUtils.pickOneRandomly(elements, excludeFirst, false);
    }

    public static <T> T pickOneRandomly(List<T> elements, boolean excludeFirst, boolean excludeLast) {
        ParameterCheckUtils.isNotNull(elements, "elements");
        int size = elements.size();
        if (excludeFirst) {
            --size;
        }
        if (excludeLast) {
            --size;
        }
        Assert.assertTrue((String)"List does not contain enough items.", (size > 0 ? 1 : 0) != 0);
        int ran = XltRandom.nextInt(size);
        if (excludeFirst) {
            ++ran;
        }
        return elements.get(ran);
    }
}

