/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamPump
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(StreamPump.class);
    private final InputStream in;
    private final OutputStream out;

    public StreamPump(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    public StreamPump(InputStream in, File file) throws FileNotFoundException {
        this(in, new FileOutputStream(file));
    }

    public StreamPump(InputStream in, String fileName) throws FileNotFoundException {
        this(in, new FileOutputStream(fileName));
    }

    @Override
    public void run() {
        try {
            IOUtils.copy((InputStream)this.in, (OutputStream)this.out);
        }
        catch (IOException ex) {
            log.error("Error while copying stream:", (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.in);
            IOUtils.closeQuietly((OutputStream)this.out);
        }
    }
}

