/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public final class InetAddressUtils {
    public static final String LOCALHOST_IP = "127.0.0.1";
    public static final String LOCALHOST_NAME = "localhost";

    private InetAddressUtils() {
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress localHost = null;
        try {
            localHost = InetAddress.getLocalHost();
            if (!localHost.isLoopbackAddress()) {
                return localHost;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        try {
            for (InetAddress address : InetAddressUtils.getAllLocalInetAddresses()) {
                if (address.isLoopbackAddress()) continue;
                return address;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (localHost == null) {
            throw new UnknownHostException();
        }
        return localHost;
    }

    public static List<InetAddress> getAllLocalInetAddresses() throws SocketException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                addresses.add(inetAddresses.nextElement());
            }
        }
        return addresses;
    }

    public static boolean isLocalAddress(InetAddress inetAddress) throws SocketException {
        return InetAddressUtils.getAllLocalInetAddresses().contains(inetAddress);
    }

    public static boolean isLocalAddress(String hostNameOrAddress) throws SocketException, UnknownHostException {
        return InetAddressUtils.isLocalAddress(InetAddress.getByName(hostNameOrAddress));
    }
}

