/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.file;

import java.io.IOException;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.util.Locale;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstant;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.event.EventTarget;
import org.htmlunit.javascript.host.file.Blob;
import org.htmlunit.javascript.host.file.File;

@JsxClass
public class FileReader
extends EventTarget {
    private static final Log LOG = LogFactory.getLog(FileReader.class);
    @JsxConstant
    public static final int EMPTY = 0;
    @JsxConstant
    public static final int LOADING = 1;
    @JsxConstant
    public static final int DONE = 2;
    private int readyState_ = 0;
    private Object result_;

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @JsxGetter
    public int getReadyState() {
        return this.readyState_;
    }

    @JsxGetter
    public Object getResult() {
        return this.result_;
    }

    @JsxFunction
    public void readAsDataURL(Object object) throws IOException {
        this.readyState_ = 1;
        this.result_ = "data:";
        byte[] bytes = ((Blob)object).getBytes();
        String value = new String(Base64.encodeBase64((byte[])bytes), StandardCharsets.US_ASCII);
        BrowserVersion browserVersion = this.getBrowserVersion();
        String contentType = ((Blob)object).getType();
        if (StringUtils.isEmpty((CharSequence)contentType) && !browserVersion.hasFeature(BrowserVersionFeatures.JS_FILEREADER_EMPTY_NULL)) {
            contentType = "application/octet-stream";
        }
        if (object instanceof File) {
            java.io.File file = ((File)object).getFile();
            contentType = value.isEmpty() ? URLConnection.guessContentTypeFromName(file.getName()) : Files.probeContentType(file.toPath());
        }
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_FILEREADER_EMPTY_NULL)) {
            if (value.isEmpty()) {
                this.result_ = "null";
            } else {
                if (contentType != null) {
                    this.result_ = this.result_ + contentType;
                }
                this.result_ = this.result_ + ";base64," + value;
            }
        } else {
            boolean includeConentType = browserVersion.hasFeature(BrowserVersionFeatures.JS_FILEREADER_CONTENT_TYPE);
            if (!value.isEmpty() || includeConentType) {
                if (contentType == null) {
                    contentType = "application/octet-stream";
                }
                this.result_ = this.result_ + contentType + ";base64," + value;
            }
        }
        this.readyState_ = 2;
        Event event = new Event(this, "load");
        this.fireEvent(event);
    }

    @JsxFunction
    public void readAsArrayBuffer(Object object) {
        this.readyState_ = 1;
        if (object instanceof Blob) {
            byte[] bytes = ((Blob)object).getBytes();
            NativeArrayBuffer buffer = new NativeArrayBuffer((double)bytes.length);
            System.arraycopy(bytes, 0, buffer.getBuffer(), 0, bytes.length);
            buffer.setParentScope(this.getParentScope());
            buffer.setPrototype(ScriptableObject.getClassPrototype((Scriptable)this.getWindow(), (String)buffer.getClassName()));
            this.result_ = buffer;
        }
        this.readyState_ = 2;
        Event event = new Event(this, "load");
        this.fireEvent(event);
    }

    @JsxFunction
    public void readAsText(Object object, Object encoding) {
        Charset charset;
        block4: {
            String encAsString;
            this.readyState_ = 1;
            charset = StandardCharsets.UTF_8;
            if (encoding != null && !JavaScriptEngine.isUndefined(encoding) && StringUtils.isNotBlank((CharSequence)(encAsString = JavaScriptEngine.toString(encoding)))) {
                try {
                    charset = Charsets.toCharset((String)encAsString.trim().toLowerCase(Locale.ROOT));
                }
                catch (UnsupportedCharsetException e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    LOG.warn((Object)("FileReader readAsText was called with an unsupported encoding '" + encoding + "'. Using UTF-8 instead."));
                }
            }
        }
        if (object instanceof Blob) {
            this.result_ = new String(((Blob)object).getBytes(), charset);
        }
        this.readyState_ = 2;
        Event event = new Event(this, "load");
        this.fireEvent(event);
    }

    @JsxGetter
    public Function getOnload() {
        return this.getEventHandler("load");
    }

    @JsxSetter
    public void setOnload(Object onload) {
        this.setEventHandler("load", onload);
    }

    @JsxGetter
    public Function getOnerror() {
        return this.getEventHandler("error");
    }

    @JsxSetter
    public void setOnerror(Object onerror) {
        this.setEventHandler("error", onerror);
    }
}

