/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import com.xceptance.xlt.report.util.IntMinMaxValue;
import java.util.Arrays;

public class IntMinMaxValueSet {
    public static final int DEFAULT_SIZE = 1024;
    private int firstSecond;
    private int lastSecond;
    private long maximumTime;
    private long minimumTime;
    private int scale = 1;
    private int scale2 = 0;
    private final int size;
    private long valueCount;
    private final IntMinMaxValue[] values;

    public IntMinMaxValueSet() {
        this(1024);
    }

    public IntMinMaxValueSet(int size) {
        this.size = size << 1;
        this.values = new IntMinMaxValue[this.size];
    }

    public void addOrUpdateValue(long time, int value) {
        int index;
        IntMinMaxValue item;
        int second = (int)((double)time * 0.001) & ~(this.scale - 1);
        if (this.valueCount == 0L) {
            this.firstSecond = this.lastSecond = second;
            this.values[0] = new IntMinMaxValue(value);
            this.minimumTime = this.maximumTime = time;
            this.valueCount = 1L;
            return;
        }
        if (second != this.firstSecond) {
            int s1;
            if (second > this.firstSecond) {
                while (second - this.firstSecond >> this.scale2 >= this.size) {
                    this.scale <<= 1;
                    ++this.scale2;
                    this.shrink();
                    s1 = ~(this.scale - 1);
                    second &= s1;
                    this.firstSecond &= s1;
                    this.lastSecond &= s1;
                }
                this.lastSecond = Math.max(this.lastSecond, second);
            } else {
                while (this.lastSecond - second >> this.scale2 >= this.size) {
                    this.scale <<= 1;
                    ++this.scale2;
                    this.shrink();
                    s1 = ~(this.scale - 1);
                    second &= s1;
                    this.firstSecond &= s1;
                    this.lastSecond &= s1;
                }
                if (second < this.firstSecond) {
                    int indexDiff = this.firstSecond - second >> this.scale2;
                    this.shift(indexDiff);
                    this.firstSecond = second;
                }
            }
        }
        if ((item = this.values[index = second - this.firstSecond >> this.scale2]) != null) {
            item.updateValue(value);
        } else {
            this.values[index] = new IntMinMaxValue(value);
        }
        ++this.valueCount;
        this.minimumTime = Math.min(this.minimumTime, time);
        this.maximumTime = Math.max(this.maximumTime, time);
    }

    public long getFirstSecond() {
        if (this.valueCount == 0L) {
            throw new IllegalStateException("No first second available as no values have been added so far.");
        }
        return this.firstSecond * 1000;
    }

    public long getMaximumTime() {
        if (this.valueCount == 0L) {
            throw new IllegalStateException("No maximum time available as no values have been added so far.");
        }
        return this.maximumTime;
    }

    public long getMinimumTime() {
        if (this.valueCount == 0L) {
            throw new IllegalStateException("No minimum time available as no values have been added so far.");
        }
        return this.minimumTime;
    }

    public int getScale() {
        return this.scale;
    }

    public int getSize() {
        return this.size / 2;
    }

    public long getValueCount() {
        return this.valueCount;
    }

    public IntMinMaxValue[] getValues() {
        IntMinMaxValue[] copy;
        if (this.valueCount == 0L) {
            copy = new IntMinMaxValue[]{};
        } else {
            int length = (this.lastSecond - this.firstSecond) / this.scale + 1;
            copy = new IntMinMaxValue[length];
            System.arraycopy(this.values, 0, copy, 0, length);
        }
        return copy;
    }

    private void shift(int indexDiff) {
        System.arraycopy(this.values, 0, this.values, indexDiff, this.size - indexDiff);
        Arrays.fill(this.values, 0, indexDiff, null);
    }

    private void shrink() {
        int i;
        int offset;
        int j = offset = (this.firstSecond & this.scale - 1) > 0 ? 1 : 0;
        for (i = offset; i < this.size - 1; i += 2) {
            IntMinMaxValue v1 = this.values[i];
            IntMinMaxValue v2 = this.values[i + 1];
            IntMinMaxValue rv = null;
            if (v1 != null) {
                rv = v1.merge(v2);
            } else if (v2 != null) {
                rv = v2;
            }
            this.values[i] = null;
            this.values[i + 1] = null;
            this.values[j] = rv;
            ++j;
        }
        if (i < this.size) {
            this.values[j] = this.values[i];
            this.values[i] = null;
        }
    }
}

