/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.xceptance.common.collection.FastHashMap;
import com.xceptance.xlt.report.providers.EventMessageInfo;
import java.util.List;

@XStreamAlias(value="event")
public class EventReport {
    public int totalCount = 0;
    public int droppedCount;
    public final String name;
    public String testCaseName;
    public transient FastHashMap<String, EventMessageInfo> messageMap = new FastHashMap(23, 0.5f);
    public List<EventMessageInfo> messages;

    public EventReport(String testCaseName, String name) {
        this.testCaseName = testCaseName;
        this.name = name;
    }

    public void addMessage(String message, int limit) {
        ++this.totalCount;
        EventMessageInfo info = this.messageMap.get(message);
        if (info == null) {
            if (this.messageMap.size() >= limit) {
                ++this.droppedCount;
                return;
            }
            info = new EventMessageInfo();
            info.info = message;
            this.messageMap.put(message, info);
        }
        ++info.count;
    }

    public void prepareSerialization() {
        this.messages = this.messageMap.values();
        this.messageMap = null;
    }

    public void setTestCaseName(String testCaseName) {
        this.testCaseName = testCaseName;
    }
}

