/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.common.io.FileUtils;
import com.xceptance.xlt.api.engine.ActionData;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.engine.TimerData;
import com.xceptance.xlt.api.engine.TransactionData;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.api.report.ReportProviderConfiguration;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.resultbrowser.RequestHistory;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import com.xceptance.xlt.report.providers.ErrorReport;
import com.xceptance.xlt.report.providers.ErrorsReport;
import com.xceptance.xlt.report.providers.RequestErrorChartReport;
import com.xceptance.xlt.report.providers.TransactionOverviewChartReport;
import com.xceptance.xlt.report.util.JFreeChartUtils;
import com.xceptance.xlt.report.util.TaskManager;
import com.xceptance.xlt.report.util.ValueSet;
import it.unimi.dsi.util.FastRandom;
import java.awt.Color;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class ErrorsReportProvider
extends AbstractReportProvider {
    private int directoryLimitPerError;
    private double directoryReplacementChance;
    private FileObject resultsDirectory;
    private final RequestHistory.DumpMode dumpMode;
    private final Map<String, ErrorValues> errorReports = new HashMap<String, ErrorValues>();
    private final ValueSet transactionErrorsPerSecondValueSet = new ValueSet();
    private final ValueSet actionErrorsPerSecondValueSet = new ValueSet();
    private final ValueSet requestErrorsPerSecondValueSet = new ValueSet();
    private final Map<Integer, TransactionErrorOverviewValues> transactionErrorOverviewValues = new HashMap<Integer, TransactionErrorOverviewValues>();
    private final Map<String, ValueSet> requestErrorOverviewValues = new HashMap<String, ValueSet>();
    private final FastRandom random = new FastRandom(98765111L);

    public ErrorsReportProvider() {
        String dumpModeValue = XltProperties.getInstance().getProperty("com.xceptance.xlt.output2disk", "onError");
        this.dumpMode = RequestHistory.DumpMode.valueFrom(dumpModeValue);
    }

    @Override
    public void setConfiguration(ReportProviderConfiguration config) {
        super.setConfiguration(config);
        this.directoryLimitPerError = this.getConfiguration().getDirectoryLimitPerError();
        this.directoryReplacementChance = this.getConfiguration().getDirectoryReplacementChance();
        this.resultsDirectory = this.getConfiguration().getResultsDirectory();
    }

    @Override
    public Object createReportFragment() {
        ArrayList<TransactionOverviewChartReport> availableTransactionErrorOverviewCharts = new ArrayList<TransactionOverviewChartReport>();
        ArrayList<RequestErrorChartReport> availableRequestErrorCharts = new ArrayList<RequestErrorChartReport>();
        if (this.getConfiguration().shouldChartsGenerated()) {
            List<Object> selectedErrors;
            int chartCount;
            TaskManager taskManager = TaskManager.getInstance();
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    int minMaxValueSetSize = ErrorsReportProvider.this.getConfiguration().getChartWidth();
                    TimeSeries transactionErrorsPerSecondTimeSeries = JFreeChartUtils.toStandardTimeSeries(ErrorsReportProvider.this.transactionErrorsPerSecondValueSet.toMinMaxValueSet(minMaxValueSetSize), "Transaction Errors/s");
                    TimeSeries actionErrorsPerSecondTimeSeries = JFreeChartUtils.toStandardTimeSeries(ErrorsReportProvider.this.actionErrorsPerSecondValueSet.toMinMaxValueSet(minMaxValueSetSize), "Action Errors/s");
                    TimeSeries requestErrorsPerSecondTimeSeries = JFreeChartUtils.toStandardTimeSeries(ErrorsReportProvider.this.requestErrorsPerSecondValueSet.toMinMaxValueSet(minMaxValueSetSize), "Request Errors/s");
                    ErrorsReportProvider.this.createErrorsChart(transactionErrorsPerSecondTimeSeries, actionErrorsPerSecondTimeSeries, requestErrorsPerSecondTimeSeries);
                }
            });
            if (this.getConfiguration().createRequestErrorOverviewCharts()) {
                chartCount = this.getChartCount(this.getConfiguration().getRequestErrorOverviewChartLimit(), this.requestErrorOverviewValues.size());
                selectedErrors = this.getRequestOverviewErrorsSortedByOccurrence().subList(0, chartCount);
                for (Map.Entry<String, ValueSet> entry : selectedErrors) {
                    RequestErrorChartReport requestErrorChartReport = new RequestErrorChartReport();
                    requestErrorChartReport.id = Integer.valueOf(entry.getKey());
                    availableRequestErrorCharts.add(requestErrorChartReport);
                }
                taskManager.addTask(new Runnable(){

                    @Override
                    public void run() {
                        for (Map.Entry eachEntry : selectedErrors) {
                            String responseCode = (String)eachEntry.getKey();
                            ValueSet data = (ValueSet)eachEntry.getValue();
                            ErrorsReportProvider.this.createRequestErrorOverviewChart(responseCode, data);
                        }
                    }
                });
            }
            if (this.getConfiguration().createTransactionErrorOverviewCharts()) {
                chartCount = this.getChartCount(this.getConfiguration().getTransactionErrorOverviewChartLimit(), this.transactionErrorOverviewValues.size());
                selectedErrors = this.getTransactionErrorsSortedByOccurrence().subList(0, chartCount);
                for (TransactionErrorOverviewValues transactionErrorOverviewValues : selectedErrors) {
                    availableTransactionErrorOverviewCharts.add(transactionErrorOverviewValues.getChartReport());
                }
                taskManager.addTask(new Runnable(){

                    @Override
                    public void run() {
                        for (TransactionErrorOverviewValues eachEntry : selectedErrors) {
                            ErrorsReportProvider.this.createTransactionErrorOverviewChart(eachEntry);
                        }
                    }
                });
            }
            if (this.getConfiguration().createErrorDetailsCharts()) {
                chartCount = this.getChartCount(this.getConfiguration().getErrorDetailsChartLimit(), this.errorReports.size());
                selectedErrors = this.getErrorsSortedByOccurrence().subList(0, chartCount);
                for (ErrorValues errorValues : selectedErrors) {
                    errorValues.errorReport.detailChartID = System.identityHashCode(errorValues.errorReport);
                }
                taskManager.addTask(new Runnable(){

                    @Override
                    public void run() {
                        for (ErrorValues eachErrorValues : selectedErrors) {
                            ErrorsReportProvider.this.createErrorDetailsChart(eachErrorValues);
                        }
                    }
                });
            }
        }
        ErrorsReport errorReport = new ErrorsReport();
        errorReport.errors = this.getErrorReports();
        errorReport.requestErrorOverviewCharts = availableRequestErrorCharts;
        errorReport.transactionErrorOverviewCharts = availableTransactionErrorOverviewCharts;
        this.sortDirectoryHints(errorReport);
        String temp = this.computePathPrefix();
        if (temp != null) {
            errorReport.resultsPathPrefix = temp + "/";
        }
        return errorReport;
    }

    private int getChartCount(int configuredCount, int collectionSize) {
        if (configuredCount < 0 || configuredCount > collectionSize) {
            return collectionSize;
        }
        return configuredCount;
    }

    private List<Map.Entry<String, ValueSet>> getRequestOverviewErrorsSortedByOccurrence() {
        ArrayList<Map.Entry<String, ValueSet>> errors = new ArrayList<Map.Entry<String, ValueSet>>(this.requestErrorOverviewValues.entrySet());
        Collections.sort(errors, Collections.reverseOrder(new Comparator<Map.Entry<String, ValueSet>>(){

            @Override
            public int compare(Map.Entry<String, ValueSet> o1, Map.Entry<String, ValueSet> o2) {
                return Long.compare(o1.getValue().getValueCount(), o2.getValue().getValueCount());
            }
        }));
        return errors;
    }

    private List<ErrorValues> getErrorsSortedByOccurrence() {
        ArrayList<ErrorValues> errors = new ArrayList<ErrorValues>(this.errorReports.values());
        Collections.sort(errors, Collections.reverseOrder(new Comparator<ErrorValues>(){

            @Override
            public int compare(ErrorValues o1, ErrorValues o2) {
                return Integer.compare(o1.getErrorReport().count, o2.getErrorReport().count);
            }
        }));
        return errors;
    }

    private List<TransactionErrorOverviewValues> getTransactionErrorsSortedByOccurrence() {
        ArrayList<TransactionErrorOverviewValues> errors = new ArrayList<TransactionErrorOverviewValues>(this.transactionErrorOverviewValues.values());
        Collections.sort(errors, Collections.reverseOrder(new Comparator<TransactionErrorOverviewValues>(){

            @Override
            public int compare(TransactionErrorOverviewValues o1, TransactionErrorOverviewValues o2) {
                return Long.compare(o1.getValues().getValueCount(), o2.getValues().getValueCount());
            }
        }));
        return errors;
    }

    private void createRequestErrorOverviewChart(String responseCode, ValueSet data) {
        String title = "(" + responseCode + ")";
        String fileName = "r" + responseCode;
        int width = this.getConfiguration().getChartWidth();
        int height = (int)((double)this.getConfiguration().getChartHeight() / 2.8);
        this.createErrorChart(data, fileName, title, "Errors", "Errors", width, height, false, false);
    }

    private void createErrorDetailsChart(ErrorValues errorValues) {
        ErrorReport errorReport = errorValues.getErrorReport();
        String title = null;
        String fileName = "d" + errorReport.detailChartID;
        ValueSet data = errorValues.getValues();
        int detailsWidth = (int)((double)this.getConfiguration().getChartWidth() / 1.4);
        int detailsHeight = (int)((double)this.getConfiguration().getChartHeight() / 3.5);
        this.createErrorChart(data, fileName, title, null, "Errors", detailsWidth, detailsHeight, false, false);
    }

    private void createTransactionErrorOverviewChart(TransactionErrorOverviewValues errorOverview) {
        String title = (String)StringUtils.defaultIfBlank((CharSequence)errorOverview.getErrorMessage(), (CharSequence)"");
        String fileName = "t" + errorOverview.getOverviewChartID();
        ValueSet data = errorOverview.getValues();
        int overviewWidth = this.getConfiguration().getChartWidth();
        int overviewHeight = (int)((double)this.getConfiguration().getChartHeight() / 2.8);
        this.createErrorChart(data, fileName, title, "Errors", "Errors", overviewWidth, overviewHeight, false, false);
    }

    private void createErrorChart(ValueSet data, String chartName, String chartTitle, String yAxisTitle, String dataName, int width, int height, boolean createLegend, boolean createTimeAxis) {
        int minMaxValueSetSize = width;
        TimeSeries eachErrorTimeSeries = JFreeChartUtils.toStandardTimeSeries(data.toMinMaxValueSet(minMaxValueSetSize), dataName);
        TimeSeriesCollection eachErrorTimeSeriesCollection = new TimeSeriesCollection(eachErrorTimeSeries);
        JFreeChart chart = JFreeChartUtils.createBarChart(chartTitle, (XYDataset)eachErrorTimeSeriesCollection, yAxisTitle, Color.RED, this.getConfiguration().getChartStartTime(), this.getConfiguration().getChartEndTime(), createLegend, createTimeAxis);
        JFreeChartUtils.saveChart(chart, chartName, new File(this.getConfiguration().getChartDirectory(), "errors"), width, height);
    }

    private List<ErrorReport> getErrorReports() {
        ArrayList<ErrorReport> reports = new ArrayList<ErrorReport>(this.errorReports.size());
        for (ErrorValues eachErrorValues : this.errorReports.values()) {
            reports.add(eachErrorValues.getErrorReport());
        }
        return reports;
    }

    private void sortDirectoryHints(ErrorsReport errorsReport) {
        for (ErrorReport errorReport : errorsReport.errors) {
            Collections.sort(errorReport.directoryHints);
        }
    }

    @Override
    public void processDataRecord(Data stat) {
        TransactionData txnStats;
        String trace;
        if (stat instanceof TransactionData && (trace = (txnStats = (TransactionData)stat).getFailureStackTrace()) != null) {
            String directoryHint;
            ErrorReport errorReport;
            String failedActionName;
            String testCaseName = txnStats.getName();
            String key = testCaseName + "|" + (failedActionName = txnStats.getFailedActionName()) + "|" + trace;
            ErrorValues errorValues = this.errorReports.get(key);
            if (errorValues == null) {
                errorReport = new ErrorReport();
                errorReport.trace = trace;
                errorReport.message = txnStats.getFailureMessage();
                errorReport.testCaseName = testCaseName;
                errorReport.actionName = failedActionName;
                errorReport.detailChartID = 0;
                errorValues = new ErrorValues(errorReport);
                this.errorReports.put(key, errorValues);
            }
            errorReport = errorValues.getErrorReport();
            if (this.getConfiguration().createErrorDetailsCharts()) {
                errorValues.getValues().addOrUpdateValue(txnStats.getEndTime(), 1);
            }
            if (this.getConfiguration().createTransactionErrorOverviewCharts()) {
                int id = this.getTransactionErrorOverviewChartID(errorReport.message);
                TransactionErrorOverviewValues overviewErrorValues = this.transactionErrorOverviewValues.get(id);
                if (overviewErrorValues == null) {
                    overviewErrorValues = new TransactionErrorOverviewValues(errorReport.message, id);
                    this.transactionErrorOverviewValues.put(id, overviewErrorValues);
                }
                overviewErrorValues.getValues().addOrUpdateValue(txnStats.getEndTime(), 1);
            }
            ++errorReport.count;
            if (this.dumpMode != RequestHistory.DumpMode.NEVER && (directoryHint = txnStats.getDumpDirectoryPath()) != null) {
                boolean safeToAdd;
                boolean bl = safeToAdd = errorReport.directoryHints.size() < this.directoryLimitPerError;
                if (safeToAdd || this.random.nextDoubleFast() <= this.directoryReplacementChance) {
                    String indexFilePath = directoryHint + "/index.html";
                    try {
                        if (VFS.getManager().resolveFile(this.resultsDirectory, indexFilePath).exists()) {
                            if (safeToAdd) {
                                errorReport.directoryHints.add(directoryHint);
                            } else {
                                errorReport.directoryHints.set(this.random.nextInt(this.directoryLimitPerError), directoryHint);
                            }
                        }
                    }
                    catch (FileSystemException e) {
                        XltLogger.reportLogger.warn("Unable to check if '{}' exists in '{}'", (Object)indexFilePath, (Object)this.resultsDirectory.getName().getPath());
                    }
                }
            }
        }
        if (stat instanceof TimerData) {
            RequestData requestData;
            int code;
            ValueSet errorsPerSecondValueSet;
            TimerData timerData = (TimerData)stat;
            if (timerData.hasFailed() && (errorsPerSecondValueSet = timerData instanceof TransactionData ? this.transactionErrorsPerSecondValueSet : (timerData instanceof ActionData ? this.actionErrorsPerSecondValueSet : (timerData instanceof RequestData ? this.requestErrorsPerSecondValueSet : null))) != null) {
                errorsPerSecondValueSet.addOrUpdateValue(timerData.getEndTime(), 1);
            }
            if (this.getConfiguration().createRequestErrorOverviewCharts() && timerData instanceof RequestData && ((code = (requestData = (RequestData)timerData).getResponseCode()) == 0 || code >= 500)) {
                String responseCode = String.valueOf(code);
                ValueSet valueSet = this.requestErrorOverviewValues.get(responseCode);
                if (valueSet == null) {
                    valueSet = new ValueSet();
                    this.requestErrorOverviewValues.put(responseCode, valueSet);
                }
                valueSet.addOrUpdateValue(requestData.getEndTime(), 1);
            }
        }
    }

    private String computePathPrefix() {
        String pathPrefix = null;
        ReportGeneratorConfiguration config = this.getConfiguration();
        if (config.isGenerateErrorLinks()) {
            URI linkedResultsBaseUri = config.getLinkedResultsBaseUri();
            if (linkedResultsBaseUri != null) {
                pathPrefix = this.appendPathToUri(linkedResultsBaseUri, config.getResultsDirectoryName());
            } else {
                FileObject resultDir = config.getResultsDirectory();
                if (resultDir instanceof LocalFile) {
                    File reportDir = config.getReportDirectory();
                    File resultsDirAsFile = FileUtils.convertLocalFileToFile((LocalFile)resultDir);
                    pathPrefix = FileUtils.computeRelativeUri(reportDir, resultsDirAsFile, true);
                }
            }
        }
        return pathPrefix;
    }

    private String appendPathToUri(URI uri, String path) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(uri.toString());
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        sb.append(path);
        return sb.toString();
    }

    private void createErrorsChart(TimeSeries transactionErrorsPerSecondTimeSeries, TimeSeries actionErrorsPerSecondTimeSeries, TimeSeries requestErrorsPerSecondTimeSeries) {
        TimeSeriesCollection transactionErrors = new TimeSeriesCollection(transactionErrorsPerSecondTimeSeries);
        TimeSeriesCollection actionErrors = new TimeSeriesCollection(actionErrorsPerSecondTimeSeries);
        TimeSeriesCollection requestErrors = new TimeSeriesCollection(requestErrorsPerSecondTimeSeries);
        CombinedDomainXYPlot combinedPlot = JFreeChartUtils.createCombinedPlot(this.getConfiguration().getChartStartTime(), this.getConfiguration().getChartEndTime());
        combinedPlot.add(JFreeChartUtils.createBarPlot((XYDataset)transactionErrors, null, "Transaction Errors", Color.RED));
        combinedPlot.add(JFreeChartUtils.createBarPlot((XYDataset)actionErrors, null, "Action Errors", Color.RED));
        combinedPlot.add(JFreeChartUtils.createBarPlot((XYDataset)requestErrors, null, "Request Errors", Color.RED));
        JFreeChart chart = JFreeChartUtils.createChart("Errors", (Plot)combinedPlot);
        JFreeChartUtils.saveChart(chart, "Errors", this.getConfiguration().getChartDirectory(), this.getConfiguration().getChartWidth(), 2 * this.getConfiguration().getChartHeight());
    }

    @Override
    public ReportGeneratorConfiguration getConfiguration() {
        return (ReportGeneratorConfiguration)super.getConfiguration();
    }

    private int getTransactionErrorOverviewChartID(String errorMessage) {
        return StringUtils.defaultString((String)errorMessage).hashCode();
    }

    private static class TransactionErrorOverviewValues {
        private final ValueSet values = new ValueSet();
        private final TransactionOverviewChartReport chartReport = new TransactionOverviewChartReport();

        public TransactionErrorOverviewValues(String errorMessage, int overviewChartID) {
            this.chartReport.id = overviewChartID;
            this.chartReport.title = errorMessage;
        }

        public int getOverviewChartID() {
            return this.chartReport.id;
        }

        public ValueSet getValues() {
            return this.values;
        }

        public String getErrorMessage() {
            return this.chartReport.title;
        }

        public TransactionOverviewChartReport getChartReport() {
            return this.chartReport;
        }
    }

    private static class ErrorValues {
        private final ErrorReport errorReport;
        private final ValueSet values = new ValueSet();

        public ErrorValues(ErrorReport errorReport) {
            this.errorReport = errorReport;
        }

        public ErrorReport getErrorReport() {
            return this.errorReport;
        }

        public ValueSet getValues() {
            return this.values;
        }
    }
}

