/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.TimerData;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import com.xceptance.xlt.report.providers.AbstractDataProcessor;
import com.xceptance.xlt.report.providers.TimerReport;
import com.xceptance.xlt.report.providers.TransactionDataProcessor;
import com.xceptance.xlt.report.util.FixedSizeHistogramValueSet;
import com.xceptance.xlt.report.util.IntMinMaxValueSet;
import com.xceptance.xlt.report.util.IntSummaryStatistics;
import com.xceptance.xlt.report.util.JFreeChartUtils;
import com.xceptance.xlt.report.util.ReportUtils;
import com.xceptance.xlt.report.util.RuntimeHistogram;
import com.xceptance.xlt.report.util.TaskManager;
import com.xceptance.xlt.report.util.ValueSet;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeries;

public class BasicTimerDataProcessor
extends AbstractDataProcessor {
    private final ValueSet countPerSecondValueSet = new ValueSet();
    private final ValueSet errorsPerSecondValueSet = new ValueSet();
    private final IntSummaryStatistics runTimeStatistics = new IntSummaryStatistics();
    private final RuntimeHistogram runTimeHistogram = new RuntimeHistogram(10);
    private double[] percentiles;
    private final IntMinMaxValueSet runTimeValueSet;
    private final FixedSizeHistogramValueSet histogramValueSet;
    private int totalErrors = 0;
    private final int minMaxValueSetSize = this.getChartWidth();

    public BasicTimerDataProcessor(String name, AbstractReportProvider provider) {
        super(name, provider);
        this.runTimeValueSet = new IntMinMaxValueSet(this.minMaxValueSetSize);
        this.histogramValueSet = new FixedSizeHistogramValueSet(this.getChartHeight());
        this.percentiles = ((ReportGeneratorConfiguration)this.getConfiguration()).getRuntimePercentiles();
    }

    public TimerReport createTimerReport(boolean generateHistogram) {
        final String name = this.getName();
        final TimerReport timerReport = this.createTimerReport();
        timerReport.mean = ReportUtils.convertToBigDecimal(this.runTimeStatistics.getMean());
        timerReport.errors = this.totalErrors;
        timerReport.max = this.runTimeStatistics.getMaximum();
        timerReport.min = this.runTimeStatistics.getMinimum();
        timerReport.name = name;
        timerReport.deviation = ReportUtils.convertToBigDecimal(this.runTimeStatistics.getStandardDeviation());
        timerReport.median = ReportUtils.convertToBigDecimal(this.runTimeHistogram.getMedianValue());
        for (double percentile : this.percentiles) {
            timerReport.percentiles.put("p" + ReportUtils.formatValue(percentile), ReportUtils.convertToBigDecimal(this.runTimeHistogram.getPercentile(percentile)));
        }
        double count = this.runTimeStatistics.getCount();
        long duration = Math.max((this.getEndTime() - this.getStartTime()) / 1000L, 1L);
        timerReport.count = (int)count;
        timerReport.countPerSecond = ReportUtils.convertToBigDecimal(count / (double)duration);
        timerReport.countPerMinute = ReportUtils.convertToBigDecimal(count * 60.0 / (double)duration);
        timerReport.countPerHour = ReportUtils.convertToBigDecimal(count * 3600.0 / (double)duration);
        timerReport.countPerDay = ReportUtils.convertToBigDecimal(count * 86400.0 / (double)duration);
        if (this.getConfiguration().shouldChartsGenerated()) {
            final TimeSeries runTimeTimeSeries = JFreeChartUtils.toMinMaxTimeSeries(this.runTimeValueSet, "Runtime");
            final TimeSeries runTimeAverageTimeSeries = JFreeChartUtils.createMovingAverageTimeSeries(runTimeTimeSeries, this.getMovingAveragePercentage());
            TaskManager taskManager = TaskManager.getInstance();
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    int chartCappingValue = JFreeChartUtils.getChartCappingValue(BasicTimerDataProcessor.this.getChartCappingInfo(), BasicTimerDataProcessor.this.runTimeStatistics.getMean(), BasicTimerDataProcessor.this.runTimeStatistics.getMaximum());
                    XYIntervalSeries runTimeHistogramSeries = BasicTimerDataProcessor.this.histogramValueSet.toSeries("Distribution");
                    TimeSeries errorsPerSecondTimeSeries = JFreeChartUtils.toStandardTimeSeries(BasicTimerDataProcessor.this.errorsPerSecondValueSet.toMinMaxValueSet(BasicTimerDataProcessor.this.minMaxValueSetSize), "Errors/s");
                    BasicTimerDataProcessor.this.saveResponseTimeChart(name, runTimeTimeSeries, runTimeAverageTimeSeries, runTimeHistogramSeries, errorsPerSecondTimeSeries, chartCappingValue);
                }
            });
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    BasicTimerDataProcessor.this.saveResponseTimeAverageChart(name, runTimeTimeSeries, runTimeAverageTimeSeries, timerReport.median.doubleValue(), timerReport.mean.doubleValue());
                }
            });
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    TimeSeries countPerSecondTimeSeries = JFreeChartUtils.toMinMaxTimeSeries(BasicTimerDataProcessor.this.countPerSecondValueSet.toMinMaxValueSet(BasicTimerDataProcessor.this.minMaxValueSetSize), "Count/s");
                    BasicTimerDataProcessor.this.saveCountPerSecondChart(name, countPerSecondTimeSeries);
                }
            });
        }
        return timerReport;
    }

    @Override
    public void processDataRecord(Data stat) {
        TimerData timerStats = (TimerData)stat;
        long endTime = timerStats.getEndTime();
        int runTime = timerStats.getRunTime();
        this.runTimeHistogram.addValue(runTime);
        this.runTimeStatistics.addValue(runTime);
        this.runTimeValueSet.addOrUpdateValue(endTime, runTime);
        this.countPerSecondValueSet.addOrUpdateValue(endTime, 1);
        this.histogramValueSet.addValue(runTime);
        if (timerStats.hasFailed()) {
            ++this.totalErrors;
            this.errorsPerSecondValueSet.addOrUpdateValue(endTime, 1);
        }
    }

    protected ValueSet getCountPerSecondValueSet() {
        return this.countPerSecondValueSet;
    }

    protected ValueSet getErrorsPerSecondValueSet() {
        return this.errorsPerSecondValueSet;
    }

    protected FixedSizeHistogramValueSet getHistogramValueSet() {
        return this.histogramValueSet;
    }

    protected JFreeChart createResponseTimeAndErrorsChart(String chartTitle, TimeSeries responseTimeSeries, TimeSeries responseTimeAverageSeries, XYIntervalSeries responseTimeHistogramSeries, TimeSeries errorsSeries, int chartCappingValue) {
        ReportGeneratorConfiguration.ChartScale chartScale = ((ReportGeneratorConfiguration)this.getConfiguration()).getChartScale();
        Range responseTimeRange = null;
        CombinedRangeXYPlot outerCombinedPlot = new CombinedRangeXYPlot();
        outerCombinedPlot.setGap(4.0);
        outerCombinedPlot.getRangeAxis().setVisible(false);
        CombinedDomainXYPlot leftCombinedPlot = JFreeChartUtils.createCombinedPlot(this.getStartTime(), this.getEndTime());
        outerCombinedPlot.add((XYPlot)leftCombinedPlot, 15);
        XYPlot responseTimePlot = JFreeChartUtils.createLinePlot(responseTimeSeries, responseTimeAverageSeries, null, "Runtime [ms]", true, chartScale, chartCappingValue);
        leftCombinedPlot.add(responseTimePlot, 3);
        XYPlot errorPlot = JFreeChartUtils.createBarPlot((XYDataset)new TimeSeriesCollection(errorsSeries), null, "Errors", JFreeChartUtils.COLOR_ERROR);
        leftCombinedPlot.add(errorPlot, 1);
        responseTimeRange = responseTimePlot.getRangeAxis().getRange();
        CombinedDomainXYPlot rightCombinedPlot = new CombinedDomainXYPlot();
        rightCombinedPlot.setGap(16.0);
        rightCombinedPlot.getDomainAxis().setVisible(false);
        outerCombinedPlot.add((XYPlot)rightCombinedPlot, 1);
        XYPlot histogramPlot = JFreeChartUtils.createHistogramPlot(responseTimeHistogramSeries, responseTimeRange, chartScale, chartCappingValue);
        rightCombinedPlot.add(histogramPlot, 3);
        XYPlot spacerPlot = JFreeChartUtils.createSpacerPlot();
        rightCombinedPlot.add(spacerPlot, 1);
        JFreeChart jfreechart = JFreeChartUtils.createChart(chartTitle, (Plot)outerCombinedPlot);
        return jfreechart;
    }

    private JFreeChart createResponseTimeAverageChart(String name, TimeSeries responseTimeSeries, TimeSeries responseTimeAverageSeries, double median, double mean) {
        JFreeChart chart = JFreeChartUtils.createAverageLineChart("Runtime", name, "Runtime [ms]", responseTimeSeries, responseTimeAverageSeries, median, mean, this.getStartTime(), this.getEndTime());
        return chart;
    }

    protected TimerReport createTimerReport() {
        return new TimerReport();
    }

    private void saveCountPerSecondChart(String timerName, TimeSeries timeSeries) {
        JFreeChart chart = JFreeChartUtils.createLineChart(timerName, "Count", timeSeries, this.getStartTime(), this.getEndTime(), true, this.getMovingAveragePercentage());
        JFreeChartUtils.saveChart(chart, timerName + "_CountPerSecond", this.getChartDir(), this.getChartWidth(), this.getChartHeight());
    }

    private void saveResponseTimeAverageChart(String timerName, TimeSeries responseTimeSeries, TimeSeries responseTimeAverageSeries, double median, double mean) {
        JFreeChart chart = this.createResponseTimeAverageChart(timerName, responseTimeSeries, responseTimeAverageSeries, median, mean);
        JFreeChartUtils.saveChart(chart, timerName + "_Average", this.getChartDir(), this.getChartWidth(), this.getChartHeight());
    }

    private void saveResponseTimeChart(String timerName, TimeSeries responseTimeSeries, TimeSeries responseTimeAverageSeries, XYIntervalSeries responseTimeHistogramSeries, TimeSeries errorsSeries, int chartCappingValue) {
        JFreeChart chart = this.createResponseTimeAndErrorsChart(timerName, responseTimeSeries, responseTimeAverageSeries, responseTimeHistogramSeries, errorsSeries, chartCappingValue);
        int height = this.getChartHeight();
        if (this instanceof TransactionDataProcessor) {
            height = height * 150 / 100;
        }
        JFreeChartUtils.saveChart(chart, timerName, this.getChartDir(), this.getChartWidth(), height);
    }
}

