/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.socket;

import com.xceptance.xlt.engine.RequestExecutionContext;
import com.xceptance.xlt.engine.socket.InstrumentedInputStream;
import com.xceptance.xlt.engine.socket.InstrumentedOutputStream;
import com.xceptance.xlt.engine.socket.SocketMonitor;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;

class InstrumentedSocketImpl
extends SocketImpl {
    private static final Constructor<?> CONSTRUCTOR;
    private static final Method FACTORY_METHOD;
    private static final Method ACCEPT_METHOD;
    private static final Method AVAILABLE_METHOD;
    private static final Method BIND_METHOD;
    private static final Method CLOSE_METHOD;
    private static final Method CONNECT_HOSTNAME_METHOD;
    private static final Method CONNECT_INETADDRESS_METHOD;
    private static final Method CONNECT_SOCKETADDRESS_METHOD;
    private static final Method CREATE_METHOD;
    private static final Method GETFILEDESCRIPTOR_METHOD;
    private static final Method GETINETADDRESS_METHOD;
    private static final Method GETINPUTSTREAM_METHOD;
    private static final Method GETLOCALPORT_METHOD;
    private static final Method GETOUTPUTSTREAM_METHOD;
    private static final Method GETPORT_METHOD;
    private static final Method LISTEN_METHOD;
    private static final Method SENDURGENTDATA_METHOD;
    private static final Method SETPERFORMANCEPREFERNCES_METHOD;
    private static final Method SHUTDOWNINPUT_METHOD;
    private static final Method SHUTDOWNOUTPUT_METHOD;
    private static final Method SUPPORTSURGENTDATA_METHOD;
    private final SocketImpl socketImpl;

    public static void initialize() {
    }

    public InstrumentedSocketImpl() {
        try {
            this.socketImpl = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13) ? (SocketImpl)FACTORY_METHOD.invoke(null, false) : (SocketImpl)CONSTRUCTOR.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create new socket impl instance", ex);
        }
    }

    public boolean equals(Object obj) {
        return this.socketImpl.equals(obj);
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        return this.socketImpl.getOption(optID);
    }

    public int hashCode() {
        return this.socketImpl.hashCode();
    }

    @Override
    public void setOption(int optID, Object value) throws SocketException {
        this.socketImpl.setOption(optID, value);
    }

    @Override
    public String toString() {
        return this.socketImpl.toString();
    }

    @Override
    protected void accept(SocketImpl s) throws IOException {
        this.invoke(ACCEPT_METHOD, s);
    }

    @Override
    protected int available() throws IOException {
        return (Integer)this.invoke(AVAILABLE_METHOD, new Object[0]);
    }

    @Override
    protected void bind(InetAddress host, int port) throws IOException {
        this.invoke(BIND_METHOD, host, port);
    }

    @Override
    protected void close() throws IOException {
        this.invoke(CLOSE_METHOD, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connect(InetAddress address, int port) throws IOException {
        SocketMonitor socketMonitor = RequestExecutionContext.getCurrent().getSocketMonitor();
        try {
            socketMonitor.connectingStarted();
            this.invoke(CONNECT_INETADDRESS_METHOD, address, port);
        }
        finally {
            socketMonitor.connected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connect(SocketAddress address, int timeout) throws IOException {
        SocketMonitor socketMonitor = RequestExecutionContext.getCurrent().getSocketMonitor();
        try {
            socketMonitor.connectingStarted();
            this.invoke(CONNECT_SOCKETADDRESS_METHOD, address, timeout);
        }
        finally {
            socketMonitor.connected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connect(String host, int port) throws IOException {
        SocketMonitor socketMonitor = RequestExecutionContext.getCurrent().getSocketMonitor();
        try {
            socketMonitor.connectingStarted();
            this.invoke(CONNECT_HOSTNAME_METHOD, host, port);
        }
        finally {
            socketMonitor.connected();
        }
    }

    @Override
    protected void create(boolean stream) throws IOException {
        this.invoke(CREATE_METHOD, stream);
    }

    @Override
    protected FileDescriptor getFileDescriptor() {
        return (FileDescriptor)this.invoke2(GETFILEDESCRIPTOR_METHOD, new Object[0]);
    }

    @Override
    protected InetAddress getInetAddress() {
        return (InetAddress)this.invoke2(GETINETADDRESS_METHOD, new Object[0]);
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        return new InstrumentedInputStream((InputStream)this.invoke(GETINPUTSTREAM_METHOD, new Object[0]));
    }

    @Override
    protected int getLocalPort() {
        return (Integer)this.invoke2(GETLOCALPORT_METHOD, new Object[0]);
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        return new InstrumentedOutputStream((OutputStream)this.invoke(GETOUTPUTSTREAM_METHOD, new Object[0]));
    }

    @Override
    protected int getPort() {
        return (Integer)this.invoke2(GETPORT_METHOD, new Object[0]);
    }

    @Override
    protected void listen(int backlog) throws IOException {
        this.invoke(LISTEN_METHOD, backlog);
    }

    @Override
    protected void sendUrgentData(int data) throws IOException {
        this.invoke(SENDURGENTDATA_METHOD, data);
    }

    @Override
    protected void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.invoke2(SETPERFORMANCEPREFERNCES_METHOD, connectionTime, latency, bandwidth);
    }

    @Override
    protected void shutdownInput() throws IOException {
        this.invoke(SHUTDOWNINPUT_METHOD, new Object[0]);
    }

    @Override
    protected void shutdownOutput() throws IOException {
        this.invoke(SHUTDOWNOUTPUT_METHOD, new Object[0]);
    }

    @Override
    protected boolean supportsUrgentData() {
        return (Boolean)this.invoke2(SUPPORTSURGENTDATA_METHOD, new Object[0]);
    }

    private Object invoke(Method method, Object ... args) throws IOException {
        try {
            return method.invoke((Object)this.socketImpl, args);
        }
        catch (Exception ex) {
            if (ex instanceof InvocationTargetException) {
                throw (IOException)ex.getCause();
            }
            throw new RuntimeException("Failed to execute method: " + method, ex);
        }
    }

    private Object invoke2(Method method, Object ... args) {
        try {
            return method.invoke((Object)this.socketImpl, args);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to execute method: " + method, ex);
        }
    }

    static {
        try {
            if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13)) {
                FACTORY_METHOD = SocketImpl.class.getDeclaredMethod("createPlatformSocketImpl", Boolean.TYPE);
                FACTORY_METHOD.setAccessible(true);
                CONSTRUCTOR = null;
            } else {
                CONSTRUCTOR = Class.forName("java.net.PlainSocketImpl").getDeclaredConstructor(new Class[0]);
                CONSTRUCTOR.setAccessible(true);
                FACTORY_METHOD = null;
            }
            Class<?> ABSTRACT_CLASS = Class.forName("java.net.SocketImpl");
            ACCEPT_METHOD = ABSTRACT_CLASS.getDeclaredMethod("accept", SocketImpl.class);
            ACCEPT_METHOD.setAccessible(true);
            AVAILABLE_METHOD = ABSTRACT_CLASS.getDeclaredMethod("available", new Class[0]);
            AVAILABLE_METHOD.setAccessible(true);
            BIND_METHOD = ABSTRACT_CLASS.getDeclaredMethod("bind", InetAddress.class, Integer.TYPE);
            BIND_METHOD.setAccessible(true);
            CLOSE_METHOD = ABSTRACT_CLASS.getDeclaredMethod("close", new Class[0]);
            CLOSE_METHOD.setAccessible(true);
            CONNECT_HOSTNAME_METHOD = ABSTRACT_CLASS.getDeclaredMethod("connect", String.class, Integer.TYPE);
            CONNECT_HOSTNAME_METHOD.setAccessible(true);
            CONNECT_INETADDRESS_METHOD = ABSTRACT_CLASS.getDeclaredMethod("connect", InetAddress.class, Integer.TYPE);
            CONNECT_INETADDRESS_METHOD.setAccessible(true);
            CONNECT_SOCKETADDRESS_METHOD = ABSTRACT_CLASS.getDeclaredMethod("connect", SocketAddress.class, Integer.TYPE);
            CONNECT_SOCKETADDRESS_METHOD.setAccessible(true);
            CREATE_METHOD = ABSTRACT_CLASS.getDeclaredMethod("create", Boolean.TYPE);
            CREATE_METHOD.setAccessible(true);
            GETFILEDESCRIPTOR_METHOD = ABSTRACT_CLASS.getDeclaredMethod("getFileDescriptor", new Class[0]);
            GETFILEDESCRIPTOR_METHOD.setAccessible(true);
            GETINETADDRESS_METHOD = ABSTRACT_CLASS.getDeclaredMethod("getInetAddress", new Class[0]);
            GETINETADDRESS_METHOD.setAccessible(true);
            GETINPUTSTREAM_METHOD = ABSTRACT_CLASS.getDeclaredMethod("getInputStream", new Class[0]);
            GETINPUTSTREAM_METHOD.setAccessible(true);
            GETLOCALPORT_METHOD = ABSTRACT_CLASS.getDeclaredMethod("getLocalPort", new Class[0]);
            GETLOCALPORT_METHOD.setAccessible(true);
            GETOUTPUTSTREAM_METHOD = ABSTRACT_CLASS.getDeclaredMethod("getOutputStream", new Class[0]);
            GETOUTPUTSTREAM_METHOD.setAccessible(true);
            GETPORT_METHOD = ABSTRACT_CLASS.getDeclaredMethod("getPort", new Class[0]);
            GETPORT_METHOD.setAccessible(true);
            LISTEN_METHOD = ABSTRACT_CLASS.getDeclaredMethod("listen", Integer.TYPE);
            LISTEN_METHOD.setAccessible(true);
            SENDURGENTDATA_METHOD = ABSTRACT_CLASS.getDeclaredMethod("sendUrgentData", Integer.TYPE);
            SENDURGENTDATA_METHOD.setAccessible(true);
            SETPERFORMANCEPREFERNCES_METHOD = ABSTRACT_CLASS.getDeclaredMethod("setPerformancePreferences", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            SETPERFORMANCEPREFERNCES_METHOD.setAccessible(true);
            SHUTDOWNINPUT_METHOD = ABSTRACT_CLASS.getDeclaredMethod("shutdownInput", new Class[0]);
            SHUTDOWNINPUT_METHOD.setAccessible(true);
            SHUTDOWNOUTPUT_METHOD = ABSTRACT_CLASS.getDeclaredMethod("shutdownOutput", new Class[0]);
            SHUTDOWNOUTPUT_METHOD.setAccessible(true);
            SUPPORTSURGENTDATA_METHOD = ABSTRACT_CLASS.getDeclaredMethod("supportsUrgentData", new Class[0]);
            SUPPORTSURGENTDATA_METHOD.setAccessible(true);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to initialize class", ex);
        }
    }
}

