/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.webdriver;

import com.xceptance.common.lang.ThrowableUtils;
import com.xceptance.xlt.api.util.XltProperties;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public final class WebDriverUtils {
    private static final boolean CHECK_ELEMENT_CLICKABLE = XltProperties.getInstance().getProperty("com.xceptance.xlt.scripting.check4Clickable", false);

    public static void assumeOkOnAlertOrConfirm(WebDriver webDriver) {
        String script = "window.alert = function(msg){}; window.confirm = function(msg){return true}; window.onbeforeunload = function(e){};";
        WebDriverUtils.executeJavaScriptIfPossible(webDriver, "window.alert = function(msg){}; window.confirm = function(msg){return true}; window.onbeforeunload = function(e){};", new Object[0]);
    }

    public static Object executeJavaScript(WebDriver webDriver, String script, Object ... arguments) {
        if (webDriver instanceof JavascriptExecutor) {
            try {
                JavascriptExecutor jsWebDriver = (JavascriptExecutor)webDriver;
                return jsWebDriver.executeScript(script, arguments);
            }
            catch (Throwable t) {
                ThrowableUtils.prefixMessage(t, "Failed to evaluate JavaScript: ");
                throw t;
            }
        }
        throw new UnsupportedOperationException(String.format("WebDriver '%s' is not able to execute JavaScript", webDriver.getClass().getName()));
    }

    public static Object executeJavaScriptIfPossible(WebDriver webDriver, String script, Object ... arguments) {
        try {
            return WebDriverUtils.executeJavaScript(webDriver, script, arguments);
        }
        catch (UnsupportedOperationException uoe) {
            return null;
        }
    }

    public static String getCurrentWindowName(WebDriver webDriver) {
        return (String)WebDriverUtils.executeJavaScript(webDriver, "return window.name", new Object[0]);
    }

    public static void setAttribute(WebDriver webDriver, WebElement element, String attributeName, String attributeValue) {
        String script = String.format("arguments[0].%s=%s;", attributeName, attributeValue);
        WebDriverUtils.executeJavaScriptIfPossible(webDriver, script, element);
    }

    public static void fireClickEvent(WebDriver webDriver, WebElement element) {
        WebDriverUtils.fireMouseDownEvent(webDriver, element);
        WebDriverUtils.fireMouseUpEvent(webDriver, element);
        WebDriverUtils.fireMouseEvent(webDriver, element, "click");
    }

    public static void fireMouseDownEvent(WebDriver webDriver, WebElement element) {
        WebDriverUtils.fireMouseEvent(webDriver, element, "mousedown");
    }

    public static void fireMouseUpEvent(WebDriver webDriver, WebElement element) {
        WebDriverUtils.fireMouseEvent(webDriver, element, "mouseup");
    }

    public static void fireChangeEvent(WebDriver webDriver, WebElement element) {
        String script = "var doc = arguments[0].ownerDocument;if(doc){  var changeEvent = doc.createEvent('HTMLEvents');  changeEvent.initEvent('change', true, true);  arguments[0].dispatchEvent(changeEvent);}";
        WebDriverUtils.executeJavaScriptIfPossible(webDriver, "var doc = arguments[0].ownerDocument;if(doc){  var changeEvent = doc.createEvent('HTMLEvents');  changeEvent.initEvent('change', true, true);  arguments[0].dispatchEvent(changeEvent);}", element);
    }

    public static void fireKeyDownEvent(WebDriver webDriver, WebElement element, int charCode) {
        WebDriverUtils.fireKeyEvent(webDriver, element, "keydown", charCode);
    }

    public static void fireKeyPressEvent(WebDriver webDriver, WebElement element, int charCode) {
        WebDriverUtils.fireKeyEvent(webDriver, element, "keypress", charCode);
    }

    public static void fireKeyUpEvent(WebDriver webDriver, WebElement element, int charCode) {
        WebDriverUtils.fireKeyEvent(webDriver, element, "keyup", charCode);
    }

    public static String getEffectiveStyle(WebDriver webDriver, WebElement element, String propertyName) {
        String script = "function getStyle(element, style){  var value = element.style && element.style[style];  if (!value) {    var doc = element.ownerDocument;    if (doc && doc.defaultView && doc.defaultView.getComputedStyle) {      var css = doc.defaultView.getComputedStyle(element, null);      value = css ? css.getPropertyValue(style) : null;    }  }  return value == 'auto' ? null : value;};function getEffectiveStyle(element, style) {  var effectiveStyle = getStyle(element, style);  if('inherit' === effectiveStyle && element.parentNode) {    return getEffectiveStyle(element.parentNode, style);  }  return effectiveStyle;};return getEffectiveStyle(arguments[0],arguments[1])";
        return (String)WebDriverUtils.executeJavaScript(webDriver, "function getStyle(element, style){  var value = element.style && element.style[style];  if (!value) {    var doc = element.ownerDocument;    if (doc && doc.defaultView && doc.defaultView.getComputedStyle) {      var css = doc.defaultView.getComputedStyle(element, null);      value = css ? css.getPropertyValue(style) : null;    }  }  return value == 'auto' ? null : value;};function getEffectiveStyle(element, style) {  var effectiveStyle = getStyle(element, style);  if('inherit' === effectiveStyle && element.parentNode) {    return getEffectiveStyle(element.parentNode, style);  }  return effectiveStyle;};return getEffectiveStyle(arguments[0],arguments[1])", element, propertyName);
    }

    public static boolean isClickable(WebDriver webDriver, WebElement element) {
        return WebDriverUtils.isClickable(webDriver, element, true);
    }

    public static boolean isClickable(WebDriver webDriver, WebElement element, boolean checkVisibility) {
        if (!element.isDisplayed()) {
            return false;
        }
        if (!CHECK_ELEMENT_CLICKABLE || webDriver instanceof HtmlUnitDriver || webDriver instanceof com.xceptance.xlt.engine.xltdriver.HtmlUnitDriver) {
            return true;
        }
        String script = "var e = arguments[0], rectum = e && e.getBoundingClientRect();try { return e.ownerDocument.elementFromPoint(rectum.left + rectum.width/2, rectum.top+rectum.height/2) === e;} catch(ex) { return false }";
        return (Boolean)WebDriverUtils.executeJavaScript(webDriver, "var e = arguments[0], rectum = e && e.getBoundingClientRect();try { return e.ownerDocument.elementFromPoint(rectum.left + rectum.width/2, rectum.top+rectum.height/2) === e;} catch(ex) { return false }", element);
    }

    public static boolean isEditable(WebDriver webDriver, WebElement element) {
        return WebDriverUtils.isEditable(webDriver, element, true);
    }

    public static boolean isEditable(WebDriver webDriver, WebElement element, boolean checkVisibility) {
        if (checkVisibility && !element.isDisplayed()) {
            return false;
        }
        String script = "function isDisabled(e) {  if(e && 'nodeType' in e && [1,9].indexOf(e.nodeType) > -1) {    switch (e.localName) {      case \"option\":\n      case \"optgroup\":\n        if (e.disabled) {\n          return true;\n        }\n        var parent = e.parentNode;\n        while(parent && parent.nodeType === 1 && ['optgroup','select'].indexOf(parent.localName) < 0) { parent = parent.parentNode; }\n        return isDisabled(parent);\n      case \"button\":\n      case \"input\":\n      case \"select\":\n      case \"textarea\":\n        return e.disabled;\n      default:\n        return false;\n     }  }  return false;}\nvar el = arguments[0];if(!el || !('nodeType' in el) || [1,9].indexOf(el.nodeType) < 0) { return false; }var tagName = el.localName, type = el.type;if(['input','textarea'].indexOf(tagName) < 0 || el.readOnly || isDisabled(el)) { return false; }return ('textarea' === tagName || /^color|date(time-local)?|email|file|month|number|password|range|search|tel|text|time|url|week$/.test(type));";
        Boolean result = (Boolean)WebDriverUtils.executeJavaScriptIfPossible(webDriver, "function isDisabled(e) {  if(e && 'nodeType' in e && [1,9].indexOf(e.nodeType) > -1) {    switch (e.localName) {      case \"option\":\n      case \"optgroup\":\n        if (e.disabled) {\n          return true;\n        }\n        var parent = e.parentNode;\n        while(parent && parent.nodeType === 1 && ['optgroup','select'].indexOf(parent.localName) < 0) { parent = parent.parentNode; }\n        return isDisabled(parent);\n      case \"button\":\n      case \"input\":\n      case \"select\":\n      case \"textarea\":\n        return e.disabled;\n      default:\n        return false;\n     }  }  return false;}\nvar el = arguments[0];if(!el || !('nodeType' in el) || [1,9].indexOf(el.nodeType) < 0) { return false; }var tagName = el.localName, type = el.type;if(['input','textarea'].indexOf(tagName) < 0 || el.readOnly || isDisabled(el)) { return false; }return ('textarea' === tagName || /^color|date(time-local)?|email|file|month|number|password|range|search|tel|text|time|url|week$/.test(type));", element);
        return Boolean.TRUE.equals(result);
    }

    private static void fireKeyEvent(WebDriver webDriver, WebElement element, String eventType, int charCode) {
        String script = "var doc = arguments[0].ownerDocument;if(doc){  var event;  try {    event = doc.createEvent('KeyEvents');    event.initKeyEvent('" + eventType + "', true, true, doc.defaultView, false, false, false, false, 0, " + charCode + ");  } catch(e) {    event = new KeyboardEvent('" + eventType + "', { bubbles: true, cancelable: true, view: doc.defaultView, charCode: " + charCode + "});  }  arguments[0].dispatchEvent(event);}";
        WebDriverUtils.executeJavaScriptIfPossible(webDriver, script, element);
    }

    private static void fireMouseEvent(WebDriver webDriver, WebElement element, String eventType) {
        String script = "var doc = arguments[0].ownerDocument;if(doc){  var event;  try {    event = doc.createEvent('MouseEvents');    event.initMouseEvent('" + eventType + "', true, true, doc.defaultView, 0, 0, 0, 0, 0, false, false, false, false, 0, null);  } catch(e) {    event = new MouseEvent('" + eventType + "',{ bubbles: true, cancelable: true, view: doc.defaultView });  }  arguments[0].dispatchEvent(event);}";
        WebDriverUtils.executeJavaScript(webDriver, script, element);
    }

    private WebDriverUtils() {
    }
}

