/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.resultbrowser;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.engine.resultbrowser.PageDOMClone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.Page;
import org.htmlunit.html.BaseFrameElement;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

final class DomUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DomUtils.class);

    private DomUtils() {
    }

    private static Node cloneNode(Node node, Document document) {
        if (node instanceof CDATASection) {
            return DomUtils.cloneCDATA((CDATASection)node, document);
        }
        if (node instanceof Text) {
            return DomUtils.cloneText((Text)node, document);
        }
        if (node instanceof Comment) {
            return DomUtils.cloneComment((Comment)node, document);
        }
        if (node != null) {
            LOG.warn("Don't know how to clone this node: " + node.getClass());
        }
        return null;
    }

    private static Node cloneCDATA(CDATASection node, Document document) {
        try {
            return document.createCDATASection(node.getData());
        }
        catch (DOMException dex) {
            LOG.warn("Failed to create CDATA section", (Throwable)dex);
            return null;
        }
    }

    private static Node cloneText(Text node, Document document) {
        try {
            return document.createTextNode(node.getData());
        }
        catch (DOMException dex) {
            LOG.warn("Failed to create text node", (Throwable)dex);
            return null;
        }
    }

    private static Node cloneComment(Comment node, Document document) {
        try {
            return document.createComment(node.getData());
        }
        catch (DOMException dex) {
            LOG.warn("Failed to create comment node", (Throwable)dex);
            return null;
        }
    }

    public static PageDOMClone clonePage(HtmlPage page) {
        ParameterCheckUtils.isNotNull(page, "page");
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            DocumentType docType = null;
            DocumentType originalDocType = page.getDoctype();
            if (originalDocType != null) {
                String name = originalDocType.getName();
                String publicId = originalDocType.getPublicId();
                String systemId = originalDocType.getSystemId();
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    docType = builder.getDOMImplementation().createDocumentType(name, publicId, systemId);
                }
            }
            Document doc = builder.getDOMImplementation().createDocument(null, "html", docType);
            doc.removeChild(doc.getElementsByTagName("html").item(0));
            PageDOMClone clone = new PageDOMClone(page, doc);
            DomUtils.clonePage(page, clone);
            return clone;
        }
        catch (Exception e) {
            LOG.error("Failed to clone page " + page, (Throwable)e);
            return null;
        }
    }

    private static void clonePage(HtmlPage page, PageDOMClone clone) {
        Node pageClone = DomUtils.cloneNode((Node)page.getDocumentElement(), clone);
        if (pageClone != null) {
            clone.getDocument().appendChild(pageClone);
        }
    }

    private static Node cloneNode(Node node, PageDOMClone clone) {
        if (node instanceof Element) {
            return DomUtils.cloneElementNode((Element)node, clone);
        }
        return DomUtils.cloneNode(node, clone.getDocument());
    }

    private static Node cloneElementNode(Element node, PageDOMClone pageClone) {
        PageDOMClone frameClone;
        Page p;
        Element clone;
        if (node == null) {
            return null;
        }
        String nodeNS = node.getNamespaceURI();
        try {
            clone = pageClone.getDocument().createElementNS(nodeNS, node.getTagName());
        }
        catch (DOMException dex) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Failed to clone element node " + node);
            }
            return null;
        }
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            try {
                clone.setAttributeNS((String)ObjectUtils.defaultIfNull((Object)attribute.getNamespaceURI(), (Object)nodeNS), attribute.getName(), attribute.getValue());
                continue;
            }
            catch (DOMException dex) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn(String.format("Failed to set attribute <%s> to value <%s>", attribute.getName(), attribute.getValue()));
            }
        }
        NodeList children = node instanceof HtmlTemplate ? ((HtmlTemplate)node).getContent().getChildNodes() : node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            Node childClone = DomUtils.cloneNode(child, pageClone);
            if (childClone == null) continue;
            clone.appendChild(childClone);
        }
        if (node instanceof BaseFrameElement && (p = ((BaseFrameElement)node).getEnclosedPage()) instanceof HtmlPage && (frameClone = DomUtils.clonePage((HtmlPage)p)) != null) {
            pageClone.addFrame(clone, frameClone);
        }
        return clone;
    }
}

