/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.metrics;

import com.xceptance.xlt.engine.metrics.Metric;

public class ValueMetric
implements Metric {
    private Snapshot snapshot = new Snapshot();

    @Override
    public synchronized void update(int value) {
        this.snapshot.update(value);
    }

    public synchronized Snapshot getSnapshotAndClear() {
        Snapshot oldSnapshot = this.snapshot;
        this.snapshot = new Snapshot();
        return oldSnapshot;
    }

    public static final class Snapshot {
        private int count;
        private int maximum = Integer.MIN_VALUE;
        private int minimum = Integer.MAX_VALUE;
        private long sum;

        public long getCount() {
            return this.count;
        }

        public int getMaximum() {
            return this.count == 0 ? 0 : this.maximum;
        }

        public double getMean() {
            return this.count == 0 ? 0.0 : (double)this.sum / (double)this.count;
        }

        public int getMinimum() {
            return this.count == 0 ? 0 : this.minimum;
        }

        public long getSum() {
            return this.sum;
        }

        private void update(int value) {
            ++this.count;
            if (value > this.maximum) {
                this.maximum = value;
            }
            if (value < this.minimum) {
                this.minimum = value;
            }
            this.sum += (long)value;
        }
    }
}

