/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.htmlunit.okhttp3;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;
import okhttp3.Authenticator;
import okhttp3.Challenge;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.CredentialsProvider;

class AuthenticatorImpl
implements Authenticator {
    private final CredentialsProvider credentialsProvider;

    public AuthenticatorImpl(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    @Nullable
    public Request authenticate(@Nullable Route route, Response response) throws IOException {
        boolean isProxyAuth;
        boolean bl = isProxyAuth = response.code() == 407;
        if (!isProxyAuth && response.request().header("Authorization") != null || isProxyAuth && response.request().header("Proxy-Authorization") != null) {
            return null;
        }
        for (Challenge challenge : response.challenges()) {
            org.apache.http.auth.Credentials credentials;
            AuthScope authScope;
            if (challenge.scheme().equalsIgnoreCase("OkHttp-Preemptive")) {
                authScope = this.createAuthScope(challenge, route, true);
                credentials = this.credentialsProvider.getCredentials(authScope);
                if (credentials == null) continue;
                return this.createBasicAuthRequest(credentials, response, true);
            }
            if (!challenge.scheme().equalsIgnoreCase("Basic") || (credentials = this.credentialsProvider.getCredentials(authScope = this.createAuthScope(challenge, route, isProxyAuth))) == null) continue;
            return this.createBasicAuthRequest(credentials, response, isProxyAuth);
        }
        return null;
    }

    private AuthScope createAuthScope(Challenge challenge, @Nullable Route route, boolean isProxyAuth) {
        int port;
        String host;
        if (route == null) {
            host = AuthScope.ANY_HOST;
            port = -1;
        } else if (isProxyAuth) {
            InetSocketAddress socketAddress = route.socketAddress();
            host = socketAddress.getHostString();
            port = socketAddress.getPort();
        } else {
            HttpUrl httpUrl = route.address().url();
            host = httpUrl.host();
            port = httpUrl.port();
        }
        return new AuthScope(host, port, challenge.realm(), challenge.scheme());
    }

    private Request createBasicAuthRequest(org.apache.http.auth.Credentials credentials, Response response, boolean isProxyAuth) {
        String basicAuthHeaderName = isProxyAuth ? "Proxy-Authorization" : "Authorization";
        String basicAuthHeaderValue = Credentials.basic((String)credentials.getUserPrincipal().getName(), (String)credentials.getPassword());
        return response.request().newBuilder().header(basicAuthHeaderName, basicAuthHeaderValue).build();
    }
}

