/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.dns;

import com.xceptance.xlt.api.util.XltException;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.dns.HostNameResolver;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Address;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TextParseException;

class DnsJavaHostNameResolver
implements HostNameResolver {
    static final String PROVIDER_NAME = "dnsjava";
    private static final String PROP_PREFIX = "xlt.dns.providers.dnsjava.";
    private static final String PROP_PREFIX_RESOLVER = "xlt.dns.providers.dnsjava.resolver.";
    private static final String PROP_DNS_SERVERS = "xlt.dns.providers.dnsjava.resolver.servers";
    private static final String PROP_TIMEOUT = "xlt.dns.providers.dnsjava.resolver.timeout";
    private static final String PROP_EDNS_VERSION = "xlt.dns.providers.dnsjava.edns.version";
    private final Resolver resolver;

    DnsJavaHostNameResolver() {
        XltProperties props = XltProperties.getInstance();
        try {
            String dnsServers = props.getProperty(PROP_DNS_SERVERS, "");
            int timeoutSeconds = props.getProperty(PROP_TIMEOUT, 5);
            int ednsVersion = props.getProperty(PROP_EDNS_VERSION, 0);
            String[] serverAddresses = StringUtils.split((String)dnsServers, (String)"\t ,;");
            this.resolver = serverAddresses.length == 0 ? new ExtendedResolver() : new ExtendedResolver(serverAddresses);
            this.resolver.setTimeout(Duration.ofSeconds(timeoutSeconds));
            if (ednsVersion >= 0) {
                this.resolver.setEDNS(ednsVersion);
            }
        }
        catch (UnknownHostException e) {
            throw new XltException("Failed to set up resolver", e);
        }
    }

    @Override
    public InetAddress[] resolve(String name) throws UnknownHostException {
        try {
            InetAddress addr = Address.getByAddress((String)name);
            return new InetAddress[]{addr};
        }
        catch (UnknownHostException e) {
            return this.lookupAddressesByHostName(name);
        }
    }

    private InetAddress[] lookupAddressesByHostName(String name) throws UnknownHostException {
        Record[] records = this.lookupRecordsByHostName(name);
        InetAddress[] addrs = new InetAddress[records.length];
        for (int i = 0; i < records.length; ++i) {
            addrs[i] = DnsJavaHostNameResolver.addressFromRecord(name, records[i]);
        }
        return addrs;
    }

    private Record[] lookupRecordsByHostName(String name) throws UnknownHostException {
        try {
            Record[] a = this.createNewLookup(name, 1).run();
            Record[] aaaa = this.createNewLookup(name, 28).run();
            Record[] merged = this.concatRecordArrays(a, aaaa);
            if (merged == null) {
                throw new UnknownHostException("Unknown host: " + name);
            }
            return merged;
        }
        catch (TextParseException e) {
            throw new UnknownHostException("Invalid host name: " + name);
        }
    }

    private Record[] concatRecordArrays(Record[] a, Record[] aaaa) {
        Record[] combined;
        if (a == null) {
            combined = aaaa;
        } else if (aaaa == null) {
            combined = a;
        } else {
            combined = new Record[a.length + aaaa.length];
            System.arraycopy(a, 0, combined, 0, a.length);
            System.arraycopy(aaaa, 0, combined, a.length, aaaa.length);
        }
        return combined;
    }

    private Lookup createNewLookup(String name, int type) throws TextParseException {
        Lookup lookup = new Lookup(name, type);
        lookup.setResolver(this.resolver);
        return lookup;
    }

    private static InetAddress addressFromRecord(String name, Record r) throws UnknownHostException {
        InetAddress addr = r instanceof ARecord ? ((ARecord)r).getAddress() : ((AAAARecord)r).getAddress();
        return InetAddress.getByAddress(name, addr.getAddress());
    }
}

