/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.xceptance.xlt.engine.util.TimerUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class PageStatistics {
    private static final Map<ThreadGroup, PageStatistics> pageStatistics = new ConcurrentHashMap<ThreadGroup, PageStatistics>();
    private final AtomicLong bytes = new AtomicLong();
    private final AtomicLong totalBytes = new AtomicLong();
    private final AtomicLong loadTime = new AtomicLong();
    private final AtomicBoolean pageLoaded = new AtomicBoolean(Boolean.FALSE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PageStatistics getPageStatistics() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        PageStatistics stats = null;
        ThreadGroup threadGroup2 = threadGroup;
        synchronized (threadGroup2) {
            stats = pageStatistics.get(threadGroup);
            if (stats == null) {
                stats = new PageStatistics();
                pageStatistics.put(threadGroup, stats);
            }
        }
        return stats;
    }

    private PageStatistics() {
    }

    public void addToBytes(long bytes) {
        this.bytes.addAndGet(bytes);
    }

    public void addToTotalBytes(long bytes) {
        this.totalBytes.addAndGet(bytes);
    }

    public long getBytes() {
        return this.bytes.get();
    }

    public long getTotalBytes() {
        return this.totalBytes.get();
    }

    protected void reset() {
        this.bytes.set(0L);
        this.totalBytes.set(0L);
        this.loadTime.set(0L);
        this.pageLoaded.set(false);
    }

    public void pageLoadStarted() {
        this.reset();
        this.loadTime.set(TimerUtils.get().getStartTime());
    }

    public void pageLoadFinished() {
        this.loadTime.set(TimerUtils.get().getElapsedTime(this.loadTime.get()));
        this.pageLoaded.set(true);
    }

    public long getLoadTime() {
        if (this.pageLoaded.get()) {
            return this.loadTime.get();
        }
        return 0L;
    }
}

