/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agentcontroller;

import com.xceptance.common.lang.ParseNumbers;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PartialGetUtils {
    private static final Pattern RANGE_PATTERN = Pattern.compile("bytes=(\\d+)-(\\d+)");
    private static final Pattern CONTENT_RANGE_PATTERN = Pattern.compile("bytes (\\d+)-(\\d+)/(\\d+)");

    PartialGetUtils() {
    }

    static String formatRangeHeader(long startPos, long endPos) {
        return "bytes=" + startPos + "-" + endPos;
    }

    static RangeHeaderData parseRangeHeader(String rangeHeaderValue) {
        Matcher matcher;
        if (rangeHeaderValue != null && (matcher = RANGE_PATTERN.matcher(rangeHeaderValue)).matches()) {
            long startPos = ParseNumbers.parseLong(matcher.group(1));
            long endPos = ParseNumbers.parseLong(matcher.group(2));
            return new RangeHeaderData(startPos, endPos);
        }
        return null;
    }

    static String formatContentRangeHeader(long startPos, long endPos, long totalBytes) {
        return "bytes " + startPos + "-" + endPos + "/" + totalBytes;
    }

    static ContentRangeHeaderData parseContentRangeHeader(String contentRangeHeaderValue) {
        Matcher matcher;
        if (contentRangeHeaderValue != null && (matcher = CONTENT_RANGE_PATTERN.matcher(contentRangeHeaderValue)).matches()) {
            long startPos = ParseNumbers.parseLong(matcher.group(1));
            long endPos = ParseNumbers.parseLong(matcher.group(2));
            long totalBytes = ParseNumbers.parseLong(matcher.group(3));
            return new ContentRangeHeaderData(startPos, endPos, totalBytes);
        }
        return null;
    }

    static class ContentRangeHeaderData {
        public final long startPos;
        public final long endPos;
        public final long totalBytes;

        public ContentRangeHeaderData(long startPos, long endPos, long totalBytes) {
            this.startPos = startPos;
            this.endPos = endPos;
            this.totalBytes = totalBytes;
        }
    }

    static class RangeHeaderData {
        public final long startPos;
        public final long endPos;

        public RangeHeaderData(long startPos, long endPos) {
            this.startPos = startPos;
            this.endPos = endPos;
        }
    }
}

