/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agentcontroller;

import com.xceptance.common.io.IoActionHandler;
import com.xceptance.common.net.UrlConnectionFactory;
import com.xceptance.xlt.agentcontroller.FileManager;
import com.xceptance.xlt.agentcontroller.PartialGetUtils;
import com.xceptance.xlt.api.util.XltException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManagerProxy
implements FileManager {
    private static final Logger log = LoggerFactory.getLogger(FileManagerProxy.class);
    private final URL url;
    private final UrlConnectionFactory urlConnectionFactory;
    private final long downloadChunkSize;
    private final int downloadMaxRetries;

    public FileManagerProxy(URL url, UrlConnectionFactory urlConnectionFactory, long downloadChunkSize, int downloadMaxRetries) throws MalformedURLException {
        this.url = new URL(url + "/fileManager/");
        this.urlConnectionFactory = urlConnectionFactory;
        this.downloadChunkSize = downloadChunkSize;
        this.downloadMaxRetries = downloadMaxRetries;
    }

    @Override
    public void deleteFile(String remoteFileName) throws IOException {
    }

    @Override
    public void downloadFile(File localFile, String remoteFileName) throws IOException {
        ChunkInfo chunkInfo;
        URL downloadUrl = new URL(this.url + remoteFileName);
        log.debug("Downloading file from '{}' to '{}' ...", (Object)downloadUrl, (Object)localFile);
        FileUtils.forceMkdir((File)localFile.getParentFile());
        IoActionHandler ioActionHandler = new IoActionHandler(this.downloadMaxRetries);
        long bytesRead = 0L;
        long totalBytes = Long.MAX_VALUE;
        do {
            long offset = bytesRead;
            long bytes = Math.min(this.downloadChunkSize, totalBytes - offset);
            chunkInfo = ioActionHandler.run(() -> this.downloadFileChunk(localFile, downloadUrl, offset, bytes));
        } while ((bytesRead += chunkInfo.chunkSize) < (totalBytes = chunkInfo.totalSize));
    }

    private ChunkInfo downloadFileChunk(File localFile, URL downloadUrl, long offset, long bytes) throws IOException {
        long startPos = offset;
        long endPos = offset + bytes - 1L;
        HttpURLConnection conn = (HttpURLConnection)this.urlConnectionFactory.open(downloadUrl);
        String rangeHeaderValue = PartialGetUtils.formatRangeHeader(startPos, endPos);
        conn.setRequestProperty("Range", rangeHeaderValue);
        int statusCode = conn.getResponseCode();
        if (statusCode == 200) {
            log.debug("Downloading complete file from '{}' ...", (Object)downloadUrl);
            long bytesCopied = this.copyBytes(conn, localFile, false);
            return new ChunkInfo(bytesCopied, bytesCopied);
        }
        if (statusCode == 206) {
            log.debug("Downloading chunk {}-{} from '{}' ...", new Object[]{startPos, endPos, downloadUrl});
            String contentRangeHeaderValue = conn.getHeaderField("Content-Range");
            PartialGetUtils.ContentRangeHeaderData contentRangeHeaderData = PartialGetUtils.parseContentRangeHeader(contentRangeHeaderValue);
            if (contentRangeHeaderData == null) {
                throw new XltException("Received invalid Content-Range header: " + contentRangeHeaderValue);
            }
            this.truncateFile(localFile, offset);
            long bytesCopied = this.copyBytes(conn, localFile, true);
            return new ChunkInfo(contentRangeHeaderData.totalBytes, bytesCopied);
        }
        throw new XltException("Received unexpected status code: " + statusCode);
    }

    private void truncateFile(File file, long newSize) throws IOException {
        if (file.length() > newSize) {
            try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
                raf.setLength(newSize);
            }
        }
    }

    private long copyBytes(HttpURLConnection conn, File file, boolean append) throws IOException {
        try (InputStream cin = conn.getInputStream();){
            long l;
            try (FileOutputStream fout = new FileOutputStream(file, append);){
                long bytesCopied = IOUtils.copyLarge((InputStream)cin, (OutputStream)fout);
                long bytesAnnounced = conn.getContentLengthLong();
                if (bytesAnnounced != -1L && bytesAnnounced != bytesCopied) {
                    throw new IOException(String.format("Expected %d bytes to copy but got %d bytes", bytesAnnounced, bytesCopied));
                }
                l = bytesCopied;
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadFile(File localFile, String remoteFileName) throws IOException {
        FileInputStream fin = null;
        OutputStream cout = null;
        try {
            URL uploadUrl = new URL(this.url + remoteFileName);
            log.debug("Uploading file '" + localFile + "' to '" + uploadUrl + "' ...");
            HttpURLConnection conn = (HttpURLConnection)this.urlConnectionFactory.open(uploadUrl);
            conn.setDoOutput(true);
            conn.setRequestMethod("PUT");
            conn.setChunkedStreamingMode(4096);
            fin = new FileInputStream(localFile);
            cout = conn.getOutputStream();
            IOUtils.copy((InputStream)fin, (OutputStream)cout);
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                throw new IOException(String.format("Server returned HTTP response code: %d for URL: %s", responseCode, uploadUrl));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fin);
            IOUtils.closeQuietly(cout);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fin);
        IOUtils.closeQuietly((OutputStream)cout);
    }

    private static class ChunkInfo {
        public final long totalSize;
        public final long chunkSize;

        public ChunkInfo(long totalSize, long chunkSize) {
            this.totalSize = totalSize;
            this.chunkSize = chunkSize;
        }
    }
}

