/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util;

import com.xceptance.xlt.api.util.SimpleArrayList;
import com.xceptance.xlt.api.util.XltCharBuffer;

public final class CsvUtilsDecode {
    private static final char COMMA = ',';
    private static final char QUOTE_CHAR = '\"';
    private static final int NONE = 0;
    private static final int IN_QUOTES = 1;
    private static final int START_MODE = 2;
    private static final int SEPARATOR_EXPECTED = 4;
    private static final int LAST_WAS_SEPARATOR = 8;
    private static final int JUST_LEFT_QUOTES = 16;
    private static final int COPY_REST = 32;

    private CsvUtilsDecode() {
    }

    public static SimpleArrayList<XltCharBuffer> parse(String s) {
        return CsvUtilsDecode.parse(new SimpleArrayList<XltCharBuffer>(50), XltCharBuffer.valueOf(s), ',');
    }

    public static SimpleArrayList<XltCharBuffer> parse(SimpleArrayList<XltCharBuffer> result, XltCharBuffer src, char fieldSeparator) {
        int size = src.length();
        int state = 2;
        int pos = 0;
        int start = 0;
        int offset = 0;
        block0: while (pos < size) {
            char c = src.charAt(pos);
            state |= 0x20;
            state &= 0xFFFFFFF7;
            if (c == '\"') {
                ++pos;
                if (((state |= 1) & 2) == 2) {
                    start = ++offset;
                }
                while (pos < size) {
                    char c2 = src.charAt(pos);
                    if (c2 == '\"') {
                        char peakedChar = src.peakAhead(pos + 1);
                        if (peakedChar == '\u0000') {
                            state |= 0x20;
                            break block0;
                        }
                        if (peakedChar == '\"') {
                            src.put(offset, c2);
                            ++offset;
                            pos += 2;
                            continue;
                        }
                        ++pos;
                        state &= 0xFFFFFFFC;
                        state |= 0x10;
                        continue block0;
                    }
                    if (pos != offset) {
                        src.put(offset, c2);
                    }
                    ++pos;
                    ++offset;
                    state &= 0xFFFFFFFD;
                }
                state |= 0x20;
                break;
            }
            if (c == fieldSeparator) {
                state &= 0xFFFFFFCF;
                state |= 0xA;
                result.add(src.viewFromTo(start, offset));
                offset = ++pos;
                start = pos;
                continue;
            }
            if (pos != offset) {
                src.put(offset, c);
            }
            ++pos;
            ++offset;
            state &= 0xFFFFFFFD;
        }
        if ((state & 0x20) == 32) {
            result.add(src.viewFromTo(start, offset));
        } else if ((state & 8) == 8) {
            result.add(XltCharBuffer.empty());
        } else if (size == 0) {
            result.add(XltCharBuffer.empty());
        }
        return result;
    }
}

