/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.common.util.ParseUtils;
import com.xceptance.common.util.PropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class AbstractConfiguration {
    private static final String PROPERTY_PARSING_ERROR_FORMAT = "The value '%s' of property '%s' cannot be resolved to a %s.";
    private final Properties props = new Properties();

    public void addProperties(Properties properties) {
        this.props.putAll((Map<?, ?>)properties);
    }

    public Class<?> getClassProperty(String key) {
        String s = this.getRequiredProperty(key);
        return this.parseClassName(key, s);
    }

    public Class<?> getClassProperty(String key, Class<?> defaultValue) {
        String s = this.getProperty(key);
        return s == null ? defaultValue : this.parseClassName(key, s);
    }

    public boolean getBooleanProperty(String key) {
        String s = this.getRequiredProperty(key);
        return Boolean.valueOf(s);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String s = this.getProperty(key);
        return s == null ? defaultValue : Boolean.valueOf(s);
    }

    public <T extends Enum<T>> T getEnumProperty(Class<T> enumType, String key, T defaultValue) {
        String value = this.getStringProperty(key, null);
        return StringUtils.isNotBlank((CharSequence)value) ? Enum.valueOf(enumType, value.toUpperCase()) : defaultValue;
    }

    public File getFileProperty(String key) {
        String s = this.getRequiredProperty(key);
        return this.parseFileName(key, s);
    }

    public File getFileProperty(String key, File defaultValue) {
        String s = this.getProperty(key);
        return s == null ? defaultValue : this.parseFileName(key, s);
    }

    public int getIntProperty(String key) {
        String value = this.getRequiredProperty(key);
        return this.parseInt(key, value);
    }

    public int getIntProperty(String key, int defaultValue) {
        String value = this.getProperty(key);
        return value == null ? defaultValue : this.parseInt(key, value);
    }

    public long getLongProperty(String key) {
        String value = this.getRequiredProperty(key);
        return this.parseLong(key, value);
    }

    public long getLongProperty(String key, long defaultValue) {
        String value = this.getProperty(key);
        return value == null ? defaultValue : this.parseLong(key, value);
    }

    public double getDoubleProperty(String key) {
        String value = this.getRequiredProperty(key);
        return this.parseDouble(key, value);
    }

    public double getDoubleProperty(String key, double defaultValue) {
        String value = this.getProperty(key);
        return value == null ? defaultValue : this.parseDouble(key, value);
    }

    public Properties getProperties() {
        return this.props;
    }

    private String getProperty(String key) {
        String propVal = this.props.getProperty(key);
        return propVal == null ? null : PropertiesUtils.substituteVariables(propVal.trim(), this.props);
    }

    public Set<String> getPropertyKeyFragment(String prefix) {
        Set<String> keysWithPrefix = this.getPropertyKeysWithPrefix(prefix);
        HashSet<String> result = new HashSet<String>();
        int prefixLength = prefix.length();
        for (String s : keysWithPrefix) {
            String fragment = s.substring(prefixLength);
            int periodIdx = fragment.indexOf(46);
            if (periodIdx >= 0) {
                fragment = fragment.substring(0, periodIdx);
            }
            result.add(fragment);
        }
        return result;
    }

    public Set<String> getPropertyKeyFragments(String prefix) {
        Set<String> keysWithPrefix = this.getPropertyKeysWithPrefix(prefix);
        HashSet<String> result = new HashSet<String>();
        int prefixLength = prefix.length();
        for (String s : keysWithPrefix) {
            String fragment = s.substring(prefixLength);
            int periodIdx = fragment.indexOf(46);
            if (periodIdx >= 0) {
                fragment = fragment.substring(0, periodIdx);
            }
            result.add(fragment);
        }
        return result;
    }

    public Set<String> getPropertyKeysWithPrefix(String prefix) {
        ParameterCheckUtils.isNotNullOrEmpty(prefix, "prefix");
        HashSet<String> set = new HashSet<String>();
        for (Object o : this.props.keySet()) {
            String key = (String)o;
            if (!key.startsWith(prefix)) continue;
            set.add(key);
        }
        return set;
    }

    private String getRequiredProperty(String key) {
        String propVal = this.getProperty(key);
        if (propVal == null) {
            throw new RuntimeException("No value found for required property: " + key);
        }
        return propVal;
    }

    public String getStringProperty(String key) {
        return this.getRequiredProperty(key);
    }

    public String getStringProperty(String key, String defaultValue) {
        String propVal = this.getProperty(key);
        return propVal == null ? defaultValue : propVal;
    }

    public URL getUrlProperty(String key) {
        return this.parseUrl(key, this.getRequiredProperty(key));
    }

    public URL getUrlProperty(String key, URL defaultValue) {
        String value = this.getProperty(key);
        return value == null ? defaultValue : this.parseUrl(key, value);
    }

    public URI getUriProperty(String key) {
        return this.parseUri(key, this.getRequiredProperty(key));
    }

    public URI getUriProperty(String key, URI defaultValue) {
        String value = this.getProperty(key);
        return value == null ? defaultValue : this.parseUri(key, value);
    }

    public int getTimePeriodProperty(String key, int defaultValue) {
        String value = this.getProperty(key);
        return value == null ? defaultValue : this.parseTimePeriod(key, value);
    }

    public int getTimePeriodProperty(String key) {
        return this.parseTimePeriod(key, this.getRequiredProperty(key));
    }

    public void loadProperties(File propertiesFile) throws IOException {
        PropertiesUtils.loadProperties(propertiesFile, this.props);
    }

    private Class<?> parseClassName(String key, String value) {
        try {
            return ParseUtils.parseClass(value);
        }
        catch (ParseException ex) {
            throw new RuntimeException(String.format(PROPERTY_PARSING_ERROR_FORMAT, value, key, "class"));
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(String.format(PROPERTY_PARSING_ERROR_FORMAT, value, key, "class"));
        }
    }

    private File parseFileName(String key, String value) {
        if (value.length() == 0) {
            throw new RuntimeException(String.format(PROPERTY_PARSING_ERROR_FORMAT, value, key, "file"));
        }
        return new File(value);
    }

    protected int parseInt(String key, String value) {
        try {
            return ParseUtils.parseInt(value);
        }
        catch (ParseException ex) {
            throw new RuntimeException(String.format(PROPERTY_PARSING_ERROR_FORMAT, value, key, "integer"));
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(String.format(PROPERTY_PARSING_ERROR_FORMAT, value, key, "integer"));
        }
    }

    protected long parseLong(String key, String value) {
        try {
            return ParseUtils.parseLong(value);
        }
        catch (ParseException ex) {
            throw new RuntimeException(String.format(PROPERTY_PARSING_ERROR_FORMAT, value, key, "long"));
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(String.format(PROPERTY_PARSING_ERROR_FORMAT, value, key, "long"));
        }
    }

    protected double parseDouble(String key, String value) {
        try {
            return ParseUtils.parseDouble(value);
        }
        catch (ParseException ex) {
            throw new RuntimeException(String.format(PROPERTY_PARSING_ERROR_FORMAT, value, key, "double"));
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(String.format(PROPERTY_PARSING_ERROR_FORMAT, value, key, "double"));
        }
    }

    private URL parseUrl(String key, String value) {
        try {
            return ParseUtils.parseURI(value).toURL();
        }
        catch (ParseException ex) {
            throw new RuntimeException(String.format(PROPERTY_PARSING_ERROR_FORMAT, value, key, "URL"));
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(String.format(PROPERTY_PARSING_ERROR_FORMAT, value, key, "URL"));
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(String.format(PROPERTY_PARSING_ERROR_FORMAT, value, key, "URL"));
        }
    }

    private URI parseUri(String key, String value) {
        try {
            return ParseUtils.parseURI(value);
        }
        catch (ParseException ex) {
            throw new RuntimeException(String.format(PROPERTY_PARSING_ERROR_FORMAT, value, key, "URI"));
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(String.format(PROPERTY_PARSING_ERROR_FORMAT, value, key, "URI"));
        }
    }

    private int parseTimePeriod(String key, String value) {
        try {
            return ParseUtils.parseTimePeriod(value);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(PROPERTY_PARSING_ERROR_FORMAT, value, key, "time period"));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(String.format(PROPERTY_PARSING_ERROR_FORMAT, value, key, "time period"));
        }
    }
}

