/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.collection;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = -6633745418108562019L;
    private static final int INITIAL_SIZE = 3;
    private static final float INITIAL_REHASHING_SIZE = 0.75f;
    private final int maxSize;

    public LRUHashMap(int max) {
        super(3, 0.75f, true);
        this.maxSize = max;
    }

    public LRUHashMap(Map<K, V> map, int max) {
        super(3, 0.75f, true);
        this.maxSize = max;
        this.putAll(map);
    }

    @Override
    protected final boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxSize;
    }
}

