/*
 * Decompiled with CFR 0.152.
 */
package at.rags.morpheus;

import at.rags.morpheus.Annotations.Relationship;
import at.rags.morpheus.Logger;
import at.rags.morpheus.Resource;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.util.HashMap;

public class Serializer {
    public HashMap<String, Object> getFieldsAsDictionary(Resource resource) {
        HashMap<String, Object> fieldDict = null;
        for (Field field : resource.getClass().getDeclaredFields()) {
            String fieldName = null;
            if (field.isAnnotationPresent(Relationship.class)) continue;
            Object fieldValue = null;
            try {
                field.setAccessible(true);
                fieldValue = field.get(resource);
                if (fieldValue == null) {
                    continue;
                }
            }
            catch (IllegalAccessException e) {
                Logger.debug("Cannot access field: " + fieldName + ".");
            }
            if (field.isAnnotationPresent(SerializedName.class)) {
                SerializedName annotation;
                SerializedName serializeName = annotation = field.getAnnotation(SerializedName.class);
                fieldName = serializeName.value();
            } else {
                fieldName = field.getName();
            }
            if (fieldDict == null) {
                fieldDict = new HashMap<String, Object>();
            }
            fieldDict.put(fieldName, fieldValue);
        }
        return fieldDict;
    }

    public HashMap<String, Object> getRelationships(Resource resource) {
        HashMap<String, Object> relationships = new HashMap<String, Object>();
        for (Field field : resource.getClass().getDeclaredFields()) {
            Relationship annotation;
            if (!field.isAnnotationPresent(Relationship.class)) continue;
            Relationship relationship = annotation = field.getAnnotation(Relationship.class);
            field.setAccessible(true);
            try {
                relationships.put(relationship.value(), field.get(resource));
            }
            catch (IllegalAccessException e) {
                Logger.debug("Cannot access field: " + field.getName() + ".");
            }
        }
        return relationships;
    }
}

