/*
 * Decompiled with CFR 0.152.
 */
package com.android.xamoom.htmltextview;

import android.text.Editable;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.style.LeadingMarginSpan;
import android.text.style.RelativeSizeSpan;
import android.util.Log;
import com.android.xamoom.htmltextview.HtmlTable;
import com.android.xamoom.htmltextview.Spans.CustomBulletSpan;
import com.android.xamoom.htmltextview.Spans.NumberSpan;
import com.android.xamoom.htmltextview.Spans.TableCellSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.XMLReader;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 i2\u00020\u0001:\u0005ijklmB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010I\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020LH\u0002J\u001f\u0010N\u001a\u0004\u0018\u00010\u00032\u0006\u0010O\u001a\u00020\u000f2\u0006\u0010P\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010QJ\b\u0010R\u001a\u00020\u000bH\u0002J\b\u0010S\u001a\u00020\u0003H\u0002J\b\u0010T\u001a\u00020\u000fH\u0002J=\u0010U\u001a\u00020J\"\u0004\b\u0000\u0010V2\u0006\u0010W\u001a\u00020L2\f\u0010X\u001a\b\u0012\u0004\u0012\u0002HV0Y2\u0012\u0010Z\u001a\n\u0012\u0006\b\u0001\u0012\u00020\\0[\"\u00020\\H\u0002\u00a2\u0006\u0002\u0010]J\u0017\u0010^\u001a\u0004\u0018\u00010\u00032\u0006\u0010O\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010_J&\u0010`\u001a\u0004\u0018\u00010\\\"\u0004\b\u0000\u0010V2\u0006\u0010M\u001a\u00020a2\f\u0010X\u001a\b\u0012\u0004\u0012\u0002HV0YH\u0002J.\u0010b\u001a\u00020J2\u0006\u0010c\u001a\u00020!2\b\u0010O\u001a\u0004\u0018\u00010\u000f2\b\u0010W\u001a\u0004\u0018\u00010L2\b\u0010d\u001a\u0004\u0018\u00010eH\u0016J\u0018\u0010f\u001a\u00020J2\u0006\u0010M\u001a\u00020g2\u0006\u0010h\u001a\u00020\\H\u0002R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R \u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0016\"\u0004\b-\u0010\u001fR*\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u0007j\b\u0012\u0004\u0012\u00020\u000b`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0014\u00103\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0016R \u00105\u001a\b\u0012\u0004\u0012\u00020\u000f0'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010)\"\u0004\b7\u0010+R \u00108\u001a\b\u0012\u0004\u0012\u00020\u000b0'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010)\"\u0004\b:\u0010+R \u0010;\u001a\b\u0012\u0004\u0012\u00020\b0'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010)\"\u0004\b=\u0010+R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER \u0010F\u001a\b\u0012\u0004\u0012\u00020\u000b0'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010)\"\u0004\bH\u0010+\u00a8\u0006n"}, d2={"Lcom/android/xamoom/htmltextview/HtmlTagHandler;", "Landroid/text/Html$TagHandler;", "textSize", "", "textPaint", "Landroid/text/TextPaint;", "tables", "Ljava/util/ArrayList;", "Lcom/android/xamoom/htmltextview/HtmlTable;", "Lkotlin/collections/ArrayList;", "maxTableWidth", "", "layoutDirection", "(FLandroid/text/TextPaint;Ljava/util/ArrayList;II)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "setTAG", "(Ljava/lang/String;)V", "bulletMargin", "getBulletMargin", "()I", "fontSizeStack", "Ljava/util/PriorityQueue;", "getFontSizeStack", "()Ljava/util/PriorityQueue;", "setFontSizeStack", "(Ljava/util/PriorityQueue;)V", "getLayoutDirection", "setLayoutDirection", "(I)V", "listSizeChanged", "", "getListSizeChanged", "()Z", "setListSizeChanged", "(Z)V", "lists", "Ljava/util/Stack;", "getLists", "()Ljava/util/Stack;", "setLists", "(Ljava/util/Stack;)V", "getMaxTableWidth", "setMaxTableWidth", "orderedListItems", "getOrderedListItems", "()Ljava/util/ArrayList;", "setOrderedListItems", "(Ljava/util/ArrayList;)V", "paragraphIndent", "getParagraphIndent", "tableCells", "getTableCells", "setTableCells", "tableRowBackgroundColors", "getTableRowBackgroundColors", "setTableRowBackgroundColors", "tableStack", "getTableStack", "setTableStack", "getTextPaint", "()Landroid/text/TextPaint;", "setTextPaint", "(Landroid/text/TextPaint;)V", "getTextSize", "()F", "setTextSize", "(F)V", "unorderedListItems", "getUnorderedListItems", "setUnorderedListItems", "adjustTableCellSizes", "", "appendNewLine", "Landroid/text/Editable;", "text", "calculateFontsizeProportion", "tag", "size", "(Ljava/lang/String;F)Ljava/lang/Float;", "calculateListItemOffset", "cellStartOffset", "currentNumberSpanString", "end", "T", "output", "kind", "Ljava/lang/Class;", "replaces", "", "", "(Landroid/text/Editable;Ljava/lang/Class;[Ljava/lang/Object;)V", "fontSizeFromTag", "(Ljava/lang/String;)Ljava/lang/Float;", "getLast", "Landroid/text/Spanned;", "handleTag", "opening", "xmlReader", "Lorg/xml/sax/XMLReader;", "start", "Landroid/text/SpannableStringBuilder;", "mark", "Companion", "FontSize", "ListItem", "TableCell", "TableRow", "htmltextview_release"})
public final class HtmlTagHandler
implements Html.TagHandler {
    @NotNull
    private String TAG;
    private final int paragraphIndent = 30;
    private final int bulletMargin = 10;
    @NotNull
    private Stack<String> lists;
    @NotNull
    private ArrayList<Integer> orderedListItems;
    @NotNull
    private Stack<Integer> unorderedListItems;
    @NotNull
    private Stack<HtmlTable> tableStack;
    @NotNull
    private Stack<Integer> tableRowBackgroundColors;
    @NotNull
    private Stack<String> tableCells;
    @NotNull
    private PriorityQueue<Float> fontSizeStack;
    private boolean listSizeChanged;
    private float textSize;
    @NotNull
    private TextPaint textPaint;
    private int maxTableWidth;
    private int layoutDirection;
    private static boolean DEBUG;
    @NotNull
    private static final String TAG_FONTSIZE = "fontsize";
    @NotNull
    private static final String TAG_UNORDEREDLIST = "unorderedlist";
    @NotNull
    private static final String TAG_ORDEREDLIST = "orderedlist";
    @NotNull
    private static final String TAG_LISTITEM = "listitem";
    @NotNull
    private static final String TAG_TABLE = "htmltable";
    @NotNull
    private static final String TAG_TABLE_ROW = "tablerow";
    @NotNull
    private static final String TAG_TABLE_CELL = "tablecell";
    public static final Companion Companion;

    @NotNull
    public final String getTAG() {
        return this.TAG;
    }

    public final void setTAG(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.TAG = string;
    }

    public final int getParagraphIndent() {
        return this.paragraphIndent;
    }

    public final int getBulletMargin() {
        return this.bulletMargin;
    }

    @NotNull
    public final Stack<String> getLists() {
        return this.lists;
    }

    public final void setLists(@NotNull Stack<String> stack) {
        Intrinsics.checkParameterIsNotNull(stack, (String)"<set-?>");
        this.lists = stack;
    }

    @NotNull
    public final ArrayList<Integer> getOrderedListItems() {
        return this.orderedListItems;
    }

    public final void setOrderedListItems(@NotNull ArrayList<Integer> arrayList) {
        Intrinsics.checkParameterIsNotNull(arrayList, (String)"<set-?>");
        this.orderedListItems = arrayList;
    }

    @NotNull
    public final Stack<Integer> getUnorderedListItems() {
        return this.unorderedListItems;
    }

    public final void setUnorderedListItems(@NotNull Stack<Integer> stack) {
        Intrinsics.checkParameterIsNotNull(stack, (String)"<set-?>");
        this.unorderedListItems = stack;
    }

    @NotNull
    public final Stack<HtmlTable> getTableStack() {
        return this.tableStack;
    }

    public final void setTableStack(@NotNull Stack<HtmlTable> stack) {
        Intrinsics.checkParameterIsNotNull(stack, (String)"<set-?>");
        this.tableStack = stack;
    }

    @NotNull
    public final Stack<Integer> getTableRowBackgroundColors() {
        return this.tableRowBackgroundColors;
    }

    public final void setTableRowBackgroundColors(@NotNull Stack<Integer> stack) {
        Intrinsics.checkParameterIsNotNull(stack, (String)"<set-?>");
        this.tableRowBackgroundColors = stack;
    }

    @NotNull
    public final Stack<String> getTableCells() {
        return this.tableCells;
    }

    public final void setTableCells(@NotNull Stack<String> stack) {
        Intrinsics.checkParameterIsNotNull(stack, (String)"<set-?>");
        this.tableCells = stack;
    }

    @NotNull
    public final PriorityQueue<Float> getFontSizeStack() {
        return this.fontSizeStack;
    }

    public final void setFontSizeStack(@NotNull PriorityQueue<Float> priorityQueue) {
        Intrinsics.checkParameterIsNotNull(priorityQueue, (String)"<set-?>");
        this.fontSizeStack = priorityQueue;
    }

    public final boolean getListSizeChanged() {
        return this.listSizeChanged;
    }

    public final void setListSizeChanged(boolean bl) {
        this.listSizeChanged = bl;
    }

    public void handleTag(boolean opening, @Nullable String tag, @Nullable Editable output, @Nullable XMLReader xmlReader) {
        if (tag == null || output == null) {
            return;
        }
        if (opening) {
            if (StringsKt.contains$default((CharSequence)tag, (CharSequence)Companion.getTAG_FONTSIZE(), (boolean)false, (int)2, null)) {
                Float fontSize = this.fontSizeFromTag(tag);
                if (fontSize != null) {
                    this.fontSizeStack.add(fontSize);
                }
                this.start((SpannableStringBuilder)output, new FontSize());
            } else if (StringsKt.contains$default((CharSequence)tag, (CharSequence)Companion.getTAG_UNORDEREDLIST(), (boolean)false, (int)2, null)) {
                this.lists.add(tag);
                this.unorderedListItems.push(1);
                this.listSizeChanged = false;
            } else if (StringsKt.contains$default((CharSequence)tag, (CharSequence)Companion.getTAG_ORDEREDLIST(), (boolean)false, (int)2, null)) {
                this.lists.add(tag);
                this.orderedListItems.add(1);
                this.listSizeChanged = false;
            } else if (StringsKt.contains$default((CharSequence)tag, (CharSequence)Companion.getTAG_LISTITEM(), (boolean)false, (int)2, null)) {
                if (Intrinsics.areEqual((Object)this.lists.peek(), (Object)Companion.getTAG_ORDEREDLIST())) {
                    this.orderedListItems.set(this.lists.size() - 1, ((Number)this.orderedListItems.get(this.lists.size() - 1)).intValue() + 1);
                }
                this.start((SpannableStringBuilder)output, new ListItem());
            } else {
                String fontSize = tag;
                CharSequence charSequence = Companion.getTAG_TABLE();
                if (fontSize.contentEquals(charSequence)) {
                    this.tableRowBackgroundColors.addAll((Collection<Integer>)this.tableStack.peek().getRowBackgroundColors());
                } else {
                    fontSize = tag;
                    charSequence = Companion.getTAG_TABLE_ROW();
                    if (fontSize.contentEquals(charSequence)) {
                        this.start((SpannableStringBuilder)output, new TableRow());
                    } else {
                        fontSize = tag;
                        charSequence = Companion.getTAG_TABLE_CELL();
                        if (fontSize.contentEquals(charSequence)) {
                            this.tableCells.push(tag);
                            this.start((SpannableStringBuilder)output, new TableCell());
                        }
                    }
                }
            }
        } else if (StringsKt.contains$default((CharSequence)tag, (CharSequence)Companion.getTAG_FONTSIZE(), (boolean)false, (int)2, null)) {
            Float relativeSpanSize;
            float encapsulatedFontSize = this.textSize;
            if (this.fontSizeStack.size() > 1) {
                Float f = this.fontSizeStack.peek();
                Intrinsics.checkExpressionValueIsNotNull((Object)f, (String)"fontSizeStack.peek()");
                encapsulatedFontSize = ((Number)f).floatValue();
            }
            if ((relativeSpanSize = this.calculateFontsizeProportion(tag, encapsulatedFontSize)) == null) {
                this.end((Editable)((SpannableStringBuilder)output), FontSize.class, new Object[0]);
            } else {
                this.end((Editable)((SpannableStringBuilder)output), FontSize.class, new RelativeSizeSpan(relativeSpanSize.floatValue()));
            }
            this.fontSizeStack.poll();
        } else if (StringsKt.contains$default((CharSequence)tag, (CharSequence)Companion.getTAG_UNORDEREDLIST(), (boolean)false, (int)2, null)) {
            this.lists.pop();
            this.listSizeChanged = true;
        } else if (StringsKt.contains$default((CharSequence)tag, (CharSequence)Companion.getTAG_ORDEREDLIST(), (boolean)false, (int)2, null)) {
            this.lists.pop();
            this.listSizeChanged = true;
            this.orderedListItems.remove(CollectionsKt.last((List)this.orderedListItems));
        } else if (StringsKt.contains$default((CharSequence)tag, (CharSequence)Companion.getTAG_LISTITEM(), (boolean)false, (int)2, null)) {
            Editable text = this.appendNewLine(output);
            if (Intrinsics.areEqual((Object)this.lists.peek(), (Object)Companion.getTAG_UNORDEREDLIST())) {
                if (this.listSizeChanged) {
                    Editable editable = text;
                    if (editable == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.text.SpannableStringBuilder");
                    }
                    this.end((Editable)((SpannableStringBuilder)editable), ListItem.class, new LeadingMarginSpan.Standard(this.paragraphIndent));
                    this.listSizeChanged = false;
                    return;
                }
                CustomBulletSpan bullet = new CustomBulletSpan(this.bulletMargin, this.calculateListItemOffset(), this.layoutDirection);
                Editable editable = text;
                if (editable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.text.SpannableStringBuilder");
                }
                this.end((Editable)((SpannableStringBuilder)editable), ListItem.class, new Object[]{new LeadingMarginSpan.Standard(this.paragraphIndent), bullet});
            } else {
                Editable text2 = this.appendNewLine(output);
                if (this.listSizeChanged) {
                    Editable editable = text2;
                    if (editable == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.text.SpannableStringBuilder");
                    }
                    this.end((Editable)((SpannableStringBuilder)editable), ListItem.class, new Object[0]);
                    this.listSizeChanged = false;
                    return;
                }
                String currentNumber = this.currentNumberSpanString();
                NumberSpan numberSpan = new NumberSpan(this.calculateListItemOffset(), currentNumber, this.textPaint, this.layoutDirection);
                Editable editable = text2;
                if (editable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.text.SpannableStringBuilder");
                }
                this.end((Editable)((SpannableStringBuilder)editable), ListItem.class, new Object[]{numberSpan});
            }
        } else {
            String text = tag;
            CharSequence charSequence = Companion.getTAG_TABLE_ROW();
            if (text.contentEquals(charSequence)) {
                String string = text = this.appendNewLine(output);
                if (string == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.text.SpannableStringBuilder");
                }
                this.end((Editable)((SpannableStringBuilder)string), TableRow.class, new Object[0]);
                this.tableCells.clear();
                this.tableRowBackgroundColors.pop();
            } else {
                text = tag;
                charSequence = Companion.getTAG_TABLE_CELL();
                if (text.contentEquals(charSequence)) {
                    this.adjustTableCellSizes();
                    float startOffset = this.cellStartOffset();
                    this.end((Editable)((SpannableStringBuilder)output), TableCell.class, new Object[]{new TableCellSpan(startOffset, (int)((Number)this.tableStack.peek().getCellSizes().get(this.tableCells.size() - 1)).floatValue(), this.tableRowBackgroundColors.peek(), 0, 8, null)});
                } else {
                    String string = tag;
                    charSequence = Companion.getTAG_TABLE();
                    if (string.contentEquals(charSequence)) {
                        this.tableStack.pop();
                    }
                }
            }
        }
    }

    private final Editable appendNewLine(Editable text) {
        CharSequence charSequence = (CharSequence)text;
        if (charSequence.length() > 0 && text.charAt(text.length() - 1) != '\n') {
            text.append((CharSequence)"\n");
        }
        return text;
    }

    private final Float calculateFontsizeProportion(String tag, float size) {
        Float newFontSize = null;
        Float fontSize = this.fontSizeFromTag(tag);
        if (fontSize != null) {
            newFontSize = Float.valueOf(fontSize.floatValue() / size);
        }
        return newFontSize;
    }

    private final Float fontSizeFromTag(String tag) {
        String sizeString = StringsKt.replace$default((String)tag, (String)TAG_FONTSIZE, (String)"", (boolean)false, (int)4, null);
        if (StringsKt.contains$default((CharSequence)sizeString, (CharSequence)"px", (boolean)false, (int)2, null)) {
            return StringsKt.toFloatOrNull((String)StringsKt.replace$default((String)sizeString, (String)"px", (String)"", (boolean)false, (int)4, null));
        }
        return null;
    }

    private final int calculateListItemOffset() {
        return this.paragraphIndent * this.lists.size();
    }

    /*
     * WARNING - void declaration
     */
    private final float cellStartOffset() {
        int n;
        int n2;
        float startOffset = 0.0f;
        if (this.tableCells.size() > 1 && (n2 = 0) <= (n = this.tableCells.size() - 2)) {
            while (true) {
                void i;
                Float f = this.tableStack.peek().getCellSizes().get((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)f, (String)"tableStack.peek().cellSizes[i]");
                startOffset += ((Number)f).floatValue();
                if (i == n) break;
                ++i;
            }
        }
        if (Companion.getDEBUG()) {
            Log.d((String)"HtmlTagHandler", (String)("Cell startOffset for index " + this.tableCells.size() + " with " + startOffset));
        }
        return startOffset;
    }

    private final void adjustTableCellSizes() {
        if ((float)this.maxTableWidth > this.tableStack.peek().maximalRowSize()) {
            int largestSizeIndex = CollectionsKt.indexOf((List)this.tableStack.peek().getCellSizes(), (Object)CollectionsKt.max((Iterable)this.tableStack.peek().getCellSizes()));
            float availableSpaceForWidth = (float)this.maxTableWidth - this.tableStack.peek().maximalRowSize();
            if (Companion.getDEBUG()) {
                Log.d((String)"HtmlTagHandler", (String)("Adjusting cellSize: " + largestSizeIndex + " from " + this.tableStack.peek().maximalRowSize() + " to " + availableSpaceForWidth));
            }
            ArrayList<Float> arrayList = this.tableStack.peek().getCellSizes();
            int n = largestSizeIndex;
            arrayList.set(n, Float.valueOf(arrayList.get(n).floatValue() + availableSpaceForWidth));
        }
    }

    private final String currentNumberSpanString() {
        return String.valueOf(((Number)this.orderedListItems.get(this.lists.size() - 1)).intValue() - 1);
    }

    private final <T> Object getLast(Spanned text, Class<T> kind) {
        Object[] objects = text.getSpans(0, text.length(), kind);
        Object[] objectArray = objects;
        if (objectArray.length == 0) {
            return null;
        }
        return objects[objects.length - 1];
    }

    private final void start(SpannableStringBuilder text, Object mark) {
        int len = text.length();
        text.setSpan(mark, len, len, 17);
    }

    private final <T> void end(Editable output, Class<T> kind, Object ... replaces) {
        int len = output.length();
        Object obj = this.getLast((Spanned)output, kind);
        int where = output.getSpanStart(obj);
        output.removeSpan(obj);
        if (where >= 0 && where != len) {
            for (int i = 0; i < replaces.length; ++i) {
                Object replace = replaces[i];
                output.setSpan(replace, where, len, 33);
            }
        }
    }

    public final float getTextSize() {
        return this.textSize;
    }

    public final void setTextSize(float f) {
        this.textSize = f;
    }

    @NotNull
    public final TextPaint getTextPaint() {
        return this.textPaint;
    }

    public final void setTextPaint(@NotNull TextPaint textPaint) {
        Intrinsics.checkParameterIsNotNull((Object)textPaint, (String)"<set-?>");
        this.textPaint = textPaint;
    }

    public final int getMaxTableWidth() {
        return this.maxTableWidth;
    }

    public final void setMaxTableWidth(int n) {
        this.maxTableWidth = n;
    }

    public final int getLayoutDirection() {
        return this.layoutDirection;
    }

    public final void setLayoutDirection(int n) {
        this.layoutDirection = n;
    }

    public HtmlTagHandler(float textSize, @NotNull TextPaint textPaint, @NotNull ArrayList<HtmlTable> tables, int maxTableWidth, int layoutDirection) {
        Intrinsics.checkParameterIsNotNull((Object)textPaint, (String)"textPaint");
        Intrinsics.checkParameterIsNotNull(tables, (String)"tables");
        this.textSize = textSize;
        this.textPaint = textPaint;
        this.maxTableWidth = maxTableWidth;
        this.layoutDirection = layoutDirection;
        this.TAG = "HtmlTagHandler";
        this.paragraphIndent = 30;
        this.bulletMargin = 10;
        this.lists = new Stack();
        this.orderedListItems = new ArrayList();
        this.unorderedListItems = new Stack();
        this.tableStack = new Stack();
        this.tableRowBackgroundColors = new Stack();
        this.tableCells = new Stack();
        this.fontSizeStack = new PriorityQueue();
        this.tableStack.addAll((Collection<HtmlTable>)tables);
    }

    static {
        Companion = new Companion(null);
        TAG_FONTSIZE = TAG_FONTSIZE;
        TAG_UNORDEREDLIST = TAG_UNORDEREDLIST;
        TAG_ORDEREDLIST = TAG_ORDEREDLIST;
        TAG_LISTITEM = TAG_LISTITEM;
        TAG_TABLE = TAG_TABLE;
        TAG_TABLE_ROW = TAG_TABLE_ROW;
        TAG_TABLE_CELL = TAG_TABLE_CELL;
    }

    @NotNull
    public static final String getTAG_FONTSIZE() {
        return Companion.getTAG_FONTSIZE();
    }

    @NotNull
    public static final String getTAG_UNORDEREDLIST() {
        return Companion.getTAG_UNORDEREDLIST();
    }

    @NotNull
    public static final String getTAG_ORDEREDLIST() {
        return Companion.getTAG_ORDEREDLIST();
    }

    @NotNull
    public static final String getTAG_LISTITEM() {
        return Companion.getTAG_LISTITEM();
    }

    @NotNull
    public static final String getTAG_TABLE() {
        return Companion.getTAG_TABLE();
    }

    @NotNull
    public static final String getTAG_TABLE_ROW() {
        return Companion.getTAG_TABLE_ROW();
    }

    @NotNull
    public static final String getTAG_TABLE_CELL() {
        return Companion.getTAG_TABLE_CELL();
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/android/xamoom/htmltextview/HtmlTagHandler$FontSize;", "", "()V", "htmltextview_release"})
    public static final class FontSize {
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/android/xamoom/htmltextview/HtmlTagHandler$ListItem;", "", "()V", "htmltextview_release"})
    public static final class ListItem {
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/android/xamoom/htmltextview/HtmlTagHandler$TableRow;", "", "()V", "htmltextview_release"})
    public static final class TableRow {
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/android/xamoom/htmltextview/HtmlTagHandler$TableCell;", "", "()V", "htmltextview_release"})
    public static final class TableCell {
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0016\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\n8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u00020\n8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\rR\u001c\u0010\u0011\u001a\u00020\n8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0013\u0010\rR\u001c\u0010\u0014\u001a\u00020\n8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\rR\u001c\u0010\u0017\u001a\u00020\n8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0002\u001a\u0004\b\u0019\u0010\rR\u001c\u0010\u001a\u001a\u00020\n8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001b\u0010\u0002\u001a\u0004\b\u001c\u0010\rR\u001c\u0010\u001d\u001a\u00020\n8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\u0002\u001a\u0004\b\u001f\u0010\r\u00a8\u0006 "}, d2={"Lcom/android/xamoom/htmltextview/HtmlTagHandler$Companion;", "", "()V", "DEBUG", "", "getDEBUG", "()Z", "setDEBUG", "(Z)V", "TAG_FONTSIZE", "", "TAG_FONTSIZE$annotations", "getTAG_FONTSIZE", "()Ljava/lang/String;", "TAG_LISTITEM", "TAG_LISTITEM$annotations", "getTAG_LISTITEM", "TAG_ORDEREDLIST", "TAG_ORDEREDLIST$annotations", "getTAG_ORDEREDLIST", "TAG_TABLE", "TAG_TABLE$annotations", "getTAG_TABLE", "TAG_TABLE_CELL", "TAG_TABLE_CELL$annotations", "getTAG_TABLE_CELL", "TAG_TABLE_ROW", "TAG_TABLE_ROW$annotations", "getTAG_TABLE_ROW", "TAG_UNORDEREDLIST", "TAG_UNORDEREDLIST$annotations", "getTAG_UNORDEREDLIST", "htmltextview_release"})
    public static final class Companion {
        public final boolean getDEBUG() {
            return DEBUG;
        }

        public final void setDEBUG(boolean bl) {
            DEBUG = bl;
        }

        @JvmStatic
        public static /* synthetic */ void TAG_FONTSIZE$annotations() {
        }

        @NotNull
        public final String getTAG_FONTSIZE() {
            return TAG_FONTSIZE;
        }

        @JvmStatic
        public static /* synthetic */ void TAG_UNORDEREDLIST$annotations() {
        }

        @NotNull
        public final String getTAG_UNORDEREDLIST() {
            return TAG_UNORDEREDLIST;
        }

        @JvmStatic
        public static /* synthetic */ void TAG_ORDEREDLIST$annotations() {
        }

        @NotNull
        public final String getTAG_ORDEREDLIST() {
            return TAG_ORDEREDLIST;
        }

        @JvmStatic
        public static /* synthetic */ void TAG_LISTITEM$annotations() {
        }

        @NotNull
        public final String getTAG_LISTITEM() {
            return TAG_LISTITEM;
        }

        @JvmStatic
        public static /* synthetic */ void TAG_TABLE$annotations() {
        }

        @NotNull
        public final String getTAG_TABLE() {
            return TAG_TABLE;
        }

        @JvmStatic
        public static /* synthetic */ void TAG_TABLE_ROW$annotations() {
        }

        @NotNull
        public final String getTAG_TABLE_ROW() {
            return TAG_TABLE_ROW;
        }

        @JvmStatic
        public static /* synthetic */ void TAG_TABLE_CELL$annotations() {
        }

        @NotNull
        public final String getTAG_TABLE_CELL() {
            return TAG_TABLE_CELL;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

