/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.BlockTag;
import com.x5.template.Chunk;
import com.x5.template.EndOfSnippetException;
import com.x5.template.SnippetBlockTag;
import com.x5.template.SnippetComment;
import com.x5.template.SnippetError;
import com.x5.template.SnippetPart;
import com.x5.template.SnippetTag;
import com.x5.template.SnippetToken;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Snippet {
    private List<SnippetPart> parts = null;
    private String simpleText = null;
    private String origin = null;
    private long lastAccess = 0L;
    private static boolean useCache = Snippet.isCacheEnabled();
    private static Map<String, Snippet> snippetCache = useCache ? new ConcurrentHashMap(512) : null;
    private static long lastGC = 0L;
    private static long gcCounter = 0L;
    private static final int gcInterval = 500;
    private static final long CAN_GC_AFTER = 60000L;
    public static final String MAGIC_CHARS = "~$%^./!*=+_";
    private static final int BLOCKSTART_TRIMMED_ALONE = -1;
    private static final int BLOCKSTART_ALONE = 0;
    private static final int BLOCKSTART_WITHBODY = 1;
    private static final int BLOCKSTART_MIDLINE = 2;
    private static final Pattern UNIVERSAL_LF = Pattern.compile("\n|\r\n|\r\r");

    private Snippet(String template) {
        this.parseParts(template);
    }

    private Snippet(String template, String origin) {
        this.origin = origin;
        this.parseParts(template);
    }

    public static Snippet getSnippet(String template) {
        if (useCache) {
            return Snippet.getSnippetFromCache(template, null);
        }
        return new Snippet(template);
    }

    public static Snippet getSnippet(String template, String origin) {
        if (useCache) {
            return Snippet.getSnippetFromCache(template, origin);
        }
        return new Snippet(template, origin);
    }

    private static Snippet getSnippetFromCache(String template, String origin) {
        Snippet s;
        long timestamp = System.currentTimeMillis();
        if (++gcCounter % 500L == 0L) {
            Snippet.pruneCache(timestamp);
        }
        if ((s = snippetCache.get(template)) != null) {
            s.lastAccess = timestamp;
            return s;
        }
        s = new Snippet(template, origin);
        s.lastAccess = timestamp;
        snippetCache.put(template, s);
        return s;
    }

    private static boolean isCacheEnabled() {
        String useCacheProperty = System.getProperty("chunk.snippetcache");
        return useCacheProperty != null;
    }

    private static void pruneCache(long timestamp) {
        long threshhold = timestamp - 60000L;
        if (lastGC > threshhold) {
            return;
        }
        for (Map.Entry<String, Snippet> entry : snippetCache.entrySet()) {
            if (entry.getValue().lastAccess >= threshhold) continue;
            snippetCache.remove(entry.getKey());
        }
        lastGC = timestamp;
    }

    public Snippet(List<SnippetPart> bodyParts) {
        if (bodyParts == null || bodyParts.size() == 0) {
            this.simpleText = "";
        } else {
            this.parts = bodyParts;
        }
    }

    public Snippet(List<SnippetPart> bodyParts, int from, int to) {
        if (bodyParts == null || bodyParts.size() == 0) {
            this.simpleText = "";
        } else {
            ArrayList<SnippetPart> subParts = new ArrayList<SnippetPart>();
            for (int i = from; i < to; ++i) {
                subParts.add(bodyParts.get(i));
            }
            this.parts = subParts;
        }
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getOrigin() {
        return this.origin;
    }

    public List<SnippetPart> getParts() {
        return this.parts;
    }

    private void parseParts(String template) {
        if (template == null) {
            return;
        }
        this.simpleText = null;
        int regexDelimCount = 0;
        int marker = 0;
        int tagStart = -1;
        int exprStart = -1;
        int trailingBackslashes = 0;
        boolean insideRegex = false;
        boolean insideTrToken = false;
        boolean insideComment = false;
        boolean insideLiteral = false;
        int magicChar = 0;
        int len = template.length();
        for (int i = 0; i < len; ++i) {
            char c = template.charAt(i);
            if (tagStart < 0) {
                if (i + 1 >= len) break;
                int c2 = template.charAt(i + 1);
                if (c == '{') {
                    if (MAGIC_CHARS.indexOf(c2) <= -1 || c2 == 36 && Snippet.isJavascriptHeadFake(i, template)) continue;
                    tagStart = i++;
                    trailingBackslashes = 0;
                    if (c2 == 37) {
                        if ((i += 2) == len) break;
                        int e0 = template.charAt(i);
                        while (i < len && Character.isWhitespace((char)e0)) {
                            e0 = template.charAt(++i);
                        }
                        if (MAGIC_CHARS.indexOf(e0) > -1) {
                            magicChar = e0;
                            exprStart = i + 1;
                            continue;
                        }
                        magicChar = 46;
                        exprStart = i;
                        continue;
                    }
                    magicChar = c2;
                    exprStart = i + 1;
                    continue;
                }
                if (c != '_' || c2 != 91) continue;
                tagStart = i++;
                insideTrToken = true;
                continue;
            }
            if (insideTrToken && c == ']') {
                if (trailingBackslashes % 2 != 0) continue;
                this.parts = this.getPartsForAppend();
                if (marker < tagStart) {
                    SnippetPart literal = new SnippetPart(template.substring(marker, tagStart));
                    literal.setLiteral(true);
                    this.parts.add(literal);
                }
                String wholeTag = template.substring(tagStart, i + 1);
                String tokenStr = template.substring(tagStart + 2, i);
                SnippetToken token = new SnippetToken(wholeTag, tokenStr);
                this.parts.add(token);
                marker = i + 1;
                tagStart = -1;
                insideTrToken = false;
                continue;
            }
            if (c == '}') {
                if (insideRegex || trailingBackslashes % 2 != 0) continue;
                if (insideLiteral) {
                    if (this.isLiteralClose(template, (char)magicChar, tagStart, i)) {
                        String literalText = template.substring(marker, i + 1);
                        SnippetPart literal = new SnippetPart(literalText);
                        literal.setLiteral(true);
                        this.parts.add(literal);
                        marker = i + 1;
                        insideLiteral = false;
                    }
                    tagStart = -1;
                    continue;
                }
                if (magicChar == 33) {
                    char c0 = template.charAt(i - 1);
                    char c00 = template.charAt(i - 2);
                    if (c0 == '-' && c00 == '-') {
                        i = this.extractComment(marker, tagStart, i, template, len);
                        tagStart = -1;
                        marker = i + 1;
                        insideComment = false;
                        continue;
                    }
                    insideComment = true;
                    continue;
                }
                SnippetPart tag = this.extractTag((char)magicChar, template, marker, tagStart, exprStart, i);
                if (tag != null) {
                    this.parts.add(tag);
                    marker = i + 1;
                    tagStart = -1;
                    continue;
                }
                insideLiteral = true;
                marker = tagStart;
                tagStart = -1;
                continue;
            }
            if (c == '/' && trailingBackslashes % 2 == 0) {
                if (regexDelimCount > 0) {
                    if (--regexDelimCount >= 1) continue;
                    insideRegex = false;
                    continue;
                }
                char c0 = template.charAt(i - 1);
                char c00 = template.charAt(i - 2);
                if (c0 == 's' && c00 == '|') {
                    regexDelimCount = 2;
                    insideRegex = true;
                    continue;
                }
                if (c0 == 'm' && (c00 == ',' || c00 == '(')) {
                    regexDelimCount = 1;
                    insideRegex = true;
                    continue;
                }
                if (c0 != ',' && (c0 != '(' || c00 != 'h')) continue;
                regexDelimCount = 1;
                insideRegex = true;
                continue;
            }
            if (c == '\\') {
                ++trailingBackslashes;
                continue;
            }
            if (trailingBackslashes <= 0) continue;
            trailingBackslashes = 0;
        }
        if (this.parts == null) {
            this.simpleText = template;
        } else {
            if (insideComment) {
                SnippetComment finalComment = new SnippetComment(template.substring(marker));
                this.parts.add(finalComment);
            } else if (marker < template.length()) {
                SnippetPart finalLiteral = new SnippetPart(template.substring(marker));
                finalLiteral.setLiteral(true);
                this.parts.add(finalLiteral);
            }
            this.groupBlocks(this.parts);
        }
    }

    private static boolean isJavascriptHeadFake(int i, String template) {
        char c4;
        int len = template.length();
        if (i + 2 >= len) {
            return true;
        }
        char c3 = template.charAt(i + 2);
        if (c3 == '.' || c3 == '(' || c3 == ' ' || c3 == '$') {
            return true;
        }
        return i + 3 < len && (c4 = template.charAt(i + 3)) == '(';
    }

    public boolean isSimple() {
        return this.simpleText != null;
    }

    private boolean isLiteralClose(String template, char magicChar, int tagStart, int i) {
        if (magicChar == '.' && i - tagStart > 8) {
            if (template.charAt(tagStart + 1) == '%') {
                String expr;
                int exprEnd = i - 1;
                if (template.charAt(exprEnd) == '%') {
                    --exprEnd;
                }
                if ((expr = template.substring(tagStart + 2, exprEnd).trim()).equals("endliteral") || expr.equals("/literal")) {
                    return true;
                }
            }
        } else if (magicChar == '^') {
            if (tagStart == i - 2) {
                return true;
            }
        } else if (magicChar == '~') {
            if (tagStart == i - 3 && template.charAt(i - 1) == '.') {
                return true;
            }
            if (tagStart == i - 11 && template.substring(tagStart + 3, i).equals("/literal")) {
                return true;
            }
        } else if (tagStart == i - 9 && magicChar == '/' && template.substring(tagStart + 1, i).equals("/literal")) {
            return true;
        }
        return false;
    }

    private SnippetPart extractTag(char magicChar, String template, int marker, int tagStart, int exprStart, int i) {
        String wholeTag;
        this.parts = this.getPartsForAppend();
        if (marker < tagStart) {
            SnippetPart literal = new SnippetPart(template.substring(marker, tagStart));
            literal.setLiteral(true);
            this.parts.add(literal);
        }
        if ((wholeTag = template.substring(tagStart, i + 1)).charAt(1) == '%') {
            if (wholeTag.charAt(wholeTag.length() - 2) == '%') {
                --i;
            }
            while (i > tagStart && Character.isWhitespace(wholeTag.charAt(i - tagStart - 1))) {
                --i;
            }
        }
        if (magicChar == '~' || magicChar == '$') {
            String gooeyCenter = template.substring(exprStart, i);
            if (gooeyCenter.startsWith(".end")) {
                gooeyCenter = "./" + gooeyCenter.substring(4);
            }
            SnippetTag tag = new SnippetTag(wholeTag, gooeyCenter);
            return tag;
        }
        if (magicChar == '^' || magicChar == '.') {
            String gooeyCenter = template.substring(exprStart, i);
            if (gooeyCenter.equals("literal") || gooeyCenter.equals("^")) {
                return null;
            }
            if (gooeyCenter.startsWith("end")) {
                gooeyCenter = "/" + gooeyCenter.substring(3);
            }
            SnippetTag tag = new SnippetTag(wholeTag, "." + gooeyCenter);
            return tag;
        }
        if (magicChar == '/') {
            String gooeyCenter = template.substring(exprStart, i);
            SnippetTag tag = new SnippetTag(wholeTag, "./" + gooeyCenter);
            return tag;
        }
        if (magicChar == '*') {
            if (wholeTag.length() == 3) {
                SnippetTag tag = new SnippetTag(wholeTag, "./exec");
                return tag;
            }
            int refEnd = i;
            if (template.charAt(i - 1) == '*') {
                --refEnd;
            }
            String macroTemplate = template.substring(exprStart, refEnd).trim();
            SnippetTag macroHead = new SnippetTag(wholeTag, ".exec " + macroTemplate + " original");
            return macroHead;
        }
        if (magicChar == '=') {
            if (wholeTag.length() == 3) {
                SnippetTag tag = new SnippetTag(wholeTag, "=");
                return tag;
            }
        } else {
            if (magicChar == '_') {
                SnippetToken token = SnippetToken.parseTokenWithArgs(wholeTag);
                return token;
            }
            if (magicChar == '+') {
                if (wholeTag.startsWith("{+(") || wholeTag.indexOf("+(") == exprStart - tagStart) {
                    String includeIfTag = ".includeIf(" + template.substring(exprStart + 1, i);
                    SnippetTag condInclude = new SnippetTag(wholeTag, includeIfTag);
                    return condInclude;
                }
                String includeTag = ".include " + template.substring(exprStart, i);
                SnippetTag include = new SnippetTag(wholeTag, includeTag);
                return include;
            }
            if (magicChar == '%') {
                SnippetPart literal = new SnippetPart(wholeTag);
                literal.setLiteral(true);
                return literal;
            }
        }
        SnippetPart wackyTag = new SnippetPart(wholeTag);
        return wackyTag;
    }

    private List<SnippetPart> getPartsForAppend() {
        if (this.parts == null) {
            this.parts = new ArrayList<SnippetPart>();
        }
        return this.parts;
    }

    private int extractComment(int marker, int tagStart, int i, String template, int len) {
        int lineBreakPos;
        this.parts = this.getPartsForAppend();
        String precedingComment = null;
        int startOfThisLine = marker;
        if (marker < tagStart && (lineBreakPos = (precedingComment = template.substring(marker, tagStart)).lastIndexOf(10)) > -1) {
            startOfThisLine = marker + lineBreakPos + 1;
        }
        if (startOfThisLine == tagStart || template.substring(startOfThisLine, tagStart).trim().length() == 0) {
            int endOfLine = template.indexOf(10, i + 1);
            if (endOfLine < 0) {
                endOfLine = len;
            }
            if (template.substring(i + 1, endOfLine).trim().length() == 0) {
                if (startOfThisLine < tagStart) {
                    precedingComment = template.substring(marker, startOfThisLine);
                    tagStart = startOfThisLine;
                }
                int n = i = endOfLine == len ? endOfLine - 1 : endOfLine;
            }
        }
        if (precedingComment != null) {
            SnippetPart literal = new SnippetPart(precedingComment);
            literal.setLiteral(true);
            this.parts.add(literal);
        }
        String wholeComment = template.substring(tagStart, i + 1);
        if (this.origin == null && this.parts.size() == 0 && wholeComment.startsWith("{!--@ORIGIN:")) {
            int endOfOrigin = wholeComment.indexOf("@", 12);
            if (endOfOrigin < 0) {
                endOfOrigin = wholeComment.length();
            }
            this.origin = wholeComment.substring(12, endOfOrigin);
        } else {
            SnippetComment comment = new SnippetComment(wholeComment);
            this.parts.add(comment);
        }
        return i;
    }

    private void groupBlocks(List<SnippetPart> bodyParts) {
        for (int i = 0; i < bodyParts.size(); ++i) {
            SnippetTag tag;
            BlockTag helper;
            SnippetPart part = bodyParts.get(i);
            if (!part.isTag() || (helper = (tag = (SnippetTag)part).getBlockTagType()) == null) continue;
            int j = BlockTag.findMatchingBlockEnd(helper, bodyParts, i + 1);
            if (j > i) {
                int trimType;
                int x;
                SnippetTag endTag = (SnippetTag)bodyParts.remove(j);
                ArrayList<SnippetPart> subBodyParts = new ArrayList<SnippetPart>();
                for (x = i + 1; x < j; ++x) {
                    subBodyParts.add(bodyParts.get(x));
                }
                for (x = j - 1; x >= i; --x) {
                    bodyParts.remove(x);
                }
                this.groupBlocks(subBodyParts);
                SnippetBlockTag blockTag = new SnippetBlockTag(tag, subBodyParts, endTag, this.origin);
                bodyParts.add(i, blockTag);
                if (!blockTag.doSmartTrimAroundBlock() || (trimType = this.smartTrimBeforeBlockStart(bodyParts, blockTag, i - 1)) == 2) continue;
                this.smartTrimAfterBlockEnd(bodyParts, blockTag, i + 1);
                continue;
            }
            String errMsg = "[ERROR in template! " + helper.getBlockStartMarker() + " block with no matching end marker! ]";
            SnippetError errorPart = new SnippetError(errMsg);
            bodyParts.add(i + 1, errorPart);
            ++i;
        }
    }

    private int smartTrimBeforeBlockStart(List<SnippetPart> parts, SnippetBlockTag blockTag, int prevPartIdx) {
        String text;
        if (this.blockBodyStartsOnSameLine(blockTag)) {
            return 1;
        }
        if (prevPartIdx < 0) {
            return 0;
        }
        SnippetPart prevPart = parts.get(prevPartIdx);
        while (prevPart instanceof SnippetComment) {
            if (--prevPartIdx < 0) {
                return 0;
            }
            prevPart = parts.get(prevPartIdx);
        }
        if (!prevPart.isLiteral()) {
            if (prevPart instanceof SnippetBlockTag) {
                prevPart = ((SnippetBlockTag)prevPart).getCloseTag();
            } else {
                return 2;
            }
        }
        if ((text = prevPart.getText()).length() == 0) {
            return this.smartTrimBeforeBlockStart(parts, blockTag, prevPartIdx - 1);
        }
        int i = text.length() - 1;
        char c = text.charAt(i);
        boolean eatWhitespace = false;
        while (Character.isWhitespace(c)) {
            if (c == '\n' || c == '\r') {
                ++i;
                eatWhitespace = true;
                break;
            }
            if (--i < 0) {
                i = 0;
                if (prevPartIdx == 0) {
                    eatWhitespace = true;
                    break;
                }
                int trimState = this.smartTrimBeforeBlockStart(parts, blockTag, prevPartIdx - 1);
                if (trimState > 0) {
                    return trimState;
                }
                eatWhitespace = true;
                break;
            }
            c = text.charAt(i);
        }
        if (eatWhitespace) {
            prevPart.setText(text.substring(0, i));
        }
        return eatWhitespace ? -1 : 2;
    }

    private boolean blockBodyStartsOnSameLine(SnippetBlockTag blockTag) {
        Snippet blockBody = blockTag.getBody();
        if (blockBody.parts != null) {
            for (int i = 0; i < blockBody.parts.size(); ++i) {
                int firstLF;
                String text;
                Matcher m;
                SnippetPart firstPart = blockBody.parts.get(i);
                if (firstPart instanceof SnippetComment) {
                    String commentText = firstPart.toString();
                    if (commentText.charAt(commentText.length() - 1) == '}') continue;
                    return false;
                }
                return firstPart.isLiteral() && (m = UNIVERSAL_LF.matcher(text = firstPart.getText())).find() && text.substring(0, firstLF = m.start()).trim().length() != 0;
                {
                }
            }
        }
        return false;
    }

    private void smartTrimAfterBlockEnd(List<SnippetPart> parts, SnippetBlockTag blockTag, int nextPartIdx) {
        int firstLF;
        String text;
        Matcher m;
        if (parts.size() <= nextPartIdx) {
            return;
        }
        SnippetPart nextPart = parts.get(nextPartIdx);
        while (nextPart instanceof SnippetComment) {
            String commentText = nextPart.toString();
            if (commentText.charAt(commentText.length() - 1) != '}') {
                return;
            }
            if (parts.size() <= ++nextPartIdx) {
                return;
            }
            nextPart = parts.get(nextPartIdx);
        }
        if (nextPart.isLiteral() && (m = UNIVERSAL_LF.matcher(text = nextPart.getText())).find() && text.substring(0, firstLF = m.start()).trim().length() == 0) {
            nextPart.setText(text.substring(m.end()));
            blockTag.getCloseTag().snippetText = blockTag.getCloseTag().snippetText + text.substring(0, m.end());
        }
    }

    public String toString() {
        return this._toString(true);
    }

    private String _toString(boolean withOrigin) {
        if (this.simpleText != null) {
            return this.simpleText;
        }
        if (this.parts == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (withOrigin && this.origin != null) {
            sb.append("{!--@ORIGIN:");
            sb.append(this.origin);
            sb.append("@--}");
        }
        for (SnippetPart part : this.parts) {
            sb.append(part.toString());
        }
        return sb.toString();
    }

    public String toSimpleString() {
        return this._toString(false);
    }

    public void render(Writer out, Chunk rules, int depth) throws IOException {
        if (this.simpleText != null) {
            out.append(this.simpleText);
        } else if (this.parts != null) {
            for (SnippetPart part : this.parts) {
                part.render(out, rules, this.origin, depth + 1);
            }
        }
    }

    public Snippet copy() {
        if (this.simpleText != null) {
            Snippet copy = new Snippet("");
            copy.simpleText = this.simpleText;
            return copy;
        }
        ArrayList<SnippetPart> partsCopy = new ArrayList<SnippetPart>();
        partsCopy.addAll(this.parts);
        Snippet copy = new Snippet(partsCopy);
        copy.origin = this.origin;
        return copy;
    }

    public static Snippet makeLiteralSnippet(String literal) {
        SnippetPart x = new SnippetPart(literal);
        x.setLiteral(true);
        ArrayList<SnippetPart> listOfOne = new ArrayList<SnippetPart>();
        listOfOne.add(x);
        return new Snippet(listOfOne);
    }

    boolean isSimplePointer() {
        SnippetPart onlyPart;
        return this.parts != null && this.parts.size() == 1 && (onlyPart = this.parts.get(0)) instanceof SnippetTag;
    }

    String getPointer() {
        if (this.isSimplePointer()) {
            SnippetPart onlyPart = this.parts.get(0);
            SnippetTag tag = (SnippetTag)onlyPart;
            return tag.getTag();
        }
        return null;
    }

    SnippetTag getPointerTag() {
        if (this.isSimplePointer()) {
            SnippetPart onlyPart = this.parts.get(0);
            SnippetTag tag = (SnippetTag)onlyPart;
            return tag;
        }
        return null;
    }

    static Snippet consolidateSnippets(Vector<Snippet> template) throws EndOfSnippetException {
        if (template == null) {
            return null;
        }
        if (template.size() == 1) {
            return template.get(0);
        }
        for (int i = 1; i < template.size(); ++i) {
            Snippet a = template.get(i - 1);
            Snippet b = template.get(i);
            if (a.origin == null && b.origin == null || a.origin != null && b.origin != null && a.origin.equals(b.origin)) continue;
            throw new EndOfSnippetException("Can't merge snippets, incompatible origins.");
        }
        ArrayList<SnippetPart> merged = new ArrayList<SnippetPart>();
        for (int i = 0; i < template.size(); ++i) {
            Snippet s = template.get(i);
            List<SnippetPart> parts = s.ungroupBlocks();
            if (parts == null) continue;
            merged.addAll(parts);
        }
        Snippet voltron = new Snippet(merged);
        voltron.origin = template.get((int)0).origin;
        voltron.groupBlocks(voltron.parts);
        return voltron;
    }

    private List<SnippetPart> ungroupBlocks() {
        if (this.parts == null) {
            if (this.simpleText.length() < 1) {
                return null;
            }
            ArrayList<SnippetPart> onePart = new ArrayList<SnippetPart>();
            SnippetPart simplePart = new SnippetPart(this.simpleText);
            simplePart.setLiteral(true);
            onePart.add(simplePart);
            return onePart;
        }
        boolean noBlocks = true;
        for (SnippetPart part : this.parts) {
            if (!(part instanceof SnippetBlockTag) && !(part instanceof SnippetError)) continue;
            noBlocks = false;
            break;
        }
        if (noBlocks) {
            return this.parts;
        }
        ArrayList<SnippetPart> flat = new ArrayList<SnippetPart>();
        for (SnippetPart part : this.parts) {
            if (part instanceof SnippetBlockTag) {
                SnippetBlockTag block = (SnippetBlockTag)part;
                flat.add(block.getOpenTag());
                Snippet body = block.getBody();
                flat.addAll(body.ungroupBlocks());
                flat.add(block.getCloseTag());
                continue;
            }
            if (part instanceof SnippetError) continue;
            flat.add(part);
        }
        return flat;
    }
}

