/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.util.TableData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTable
implements TableData,
Map<String, Object> {
    private String[] labels;
    private List<String[]> records;
    private int cursor = -1;
    private int size = 0;
    private Map<String, Integer> columnIndex;
    public static final String ANON_ARRAY_LABEL = "_anonymous_";

    public SimpleTable(String[] columnLabels, Vector<String[]> tableRows) {
        this.labels = columnLabels;
        this.records = new ArrayList<String[]>(tableRows);
    }

    public SimpleTable(String[] columnLabels, ArrayList<String[]> tableRows) {
        this.labels = columnLabels;
        this.records = tableRows;
    }

    public SimpleTable(String[] columnLabels, String[][] tableRows) {
        this.labels = columnLabels;
        this.records = new ArrayList<String[]>();
        if (tableRows != null) {
            for (int i = 0; i < tableRows.length; ++i) {
                this.records.add(tableRows[i]);
            }
        }
    }

    public SimpleTable(String[] data) {
        if (data == null) {
            return;
        }
        this.labels = new String[]{ANON_ARRAY_LABEL};
        this.records = new ArrayList<String[]>();
        for (int i = 0; i < data.length; ++i) {
            String[] record = new String[]{data[i]};
            this.records.add(record);
        }
    }

    public SimpleTable(List list) {
        if (list == null) {
            return;
        }
        this.labels = new String[]{ANON_ARRAY_LABEL};
        this.records = new ArrayList<String[]>();
        for (int i = 0; i < list.size(); ++i) {
            String[] record = new String[]{list.get(i).toString()};
            this.records.add(record);
        }
    }

    @Override
    public String[] getColumnLabels() {
        return this.labels;
    }

    @Override
    public void setColumnLabels(String[] labels) {
        this.labels = labels;
    }

    @Override
    public String[] getRow() {
        if (this.cursor < 0) {
            this.cursor = 0;
            int n = this.size = this.records == null ? 0 : this.records.size();
        }
        if (this.size > this.cursor) {
            return this.records.get(this.cursor);
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        if (this.size > this.cursor + 1) {
            return true;
        }
        if (this.size == 0) {
            this.size = this.records == null ? 0 : this.records.size();
            return this.size > this.cursor + 1;
        }
        return false;
    }

    @Override
    public Map<String, Object> nextRecord() {
        ++this.cursor;
        if (this.size > this.cursor) {
            return this;
        }
        if (this.size == 0) {
            this.size = this.records == null ? 0 : this.records.size();
            return this.size > this.cursor ? this : null;
        }
        return null;
    }

    @Override
    public void reset() {
        this.cursor = -1;
    }

    @Override
    public int size() {
        return this.labels == null ? 0 : this.labels.length;
    }

    @Override
    public boolean isEmpty() {
        return this.labels == null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.columnIndex == null) {
            this.indexColumns();
        }
        if (this.columnIndex == null) {
            return false;
        }
        return this.columnIndex.containsKey(key);
    }

    private void indexColumns() {
        if (this.labels != null) {
            this.columnIndex = new HashMap<String, Integer>(this.labels.length);
            for (int i = 0; i < this.labels.length; ++i) {
                this.columnIndex.put(this.labels[i], i);
            }
        }
    }

    @Override
    public boolean containsValue(Object value) {
        String[] record = this.getRow();
        if (record == null) {
            return false;
        }
        for (int i = 0; i < record.length; ++i) {
            if (!value.equals(record[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        if (this.labels == null) {
            return null;
        }
        if (this.columnIndex == null) {
            this.indexColumns();
        }
        if (this.columnIndex != null && this.columnIndex.containsKey(key)) {
            String[] record = this.getRow();
            try {
                return record[this.columnIndex.get(key)];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        return null;
    }

    @Override
    public Object remove(Object key) {
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
    }

    @Override
    public void clear() {
    }

    @Override
    public Set<String> keySet() {
        if (this.labels == null) {
            return null;
        }
        if (this.columnIndex == null) {
            this.indexColumns();
        }
        if (this.columnIndex != null) {
            return this.columnIndex.keySet();
        }
        return null;
    }

    @Override
    public Collection<Object> values() {
        String[] record = this.getRow();
        if (record == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < record.length; ++i) {
            list.add(record[i]);
        }
        return list;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return null;
    }
}

