/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import com.x5.template.Chunk;
import com.x5.template.filters.BasicFilter;
import com.x5.template.filters.ChunkFilter;
import com.x5.template.filters.FilterArgs;

public class OrdinalSuffixFilter
extends BasicFilter
implements ChunkFilter {
    public String transformText(Chunk chunk, String text, FilterArgs args) {
        if (text == null) {
            return null;
        }
        return OrdinalSuffixFilter.ordinalSuffix(text);
    }

    public String getFilterName() {
        return "th";
    }

    public String[] getFilterAliases() {
        return new String[]{"ord", "ordsuffix"};
    }

    private static String ordinalSuffix(String num) {
        int mod10;
        if (num == null) {
            return null;
        }
        int x = Integer.parseInt(num);
        int mod100 = x % 100;
        if (mod100 - (mod10 = x % 10) == 10) {
            return String.valueOf(num) + "th";
        }
        switch (mod10) {
            case 1: {
                return String.valueOf(num) + "st";
            }
            case 2: {
                return String.valueOf(num) + "nd";
            }
            case 3: {
                return String.valueOf(num) + "rd";
            }
        }
        return String.valueOf(num) + "th";
    }
}

