/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import com.x5.template.Chunk;
import com.x5.template.filters.BasicFilter;
import com.x5.template.filters.ChunkFilter;
import com.x5.template.filters.FilterArgs;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sun.misc.BASE64Encoder;

public class Base64EncodeFilter
extends BasicFilter
implements ChunkFilter {
    public String transformText(Chunk chunk, String text, FilterArgs args) {
        if (text == null) {
            return null;
        }
        return Base64EncodeFilter.base64(text);
    }

    public String getFilterName() {
        return "base64";
    }

    public String[] getFilterAliases() {
        return new String[]{"base64encode"};
    }

    public static String base64(String text) {
        try {
            byte[] textBytes = text.getBytes("UTF-8");
            return Base64EncodeFilter.base64(textBytes);
        }
        catch (UnsupportedEncodingException e) {
            return Base64EncodeFilter.base64(text.getBytes());
        }
    }

    public static String base64(byte[] bytes) {
        try {
            BASE64Encoder encoder = (BASE64Encoder)Class.forName("sun.misc.BASE64Encoder").newInstance();
            return encoder.encode(bytes);
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        try {
            Class<?> b64 = Class.forName("com.x5.util.Base64");
            Class[] paramTypes = new Class[]{byte[].class};
            Method encode = b64.getMethod("encodeBytes", paramTypes);
            String b64text = (String)encode.invoke(null, new Object[]{bytes});
            return b64text;
        }
        catch (ClassNotFoundException e2) {
        }
        catch (NoSuchMethodException e2) {
        }
        catch (IllegalAccessException e2) {
        }
        catch (InvocationTargetException e2) {
            // empty catch block
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }
}

