/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import com.x5.template.Chunk;
import com.x5.template.filters.BasicFilter;
import com.x5.template.filters.ChunkFilter;

public class PadRightFilter
extends BasicFilter
implements ChunkFilter {
    public String transformText(Chunk chunk, String text, String[] args) {
        return text == null ? null : this.padText(text, this.cleanArgs(args));
    }

    private String[] cleanArgs(String[] args) {
        if (args == null || args.length != 1) {
            return args;
        }
        String filterCall = args[0];
        if (filterCall == null || filterCall.equals(this.getFilterName())) {
            return null;
        }
        for (String alias : this.getFilterAliases()) {
            if (!filterCall.equals(alias)) continue;
            return null;
        }
        return args;
    }

    public String getFilterName() {
        return "rpad";
    }

    public String[] getFilterAliases() {
        return new String[]{"pad", "suffix"};
    }

    protected String padText(String text, String[] args) {
        if (text.length() == 0) {
            return text;
        }
        if (args == null || args.length == 0 && args[0].equals("rpad")) {
            return text + " ";
        }
        String suffix = args[0];
        int howmany = 1;
        if (args.length > 1) {
            suffix = args[1];
        }
        if (args.length > 2) {
            try {
                howmany = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (howmany == 1) {
            return text + suffix;
        }
        StringBuilder sb = new StringBuilder(text);
        for (int i = 0; i < howmany; ++i) {
            sb.append(suffix);
        }
        return sb.toString();
    }
}

