/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import com.x5.template.Chunk;
import com.x5.template.filters.BasicFilter;
import com.x5.template.filters.ChunkFilter;
import com.x5.util.Base64;
import java.io.UnsupportedEncodingException;

public class Base64DecodeFilter
extends BasicFilter
implements ChunkFilter {
    public String transformText(Chunk chunk, String text, String[] args) {
        if (text == null) {
            return null;
        }
        return Base64DecodeFilter.base64Decode(text);
    }

    public String getFilterName() {
        return "base64decode";
    }

    public static String base64Decode(String text) {
        byte[] textBytes;
        byte[] decoded = null;
        try {
            textBytes = text.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            textBytes = text.getBytes();
        }
        decoded = Base64.decode(textBytes, 0, textBytes.length);
        if (decoded == null) {
            return text;
        }
        try {
            return new String(decoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(decoded);
        }
    }
}

