/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.Chunk;
import com.x5.template.ChunkFactory;
import com.x5.template.ContentSource;
import com.x5.template.Snippet;
import com.x5.template.TemplateSet;
import com.x5.template.filters.ChunkFilter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Theme
implements ContentSource,
ChunkFactory {
    private ArrayList<ContentSource> themeLayers = new ArrayList();
    private String themesFolder;
    private String themeLayerNames;
    private String fileExtension;
    private static final String DEFAULT_THEMES_FOLDER = "themes";
    private String localeCode = null;
    private boolean renderErrs = true;
    private PrintStream errLog = null;
    private HashSet<ContentSource> altSources = null;
    private Map<String, ChunkFilter> customFilters;

    public Theme() {
        this(null, null, null);
    }

    public Theme(ContentSource templates) {
        this.themeLayers.add(templates);
    }

    public Theme(String themeLayerNames) {
        this(null, themeLayerNames, null);
    }

    public Theme(String themesFolder, String themeLayerNames) {
        this(themesFolder, themeLayerNames, null);
    }

    public Theme(String themesFolder, String themeLayerNames, String ext) {
        this.themesFolder = themesFolder;
        this.themeLayerNames = themeLayerNames;
        this.fileExtension = ext;
    }

    public void setDefaultFileExtension(String ext) {
        if (this.themeLayers.size() > 0) {
            throw new IllegalStateException("Must specify extension before lazy init.");
        }
        this.fileExtension = ext;
    }

    public void setLocale(String localeCode) {
        this.localeCode = localeCode;
    }

    public String getLocale() {
        return this.localeCode;
    }

    public void setEncoding(String encoding) {
        ArrayList<TemplateSet> templateSets = this.getTemplateSets();
        if (templateSets != null) {
            for (TemplateSet layer : templateSets) {
                layer.setEncoding(encoding);
            }
        }
    }

    private void init() {
        String[] layerNames;
        if (this.themesFolder == null) {
            this.themesFolder = DEFAULT_THEMES_FOLDER;
        }
        char lastChar = this.themesFolder.charAt(this.themesFolder.length() - 1);
        char fs = System.getProperty("file.separator").charAt(0);
        if (lastChar != '\\' && lastChar != '/' && lastChar != fs) {
            this.themesFolder = this.themesFolder + fs;
        }
        if ((layerNames = this.parseLayerNames(this.themeLayerNames)) == null) {
            TemplateSet simple = new TemplateSet(this.themesFolder, this.fileExtension, 0);
            if (!this.renderErrs) {
                simple.signalFailureWithNull();
            }
            this.themeLayers.add(simple);
        } else {
            for (int i = 0; i < layerNames.length; ++i) {
                TemplateSet x = new TemplateSet(this.themesFolder + layerNames[i], this.fileExtension, 0);
                x.setLayerName(layerNames[i]);
                x.signalFailureWithNull();
                this.themeLayers.add(x);
            }
        }
    }

    public void addLayer(ContentSource templates) {
        this.themeLayers.add(templates);
    }

    private ArrayList<ContentSource> getThemeLayers() {
        if (this.themeLayers.size() < 1) {
            this.init();
        }
        return this.themeLayers;
    }

    private String[] parseLayerNames(String themeLayerNames) {
        if (themeLayerNames == null) {
            return null;
        }
        return themeLayerNames.split(" *, *");
    }

    public void setDirtyInterval(int minutes) {
        ArrayList<TemplateSet> templateSets = this.getTemplateSets();
        if (templateSets != null) {
            for (TemplateSet layer : templateSets) {
                layer.setDirtyInterval(minutes);
            }
        }
    }

    public Snippet getSnippet(String templateName, String ext) {
        ArrayList<ContentSource> layers = this.getThemeLayers();
        for (int i = layers.size() - 1; i >= 0; --i) {
            ContentSource x = layers.get(i);
            Snippet template = x.getSnippet(";" + ext + ";" + templateName);
            if (template == null) continue;
            return template;
        }
        return this.prettyFail(templateName, ext);
    }

    @Override
    public Snippet getSnippet(String itemName) {
        ArrayList<ContentSource> layers = this.getThemeLayers();
        for (int i = layers.size() - 1; i >= 0; --i) {
            ContentSource x = layers.get(i);
            if (!x.provides(itemName)) continue;
            return x.getSnippet(itemName);
        }
        return this.prettyFail(itemName, null);
    }

    @Override
    public boolean provides(String itemName) {
        for (int i = this.themeLayers.size() - 1; i >= 0; --i) {
            ContentSource x = this.themeLayers.get(i);
            if (!x.provides(itemName)) continue;
            return true;
        }
        return false;
    }

    private Snippet prettyFail(String templateName, String ext) {
        ContentSource baseLayer;
        if (!this.renderErrs && this.errLog == null) {
            return null;
        }
        String prettyExt = ext;
        if (prettyExt == null && (baseLayer = this.themeLayers.get(0)) instanceof TemplateSet) {
            prettyExt = ((TemplateSet)baseLayer).getDefaultExtension();
        }
        StringBuilder err = new StringBuilder();
        err.append("[");
        if (prettyExt != null) {
            err.append(prettyExt);
            err.append(" ");
        }
        err.append("template '");
        err.append(templateName);
        err.append("' not found]");
        if (prettyExt != null) {
            String places = "";
            ArrayList<TemplateSet> templateSets = this.getTemplateSets();
            if (templateSets != null) {
                for (int i = templateSets.size() - 1; i >= 0; --i) {
                    TemplateSet ts = templateSets.get(i);
                    if (places.length() > 0) {
                        places = places + ",";
                    }
                    places = places + ts.getTemplatePath(templateName, prettyExt);
                }
            }
            if (places.length() > 0) {
                err.append("<!-- looked in [");
                err.append(places);
                err.append("] -->");
            }
        }
        if (this.errLog != null) {
            Chunk.logChunkError(this.errLog, err.toString());
        }
        return this.renderErrs ? Snippet.getSnippet(err.toString()) : null;
    }

    @Override
    public String fetch(String itemName) {
        ArrayList<ContentSource> layers = this.getThemeLayers();
        for (int i = layers.size() - 1; i >= 0; --i) {
            ContentSource x = layers.get(i);
            if (!x.provides(itemName)) continue;
            return x.fetch(itemName);
        }
        return null;
    }

    @Override
    public String getProtocol() {
        return "include";
    }

    @Override
    public Chunk makeChunk() {
        Chunk c = new Chunk();
        c.setMacroLibrary(this, this);
        this.shareContentSources(c);
        c.setLocale(this.localeCode);
        c.setErrorHandling(this.renderErrs, this.errLog);
        return c;
    }

    @Override
    public Chunk makeChunk(String templateName) {
        Chunk c = new Chunk();
        c.setMacroLibrary(this, this);
        c.append(this.getSnippet(templateName));
        this.shareContentSources(c);
        c.setLocale(this.localeCode);
        c.setErrorHandling(this.renderErrs, this.errLog);
        return c;
    }

    @Override
    public Chunk makeChunk(String templateName, String extension) {
        Chunk c = new Chunk();
        c.setMacroLibrary(this, this);
        c.append(this.getSnippet(templateName, extension));
        this.shareContentSources(c);
        c.setLocale(this.localeCode);
        c.setErrorHandling(this.renderErrs, this.errLog);
        return c;
    }

    public void addProtocol(ContentSource src) {
        if (this.altSources == null) {
            this.altSources = new HashSet();
        }
        this.altSources.add(src);
    }

    private void shareContentSources(Chunk c) {
        if (this.altSources == null) {
            return;
        }
        for (ContentSource src : this.altSources) {
            c.addProtocol(src);
        }
    }

    public void setJarContext(Class<?> classInSameJar) {
        ArrayList<TemplateSet> templateSets = this.getTemplateSets();
        if (templateSets != null) {
            for (TemplateSet layer : templateSets) {
                layer.setJarContext(classInSameJar);
            }
        }
    }

    public void setJarContext(Object ctx) {
        ArrayList<TemplateSet> templateSets = this.getTemplateSets();
        if (templateSets != null) {
            for (TemplateSet layer : templateSets) {
                layer.setJarContext(ctx);
            }
        }
    }

    private ArrayList<TemplateSet> getTemplateSets() {
        ArrayList<TemplateSet> sets = null;
        for (ContentSource x : this.getThemeLayers()) {
            if (!(x instanceof TemplateSet)) continue;
            if (sets == null) {
                sets = new ArrayList<TemplateSet>();
            }
            sets.add((TemplateSet)x);
        }
        return sets;
    }

    @Override
    public Map<String, ChunkFilter> getFilters() {
        return this.customFilters;
    }

    public void registerFilter(ChunkFilter filter) {
        if (this.customFilters == null) {
            this.customFilters = new HashMap<String, ChunkFilter>();
        }
        this.customFilters.put(filter.getFilterName(), filter);
        String[] aliases = filter.getFilterAliases();
        if (aliases != null) {
            for (String alias : aliases) {
                this.customFilters.put(alias, filter);
            }
        }
    }

    public void setErrorHandling(boolean renderErrs, PrintStream errLog) {
        this.renderErrs = renderErrs;
        this.errLog = errLog;
    }
}

