/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.Chunk;
import com.x5.template.ChunkFactory;
import com.x5.template.InlineTable;
import com.x5.template.Snippet;
import com.x5.template.TemplateSet;
import com.x5.template.filters.BasicFilter;
import com.x5.template.filters.ChunkFilter;
import com.x5.template.filters.RegexFilter;
import com.x5.util.DataCapsule;
import com.x5.util.TableData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filter {
    public static String FILTER_FIRST = "FILTER_FIRST";
    public static String FILTER_LAST = "FILTER_LAST";
    private static Map<String, ChunkFilter> filters = Filter.registerStockFilters();
    private static final Pattern parsePattern = Pattern.compile("includeIf\\(([\\!\\~])(.*)\\)\\.?([^\\)]*)$");
    private static final Pattern parsePatternAlt = Pattern.compile("include\\.\\(([\\!\\~])(.*)\\)([^\\)]*)$");

    private static Map<String, ChunkFilter> registerStockFilters() {
        if (filters == null) {
            filters = BasicFilter.getStockFilters();
        }
        return filters;
    }

    public static Object applyFilter(Chunk context, String filter, Object input) {
        ChunkFilter stockFilter;
        ChunkFilter userFilter;
        if (filter == null) {
            return input;
        }
        int pipePos = Filter.findNextFilter(filter);
        if (pipePos >= 0) {
            String firstFilter = filter.substring(0, pipePos);
            String nextFilters = filter.substring(pipePos + 1);
            Object output = Filter.applyFilter(context, firstFilter, input);
            return Filter.applyFilter(context, nextFilters, output);
        }
        String filterName = filter;
        String[] filterArgs = null;
        int parenPos = filter.indexOf(40);
        int slashPos = filter.indexOf(47);
        if (slashPos > -1 && (parenPos < 0 || parenPos > slashPos)) {
            filterName = filter.substring(0, slashPos);
            filterArgs = new String[]{filter.substring(slashPos)};
        } else if (parenPos > -1) {
            filterName = filter.substring(0, parenPos);
            filterArgs = Filter.parseArgs(filter.substring(parenPos + 1));
        } else {
            filterArgs = new String[]{filterName};
        }
        Map<String, ChunkFilter> customFilters = null;
        ChunkFactory userTheme = context.getChunkFactory();
        if (userTheme != null) {
            customFilters = userTheme.getFilters();
        }
        if (customFilters != null && (userFilter = customFilters.get(filterName)) != null) {
            try {
                return userFilter.applyFilter(context, input, filterArgs);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return input;
            }
        }
        if (filter.equals("type")) {
            return Filter.typeFilter(context, input);
        }
        if (input instanceof String || input instanceof Snippet) {
            String text = BasicFilter.stringify(input);
            if (filter.equals("trim")) {
                return text == null ? null : text.trim();
            }
            if (filter.startsWith("join(")) {
                TableData array;
                if (text != null && (array = InlineTable.parseTable(text)) != null) {
                    return Filter.joinInlineTable(array, filter);
                }
            } else if (filter.startsWith("get(")) {
                TableData array;
                if (text != null && (array = InlineTable.parseTable(text)) != null) {
                    return Filter.accessArrayIndex(array, filter);
                }
            } else if (filter.equals("type")) {
                return "STRING";
            }
        }
        if ((stockFilter = filters.get(filterName)) != null) {
            return stockFilter.applyFilter(context, input, filterArgs);
        }
        return input;
    }

    private static String[] parseArgs(String filter) {
        return Filter.parseArgs(filter, true);
    }

    private static String[] parseArgs(String filter, boolean splitOnComma) {
        int quote4;
        int quote3;
        int quote2;
        int quote1 = filter.indexOf("\"");
        boolean isQuoted = true;
        if (quote1 < 0 || filter.substring(0, quote1).trim().length() > 0) {
            quote1 = -1;
            quote2 = filter.lastIndexOf(")");
            if (quote2 < 0) {
                return null;
            }
            isQuoted = false;
        } else {
            quote2 = filter.indexOf("\"", quote1 + 1);
            if (quote2 < 0) {
                quote2 = filter.length();
            }
        }
        String arg0 = filter.substring(quote1 + 1, quote2);
        String arg1 = null;
        if (isQuoted && (quote3 = filter.indexOf("\"", quote2 + 1)) > 0 && (quote4 = filter.indexOf("\"", quote3 + 1)) > 0) {
            arg1 = filter.substring(quote3 + 1, quote4);
        }
        if (arg1 != null) {
            return new String[]{filter, arg0, arg1};
        }
        if (isQuoted || !splitOnComma || arg0.indexOf(",") < 0) {
            return new String[]{arg0};
        }
        return Filter.parseCommaDelimitedArgs(arg0);
    }

    private static String[] parseCommaDelimitedArgs(String argStr) {
        int nextParen;
        String finalArg;
        int commaPos;
        String[] args = new String[15];
        args[0] = argStr;
        int argX = 1;
        int marker = 0;
        while (argX < args.length && (commaPos = Filter.nextArgDelim(argStr, marker)) >= 0) {
            int endRegexPos;
            String regexOpen;
            String arg;
            int endQuotePos;
            int quotePos = Filter.nextUnescapedDelim("\"", argStr, marker);
            if (quotePos > -1 && quotePos < commaPos && argStr.substring(marker, quotePos).trim().length() == 0 && (endQuotePos = Filter.nextUnescapedDelim("\"", argStr, quotePos + 1)) > 0) {
                args[argX] = arg = argStr.substring(quotePos + 1, endQuotePos);
                ++argX;
                commaPos = Filter.nextArgDelim(argStr, endQuotePos + 1);
                if (commaPos > 0) {
                    marker = commaPos + 1;
                    continue;
                }
                marker = argStr.length();
                continue;
            }
            int regexPos = RegexFilter.nextRegexDelim(argStr, marker);
            if (regexPos > -1 && regexPos < commaPos && ((regexOpen = argStr.substring(marker, regexPos).trim()).length() == 0 || regexOpen.equals("m")) && (endRegexPos = RegexFilter.nextRegexDelim(argStr, regexPos + 1)) > 0) {
                String arg2;
                int endArgPos = commaPos = Filter.nextArgDelim(argStr, endRegexPos + 1);
                marker = commaPos < 0 ? (endArgPos = argStr.length()) : commaPos + 1;
                args[argX] = arg2 = argStr.substring(regexPos, endArgPos);
                ++argX;
                continue;
            }
            args[argX] = arg = argStr.substring(marker, commaPos);
            ++argX;
            marker = commaPos + 1;
            commaPos = Filter.nextArgDelim(argStr, marker);
        }
        if (argX == args.length) {
            return args;
        }
        int closeParenPos = Filter.nextUnescapedDelim(")", argStr, marker);
        int finalArgEnd = argStr.length();
        if (closeParenPos > 0) {
            finalArgEnd = closeParenPos;
        }
        args[argX] = finalArg = argStr.substring(marker, finalArgEnd);
        if (++argX + 1 < args.length && closeParenPos > 0 && closeParenPos + 1 < argStr.length() && (nextParen = argStr.indexOf(40, closeParenPos + 1)) > 0) {
            String appendixArg;
            String appendixTag = argStr.substring(closeParenPos + 1, nextParen);
            args[argX] = "|" + appendixTag + "|";
            ++argX;
            int endPos = argStr.length();
            if (argStr.endsWith(")")) {
                --endPos;
            }
            args[argX] = appendixArg = argStr.substring(nextParen + 1, endPos);
            ++argX;
        }
        String[] truncated = new String[argX];
        System.arraycopy(args, 0, truncated, 0, argX);
        return truncated;
    }

    public static String magicBraces(Chunk context, String output) {
        if (output == null || output.length() == 0) {
            return output;
        }
        char firstChar = output.charAt(0);
        if (firstChar == '~' || firstChar == '$') {
            return context != null ? context.makeTag(output) : "{" + output + "}";
        }
        if (firstChar == '^' || firstChar == '.') {
            if (context == null) {
                return "{." + output.substring(1) + TemplateSet.DEFAULT_TAG_END;
            }
            return context.makeTag('.' + output.substring(1));
        }
        if (firstChar == '+') {
            return "{" + output + "}";
        }
        return output;
    }

    public static int nextArgDelim(String arglist, int searchFrom) {
        return Filter.nextUnescapedDelim(",", arglist, searchFrom);
    }

    public static int nextUnescapedDelim(String delim, String regex, int searchFrom) {
        int delimPos = regex.indexOf(delim, searchFrom);
        boolean isProvenDelimeter = false;
        while (!isProvenDelimeter) {
            int bsCount = 0;
            while (delimPos - (1 + bsCount) >= searchFrom && regex.charAt(delimPos - (1 + bsCount)) == '\\') {
                ++bsCount;
            }
            if (bsCount % 2 == 0) {
                isProvenDelimeter = true;
                continue;
            }
            if ((delimPos = regex.indexOf(delim, delimPos + 1)) >= 0) continue;
            return -1;
        }
        return delimPos;
    }

    public static String[] splitFilters(String filter) {
        int startOfNext = Filter.findNextFilter(filter);
        if (startOfNext < 0) {
            return new String[]{filter};
        }
        ArrayList<String> filterList = new ArrayList<String>();
        while (startOfNext >= 0) {
            filterList.add(filter.substring(0, startOfNext));
            filter = filter.substring(startOfNext + 1);
            startOfNext = Filter.findNextFilter(filter);
        }
        filterList.add(filter);
        String[] filters = new String[filterList.size()];
        return filterList.toArray(filters);
    }

    private static int findNextFilter(String filter) {
        int pipePos = filter.indexOf(124);
        if (pipePos >= 0 && filter.startsWith("s/")) {
            int regexEnd = RegexFilter.nextRegexDelim(filter, 2);
            if (regexEnd < 0) {
                return pipePos;
            }
            if ((regexEnd = RegexFilter.nextRegexDelim(filter, regexEnd + 1)) < 0) {
                return pipePos;
            }
            if (regexEnd < pipePos) {
                return pipePos;
            }
            return filter.indexOf("|", regexEnd + 1);
        }
        if (pipePos >= 0 && filter.startsWith("onmatch")) {
            int closeParen;
            int openParen;
            int commaPos;
            int slashPos;
            boolean skippedArgs = false;
            int cursor = 8;
            while (!skippedArgs && (slashPos = filter.indexOf("/", cursor)) >= 0 && (slashPos = RegexFilter.nextRegexDelim(filter, slashPos + 1)) >= 0 && (commaPos = Filter.nextUnescapedDelim(",", filter, slashPos + 1)) >= 0) {
                int moreArgs = Filter.nextUnescapedDelim(",", filter, commaPos + 1);
                if (moreArgs < 0) {
                    int closeParen2 = Filter.nextUnescapedDelim(")", filter, commaPos + 1);
                    if (closeParen2 < 0) break;
                    if (filter.length() > closeParen2 + 8 && filter.substring(closeParen2 + 1, closeParen2 + 8).equals("nomatch")) {
                        cursor = closeParen2 + 1;
                        skippedArgs = true;
                        continue;
                    }
                    pipePos = filter.indexOf("|", closeParen2 + 1);
                    return pipePos;
                }
                cursor = moreArgs + 1;
            }
            if ((openParen = filter.indexOf("(", cursor)) > 0 && (closeParen = Filter.nextUnescapedDelim(")", filter, openParen + 1)) > 0) {
                pipePos = filter.indexOf("|", closeParen + 1);
                return pipePos;
            }
            pipePos = filter.indexOf("|", cursor);
            return pipePos;
        }
        return pipePos;
    }

    public static String translateIncludeIf(String tag, String open, String close, Map<String, Object> tagTable) {
        Matcher parseMatcher = parsePattern.matcher(tag);
        if (!parseMatcher.find() && !(parseMatcher = parsePatternAlt.matcher(tag)).find()) {
            return "[includeIf bad syntax: " + tag + "]";
        }
        parseMatcher.group(0);
        String negater = parseMatcher.group(1);
        String test = parseMatcher.group(2);
        String includeTemplate = parseMatcher.group(3);
        includeTemplate = includeTemplate.replaceAll("[\\|:].*$", "");
        if (test.indexOf(61) < 0 && test.indexOf("!~") < 0) {
            if (negater.charAt(0) == '~') {
                return open + test + "|ondefined(+" + includeTemplate + "):" + close;
            }
            return open + test + "|ondefined():+" + includeTemplate + close;
        }
        boolean isNeg = false;
        if (test.indexOf("==") > 0 || (isNeg = test.indexOf("!=") > 0)) {
            String[] parts = test.split("!=|==");
            if (parts.length == 2) {
                String xlation;
                String tagA = parts[0].trim();
                String tagB = parts[1].trim();
                if (tagB.charAt(0) == '~') {
                    String tagValue = null;
                    Object tagValueObj = tagTable.get(tagA);
                    if (tagValueObj != null) {
                        tagValue = tagValueObj.toString();
                    }
                    if (tagValue == null) {
                        tagValue = "";
                    }
                    xlation = isNeg ? open + tagB.substring(1) + "|onmatch(/^" + RegexFilter.escapeRegex(tagValue) + "$/,)nomatch(+" + includeTemplate + ")" + close : open + tagB.substring(1) + "|onmatch(/^" + RegexFilter.escapeRegex(tagValue) + "$/,+" + includeTemplate + ")nomatch()" + close;
                } else {
                    String match = tagB;
                    if (tagB.charAt(0) == '\"' && tagB.charAt(match.length() - 1) == '\"') {
                        match = tagB.substring(1, tagB.length() - 1);
                    }
                    xlation = isNeg ? open + tagA + "|onmatch(/^" + RegexFilter.escapeRegex(match) + "$/,)nomatch(+" + includeTemplate + ")" + close : open + tagA + "|onmatch(/^" + RegexFilter.escapeRegex(match) + "$/,+" + includeTemplate + ")nomatch()" + close;
                }
                return xlation;
            }
            return "[includeIf bad syntax: " + tag + "]";
        }
        String[] parts = test.split("=~");
        boolean neg = false;
        if (parts.length != 2) {
            parts = test.split("!~");
            neg = true;
            if (parts.length != 2) {
                return "[includeIf bad syntax: " + tag + "]";
            }
        }
        String var = parts[0].trim();
        String match = parts[1].trim();
        String xlation = neg ? open + var + "|onmatch(" + match + ",)nomatch(+" + includeTemplate + ")" + close : open + var + "|onmatch(" + match + ",+" + includeTemplate + ")nomatch()" + close;
        return xlation;
    }

    public static int grokFinalFilterPipe(String wholeTag, int startHere) {
        int cursor = startHere;
        String filter = wholeTag.substring(cursor + 1);
        int startOfNext = Filter.findNextFilter(filter);
        while (startOfNext >= 0) {
            ++cursor;
            cursor += startOfNext;
            startOfNext = Filter.findNextFilter(filter.substring(startOfNext + 1));
        }
        return cursor;
    }

    public static int grokValidColonScanPoint(String wholeTag, int startHere) {
        int openParen;
        if (wholeTag.charAt(startHere) == 's' && wholeTag.charAt(startHere + 1) == '/') {
            int regexMid = RegexFilter.nextRegexDelim(wholeTag, startHere + 2);
            int regexEnd = RegexFilter.nextRegexDelim(wholeTag, regexMid + 1);
            return regexEnd + 1;
        }
        if (wholeTag.length() > startHere + 7 && wholeTag.substring(startHere, startHere + 7).equals("onmatch")) {
            int commaPos;
            int slashPos;
            boolean skippedArgs = false;
            startHere += 8;
            while (!skippedArgs && (slashPos = wholeTag.indexOf("/", startHere)) >= 0 && (slashPos = RegexFilter.nextRegexDelim(wholeTag, slashPos + 1)) >= 0 && (commaPos = Filter.nextUnescapedDelim(",", wholeTag, slashPos + 1)) >= 0) {
                int moreArgs = Filter.nextUnescapedDelim(",", wholeTag, commaPos + 1);
                if (moreArgs < 0) {
                    int closeParen = Filter.nextUnescapedDelim(")", wholeTag, commaPos + 1);
                    if (closeParen < 0) break;
                    if (wholeTag.length() > closeParen + 8 && wholeTag.substring(closeParen + 1, closeParen + 8).equals("nomatch")) {
                        startHere = closeParen + 1;
                        skippedArgs = true;
                        continue;
                    }
                    return closeParen + 1;
                }
                startHere = moreArgs + 1;
            }
        }
        if ((openParen = wholeTag.indexOf("(", startHere)) < 0) {
            return startHere;
        }
        int closeParen = Filter.nextUnescapedDelim(")", wholeTag, openParen + 1);
        if (closeParen < 0) {
            return startHere;
        }
        return closeParen + 1;
    }

    public static String accessArrayIndex(TableData table, String getFilter) {
        return Filter.accessArrayIndex(Filter.extractListFromTable(table), getFilter);
    }

    public static String accessArrayIndex(String[] array, String getFilter) {
        if (array == null) {
            return "";
        }
        return Filter.accessArrayIndex(Arrays.asList(array), getFilter);
    }

    public static String accessArrayIndex(List<String> list, String getFilter) {
        if (list == null) {
            return "";
        }
        int parenPos = getFilter.indexOf(40);
        if (parenPos > 0) {
            String[] args = Filter.parseArgs(getFilter.substring(parenPos + 1), false);
            String idx = args[0];
            try {
                int x = Integer.parseInt(idx);
                if (x < 0) {
                    x = list.size() + x;
                }
                if (x >= 0 && x < list.size()) {
                    return list.get(x);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return "";
    }

    private static List<String> extractListFromTable(TableData table) {
        if (table == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        while (table.hasNext()) {
            table.nextRecord();
            String[] record = table.getRow();
            list.add(record[0]);
        }
        return list;
    }

    public static String joinInlineTable(TableData table, String joinFilter) {
        return Filter.joinStringList(Filter.extractListFromTable(table), joinFilter);
    }

    public static String joinStringArray(String[] array, String joinFilter) {
        if (array == null) {
            return "";
        }
        if (array.length == 1) {
            return array[0];
        }
        return Filter.joinStringList(Arrays.asList(array), joinFilter);
    }

    public static String joinStringList(List<String> list, String joinFilter) {
        if (list == null) {
            return "";
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        String divider = null;
        int parenPos = joinFilter.indexOf(40);
        if (parenPos > 0) {
            String[] args = Filter.parseArgs(joinFilter.substring(parenPos + 1), false);
            divider = args[0];
        }
        StringBuilder x = new StringBuilder();
        int i = 0;
        for (String s : list) {
            if (i > 0 && divider != null) {
                x.append(divider);
            }
            if (s != null) {
                x.append(s);
            }
            ++i;
        }
        return x.toString();
    }

    public static String typeFilter(Chunk context, Object tagValue) {
        return Filter._typeFilter(context, tagValue, 0);
    }

    private static String _typeFilter(Chunk context, Object tagValue, int depth) {
        if (depth > 7) {
            return "CIRCULAR_POINTER";
        }
        if (tagValue == null) {
            return "NULL";
        }
        if (tagValue instanceof String) {
            if (Filter.isInlineTable((String)tagValue)) {
                return "LIST";
            }
            return "STRING";
        }
        if (tagValue instanceof Snippet) {
            if (Filter.isInlineTable(tagValue.toString())) {
                return "LIST";
            }
            Snippet snippet = (Snippet)tagValue;
            if (snippet.isSimplePointer()) {
                String tagRef = snippet.getPointer();
                return Filter._typeFilter(context, context.get(tagRef), depth + 1);
            }
            return "STRING";
        }
        if (tagValue instanceof Chunk) {
            return "CHUNK";
        }
        if (tagValue instanceof String[] || tagValue instanceof List || tagValue instanceof Object[] || tagValue instanceof TableData) {
            return "LIST";
        }
        if (tagValue instanceof Map || tagValue instanceof DataCapsule) {
            return "OBJECT";
        }
        return "UNKNOWN";
    }

    private static boolean isInlineTable(String value) {
        TableData inlineTable = InlineTable.parseTable(value);
        return inlineTable != null;
    }
}

