/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import com.x5.template.Chunk;
import com.x5.template.ChunkLocale;
import com.x5.template.filters.BasicFilter;
import com.x5.template.filters.ChunkFilter;
import java.util.Locale;

public class LetterCaseFilter
extends BasicFilter
implements ChunkFilter {
    int OP_UPPER = 0;
    int OP_LOWER = 1;
    int OP_CAPITALIZE = 2;
    int OP_TITLE = 4;

    public String transformText(Chunk chunk, String text, String[] args) {
        if (text == null) {
            return null;
        }
        int op = this.OP_UPPER;
        if (args != null && (args[0].equals("lower") || args[0].equals("lc"))) {
            op = this.OP_LOWER;
        } else if (args != null && (args[0].equals("capitalize") || args[0].equals("cap"))) {
            op = this.OP_CAPITALIZE;
        } else if (args != null && args[0].equals("title")) {
            op = this.OP_TITLE;
        }
        ChunkLocale locale = chunk == null ? null : chunk.getLocale();
        Locale javaLocale = null;
        if (locale != null) {
            javaLocale = locale.getJavaLocale();
        }
        if (javaLocale == null) {
            if (op == this.OP_UPPER) {
                return text.toUpperCase();
            }
            if (op == this.OP_LOWER) {
                return text.toLowerCase();
            }
            if (op == this.OP_CAPITALIZE) {
                return this.capitalize(text, null, false);
            }
            if (op == this.OP_TITLE) {
                return this.capitalize(text, null, true);
            }
        } else {
            if (op == this.OP_UPPER) {
                return text.toUpperCase(javaLocale);
            }
            if (op == this.OP_LOWER) {
                return text.toLowerCase(javaLocale);
            }
            if (op == this.OP_CAPITALIZE) {
                return this.capitalize(text, javaLocale, false);
            }
            if (op == this.OP_TITLE) {
                return this.capitalize(text, javaLocale, true);
            }
        }
        return null;
    }

    private String capitalize(String text, Locale javaLocale, boolean lcFirst) {
        if (lcFirst) {
            text = javaLocale == null ? text.toLowerCase() : text.toLowerCase(javaLocale);
        }
        char[] chars = text.toCharArray();
        boolean found = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!found && Character.isLetter(chars[i])) {
                chars[i] = javaLocale == null ? Character.toUpperCase(chars[i]) : Character.toString(chars[i]).toUpperCase(javaLocale).charAt(0);
                found = true;
                continue;
            }
            if (!Character.isWhitespace(chars[i]) && chars[i] != '.' && chars[i] != '\'') continue;
            found = false;
        }
        return String.valueOf(chars);
    }

    public String getFilterName() {
        return "upper";
    }

    public String[] getFilterAliases() {
        return new String[]{"uc", "lower", "lc", "capitalize", "cap", "title"};
    }
}

