/*
 * Decompiled with CFR 0.152.
 */
package com.wx.ovalimageview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.wx.ovalimageview.R;
import com.wx.ovalimageview.RoundDrawable;

public class RoundImageView
extends ImageView {
    private int mBorderColor;
    private int mBorderWidth;
    private boolean mIsCircle = false;

    public RoundImageView(Context context) {
        super(context);
    }

    public RoundImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    public RoundImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs);
    }

    @TargetApi(value=21)
    public RoundImageView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        try {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.round_imageview);
            this.mBorderColor = ta.getColor(R.styleable.round_imageview_border_color, 0);
            this.mBorderWidth = (int)ta.getDimension(R.styleable.round_imageview_border_width, 0.0f);
            this.mIsCircle = ta.getBoolean(R.styleable.round_imageview_circle, false);
            ta.recycle();
            int resId = attrs.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "src", -1);
            if (resId != -1) {
                this.setImageResource(resId, this.mBorderColor, this.mBorderWidth, this.mIsCircle);
            }
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    public void setBorderColor(String borderColor) {
        this.mBorderColor = Color.parseColor((String)borderColor);
    }

    public void setBorderColor(int borderColor) {
        this.mBorderColor = borderColor;
    }

    public int getBorderWidth() {
        return this.mBorderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.mBorderWidth = borderWidth;
    }

    public boolean isCircle() {
        return this.mIsCircle;
    }

    public void setCircle(boolean isCircle) {
        this.mIsCircle = isCircle;
    }

    public void setImageResource(int resId) {
        this.setImageResource(resId, this.mBorderColor, this.mBorderWidth, this.mIsCircle);
    }

    public void setImageResource(int resId, int borderColor, int borderWidth, boolean isCircle) {
        this.setImageDrawable(this.getResources().getDrawable(resId), borderColor, borderWidth, isCircle);
    }

    public void setImageDrawable(Drawable drawable) {
        this.setImageDrawable(drawable, this.mBorderColor, this.mBorderWidth, this.mIsCircle);
    }

    public void setImageDrawable(Drawable drawable, int borderColor, int borderWidth, boolean isCircle) {
        Bitmap bm = RoundImageView.drawableToBitmap(drawable);
        this.setImageBitmap(bm, borderColor, borderWidth, isCircle);
    }

    public void setImageBitmap(Bitmap bm) {
        this.setImageBitmap(bm, this.mBorderColor, this.mBorderWidth, this.mIsCircle);
    }

    public void setImageBitmap(Bitmap bm, int borderColor, int borderWidth, boolean isCircle) {
        super.setImageDrawable((Drawable)new RoundDrawable(bm, borderColor, borderWidth, isCircle));
    }

    private static Bitmap drawableToBitmap(Drawable d) {
        return d == null ? null : ((BitmapDrawable)d).getBitmap();
    }
}

