/*
 * Decompiled with CFR 0.152.
 */
package com.wuyr.pathlayoutmanager.keyframes;

import android.graphics.Path;
import android.graphics.PathMeasure;
import android.support.annotation.FloatRange;
import com.wuyr.pathlayoutmanager.keyframes.PosTan;

public class Keyframes {
    private static final float PRECISION = 0.5f;
    private int mNumPoints;
    private float[] mX;
    private float[] mY;
    private float[] mAngle;
    private PosTan mTemp;
    private float mMaxX;
    private float mMaxY;

    public Keyframes(Path path) {
        this.initPath(path);
        this.mTemp = new PosTan();
    }

    private void initPath(Path path) {
        if (path == null || path.isEmpty()) {
            throw new NullPointerException("path is empty!");
        }
        PathMeasure pathMeasure = new PathMeasure(path, false);
        this.mX = new float[0];
        this.mY = new float[0];
        this.mAngle = new float[0];
        do {
            float pathLength = pathMeasure.getLength();
            int numPoints = (int)(pathLength / 0.5f) + 1;
            float[] x = new float[numPoints];
            float[] y = new float[numPoints];
            float[] angle = new float[numPoints];
            float[] position = new float[2];
            float[] tangent = new float[2];
            for (int i = 0; i < numPoints; ++i) {
                float distance = (float)i * pathLength / (float)(numPoints - 1);
                pathMeasure.getPosTan(distance, position, tangent);
                if (position[0] > this.mMaxX) {
                    this.mMaxX = position[0];
                }
                if (position[1] > this.mMaxY) {
                    this.mMaxY = position[1];
                }
                x[i] = position[0];
                y[i] = position[1];
                angle[i] = this.fixAngle((float)(Math.atan2(tangent[1], tangent[0]) * 180.0 / Math.PI));
            }
            this.mNumPoints += numPoints;
            float[] tmpX = new float[this.mX.length + x.length];
            System.arraycopy(this.mX, 0, tmpX, 0, this.mX.length);
            System.arraycopy(x, 0, tmpX, this.mX.length, x.length);
            this.mX = tmpX;
            float[] tmpY = new float[this.mY.length + y.length];
            System.arraycopy(this.mY, 0, tmpY, 0, this.mY.length);
            System.arraycopy(y, 0, tmpY, this.mY.length, y.length);
            this.mY = tmpY;
            float[] tmpAngle = new float[this.mAngle.length + angle.length];
            System.arraycopy(this.mAngle, 0, tmpAngle, 0, this.mAngle.length);
            System.arraycopy(angle, 0, tmpAngle, this.mAngle.length, angle.length);
            this.mAngle = tmpAngle;
        } while (pathMeasure.nextContour());
    }

    private float fixAngle(float rotation) {
        float angle = 360.0f;
        if (rotation < 0.0f) {
            rotation += angle;
        }
        if (rotation > angle) {
            rotation %= angle;
        }
        return rotation;
    }

    public int getMaxX() {
        return (int)this.mMaxX;
    }

    public int getMaxY() {
        return (int)this.mMaxY;
    }

    public PosTan getValue(@FloatRange(from=0.0, to=1.0) float fraction) {
        if (fraction >= 1.0f || fraction < 0.0f) {
            return null;
        }
        int index = (int)((float)this.mNumPoints * fraction);
        this.mTemp.set(this.mX[index], this.mY[index], this.mAngle[index]);
        return this.mTemp;
    }

    public PosTan getValue(int index) {
        this.mTemp.set(this.mX[index], this.mY[index], this.mAngle[index]);
        return this.mTemp;
    }

    public int getPathLength() {
        return this.mNumPoints / 2;
    }

    public void release() {
        this.mX = null;
        this.mY = null;
        this.mAngle = null;
        this.mTemp = null;
    }
}

