/*
 * Decompiled with CFR 0.152.
 */
package com.wuyr.pathlayoutmanager;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.view.View;
import android.view.ViewPropertyAnimator;
import java.util.ArrayList;
import java.util.List;

public class RepairedItemAnimator
extends SimpleItemAnimator {
    private static final boolean DEBUG = false;
    private static TimeInterpolator sDefaultInterpolator;
    private ArrayList<RecyclerView.ViewHolder> mPendingRemovals = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mPendingAdditions = new ArrayList();
    private ArrayList<MoveInfo> mPendingMoves = new ArrayList();
    private ArrayList<ChangeInfo> mPendingChanges = new ArrayList();
    private ArrayList<ArrayList<RecyclerView.ViewHolder>> mAdditionsList = new ArrayList();
    private ArrayList<ArrayList<MoveInfo>> mMovesList = new ArrayList();
    private ArrayList<ArrayList<ChangeInfo>> mChangesList = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mAddAnimations = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mMoveAnimations = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mRemoveAnimations = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mChangeAnimations = new ArrayList();
    private OnErrorListener mOnErrorListener;

    public void runPendingAnimations() {
        boolean additionsPending;
        boolean removalsPending = !this.mPendingRemovals.isEmpty();
        boolean movesPending = !this.mPendingMoves.isEmpty();
        boolean changesPending = !this.mPendingChanges.isEmpty();
        boolean bl = additionsPending = !this.mPendingAdditions.isEmpty();
        if (!(removalsPending || movesPending || additionsPending || changesPending)) {
            return;
        }
        for (RecyclerView.ViewHolder holder : this.mPendingRemovals) {
            this.animateRemoveImpl(holder);
        }
        this.mPendingRemovals.clear();
        if (movesPending) {
            final ArrayList<MoveInfo> moves = new ArrayList<MoveInfo>(this.mPendingMoves);
            this.mMovesList.add(moves);
            this.mPendingMoves.clear();
            Runnable mover = new Runnable(){

                @Override
                public void run() {
                    for (MoveInfo moveInfo : moves) {
                        RepairedItemAnimator.this.animateMoveImpl(moveInfo.holder, moveInfo.fromX, moveInfo.fromY, moveInfo.toX, moveInfo.toY);
                    }
                    moves.clear();
                    RepairedItemAnimator.this.mMovesList.remove(moves);
                }
            };
            if (removalsPending) {
                View view = moves.get((int)0).holder.itemView;
                ViewCompat.postOnAnimationDelayed((View)view, (Runnable)mover, (long)this.getRemoveDuration());
            } else {
                mover.run();
            }
        }
        if (changesPending) {
            final ArrayList<ChangeInfo> changes = new ArrayList<ChangeInfo>(this.mPendingChanges);
            this.mChangesList.add(changes);
            this.mPendingChanges.clear();
            Runnable changer = new Runnable(){

                @Override
                public void run() {
                    for (ChangeInfo change : changes) {
                        RepairedItemAnimator.this.animateChangeImpl(change);
                    }
                    changes.clear();
                    RepairedItemAnimator.this.mChangesList.remove(changes);
                }
            };
            if (removalsPending) {
                RecyclerView.ViewHolder holder = changes.get((int)0).oldHolder;
                ViewCompat.postOnAnimationDelayed((View)holder.itemView, (Runnable)changer, (long)this.getRemoveDuration());
            } else {
                changer.run();
            }
        }
        if (additionsPending) {
            final ArrayList<RecyclerView.ViewHolder> additions = new ArrayList<RecyclerView.ViewHolder>(this.mPendingAdditions);
            this.mAdditionsList.add(additions);
            this.mPendingAdditions.clear();
            Runnable adder = new Runnable(){

                @Override
                public void run() {
                    for (RecyclerView.ViewHolder holder : additions) {
                        RepairedItemAnimator.this.animateAddImpl(holder);
                    }
                    additions.clear();
                    RepairedItemAnimator.this.mAdditionsList.remove(additions);
                }
            };
            if (removalsPending || movesPending || changesPending) {
                long removeDuration = removalsPending ? this.getRemoveDuration() : 0L;
                long moveDuration = movesPending ? this.getMoveDuration() : 0L;
                long changeDuration = changesPending ? this.getChangeDuration() : 0L;
                long totalDelay = removeDuration + Math.max(moveDuration, changeDuration);
                View view = additions.get((int)0).itemView;
                ViewCompat.postOnAnimationDelayed((View)view, (Runnable)adder, (long)totalDelay);
            } else {
                adder.run();
            }
        }
    }

    public boolean animateRemove(RecyclerView.ViewHolder holder) {
        this.resetAnimation(holder);
        this.mPendingRemovals.add(holder);
        return true;
    }

    private void animateRemoveImpl(final RecyclerView.ViewHolder holder) {
        final View view = holder.itemView;
        final ViewPropertyAnimator animation = view.animate();
        this.mRemoveAnimations.add(holder);
        animation.setDuration(this.getRemoveDuration()).alpha(0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                RepairedItemAnimator.this.dispatchRemoveStarting(holder);
            }

            public void onAnimationEnd(Animator animator) {
                block2: {
                    animation.setListener(null);
                    view.setAlpha(1.0f);
                    try {
                        RepairedItemAnimator.this.dispatchRemoveFinished(holder);
                    }
                    catch (Exception e) {
                        if (RepairedItemAnimator.this.mOnErrorListener == null) break block2;
                        RepairedItemAnimator.this.mOnErrorListener.onError(holder);
                    }
                }
                RepairedItemAnimator.this.mRemoveAnimations.remove(holder);
                RepairedItemAnimator.this.dispatchFinishedWhenDone();
            }
        }).start();
    }

    public boolean animateAdd(RecyclerView.ViewHolder holder) {
        this.resetAnimation(holder);
        holder.itemView.setAlpha(0.0f);
        this.mPendingAdditions.add(holder);
        return true;
    }

    private void animateAddImpl(final RecyclerView.ViewHolder holder) {
        final View view = holder.itemView;
        final ViewPropertyAnimator animation = view.animate();
        this.mAddAnimations.add(holder);
        animation.alpha(1.0f).setDuration(this.getAddDuration()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                RepairedItemAnimator.this.dispatchAddStarting(holder);
            }

            public void onAnimationCancel(Animator animator) {
                view.setAlpha(1.0f);
            }

            public void onAnimationEnd(Animator animator) {
                block2: {
                    animation.setListener(null);
                    try {
                        RepairedItemAnimator.this.dispatchAddFinished(holder);
                    }
                    catch (Exception e) {
                        if (RepairedItemAnimator.this.mOnErrorListener == null) break block2;
                        RepairedItemAnimator.this.mOnErrorListener.onError(holder);
                    }
                }
                RepairedItemAnimator.this.mAddAnimations.remove(holder);
                RepairedItemAnimator.this.dispatchFinishedWhenDone();
            }
        }).start();
    }

    public boolean animateMove(RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
        View view = holder.itemView;
        this.resetAnimation(holder);
        int deltaX = toX - (fromX += (int)holder.itemView.getTranslationX());
        int deltaY = toY - (fromY += (int)holder.itemView.getTranslationY());
        if (deltaX == 0 && deltaY == 0) {
            block5: {
                try {
                    this.dispatchMoveFinished(holder);
                }
                catch (Exception e) {
                    if (this.mOnErrorListener == null) break block5;
                    this.mOnErrorListener.onError(holder);
                }
            }
            return false;
        }
        if (deltaX != 0) {
            view.setTranslationX((float)(-deltaX));
        }
        if (deltaY != 0) {
            view.setTranslationY((float)(-deltaY));
        }
        this.mPendingMoves.add(new MoveInfo(holder, fromX, fromY, toX, toY));
        return true;
    }

    private void animateMoveImpl(final RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
        final View view = holder.itemView;
        final int deltaX = toX - fromX;
        final int deltaY = toY - fromY;
        if (deltaX != 0) {
            view.animate().translationX(0.0f);
        }
        if (deltaY != 0) {
            view.animate().translationY(0.0f);
        }
        final ViewPropertyAnimator animation = view.animate();
        this.mMoveAnimations.add(holder);
        animation.setDuration(this.getMoveDuration()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                RepairedItemAnimator.this.dispatchMoveStarting(holder);
            }

            public void onAnimationCancel(Animator animator) {
                if (deltaX != 0) {
                    view.setTranslationX(0.0f);
                }
                if (deltaY != 0) {
                    view.setTranslationY(0.0f);
                }
            }

            public void onAnimationEnd(Animator animator) {
                block2: {
                    animation.setListener(null);
                    try {
                        RepairedItemAnimator.this.dispatchMoveFinished(holder);
                    }
                    catch (Exception e) {
                        if (RepairedItemAnimator.this.mOnErrorListener == null) break block2;
                        RepairedItemAnimator.this.mOnErrorListener.onError(holder);
                    }
                }
                RepairedItemAnimator.this.mMoveAnimations.remove(holder);
                RepairedItemAnimator.this.dispatchFinishedWhenDone();
            }
        }).start();
    }

    public boolean animateChange(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder, int fromX, int fromY, int toX, int toY) {
        if (oldHolder == newHolder) {
            return this.animateMove(oldHolder, fromX, fromY, toX, toY);
        }
        float prevTranslationX = oldHolder.itemView.getTranslationX();
        float prevTranslationY = oldHolder.itemView.getTranslationY();
        float prevAlpha = oldHolder.itemView.getAlpha();
        this.resetAnimation(oldHolder);
        int deltaX = (int)((float)(toX - fromX) - prevTranslationX);
        int deltaY = (int)((float)(toY - fromY) - prevTranslationY);
        oldHolder.itemView.setTranslationX(prevTranslationX);
        oldHolder.itemView.setTranslationY(prevTranslationY);
        oldHolder.itemView.setAlpha(prevAlpha);
        if (newHolder != null) {
            this.resetAnimation(newHolder);
            newHolder.itemView.setTranslationX((float)(-deltaX));
            newHolder.itemView.setTranslationY((float)(-deltaY));
            newHolder.itemView.setAlpha(0.0f);
        }
        this.mPendingChanges.add(new ChangeInfo(oldHolder, newHolder, fromX, fromY, toX, toY));
        return true;
    }

    private void animateChangeImpl(final ChangeInfo changeInfo) {
        View newView;
        RecyclerView.ViewHolder holder = changeInfo.oldHolder;
        final View view = holder == null ? null : holder.itemView;
        RecyclerView.ViewHolder newHolder = changeInfo.newHolder;
        View view2 = newView = newHolder != null ? newHolder.itemView : null;
        if (view != null) {
            final ViewPropertyAnimator oldViewAnim = view.animate().setDuration(this.getChangeDuration());
            this.mChangeAnimations.add(changeInfo.oldHolder);
            oldViewAnim.translationX((float)(changeInfo.toX - changeInfo.fromX));
            oldViewAnim.translationY((float)(changeInfo.toY - changeInfo.fromY));
            oldViewAnim.alpha(0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animator) {
                    RepairedItemAnimator.this.dispatchChangeStarting(changeInfo.oldHolder, true);
                }

                public void onAnimationEnd(Animator animator) {
                    block2: {
                        oldViewAnim.setListener(null);
                        view.setAlpha(1.0f);
                        view.setTranslationX(0.0f);
                        view.setTranslationY(0.0f);
                        try {
                            RepairedItemAnimator.this.dispatchChangeFinished(changeInfo.oldHolder, true);
                        }
                        catch (Exception e) {
                            if (RepairedItemAnimator.this.mOnErrorListener == null) break block2;
                            RepairedItemAnimator.this.mOnErrorListener.onError(changeInfo.oldHolder);
                        }
                    }
                    RepairedItemAnimator.this.mChangeAnimations.remove(changeInfo.oldHolder);
                    RepairedItemAnimator.this.dispatchFinishedWhenDone();
                }
            }).start();
        }
        if (newView != null) {
            final ViewPropertyAnimator newViewAnimation = newView.animate();
            this.mChangeAnimations.add(changeInfo.newHolder);
            newViewAnimation.translationX(0.0f).translationY(0.0f).setDuration(this.getChangeDuration()).alpha(1.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animator) {
                    RepairedItemAnimator.this.dispatchChangeStarting(changeInfo.newHolder, false);
                }

                public void onAnimationEnd(Animator animator) {
                    block2: {
                        newViewAnimation.setListener(null);
                        newView.setAlpha(1.0f);
                        newView.setTranslationX(0.0f);
                        newView.setTranslationY(0.0f);
                        try {
                            RepairedItemAnimator.this.dispatchChangeFinished(changeInfo.newHolder, false);
                        }
                        catch (Exception e) {
                            if (RepairedItemAnimator.this.mOnErrorListener == null) break block2;
                            RepairedItemAnimator.this.mOnErrorListener.onError(changeInfo.newHolder);
                        }
                    }
                    RepairedItemAnimator.this.mChangeAnimations.remove(changeInfo.newHolder);
                    RepairedItemAnimator.this.dispatchFinishedWhenDone();
                }
            }).start();
        }
    }

    private void endChangeAnimation(List<ChangeInfo> infoList, RecyclerView.ViewHolder item) {
        for (int i = infoList.size() - 1; i >= 0; --i) {
            ChangeInfo changeInfo = infoList.get(i);
            if (!this.endChangeAnimationIfNecessary(changeInfo, item) || changeInfo.oldHolder != null || changeInfo.newHolder != null) continue;
            infoList.remove(changeInfo);
        }
    }

    private void endChangeAnimationIfNecessary(ChangeInfo changeInfo) {
        if (changeInfo.oldHolder != null) {
            this.endChangeAnimationIfNecessary(changeInfo, changeInfo.oldHolder);
        }
        if (changeInfo.newHolder != null) {
            this.endChangeAnimationIfNecessary(changeInfo, changeInfo.newHolder);
        }
    }

    private boolean endChangeAnimationIfNecessary(ChangeInfo changeInfo, RecyclerView.ViewHolder item) {
        block6: {
            boolean oldItem = false;
            if (changeInfo.newHolder == item) {
                changeInfo.newHolder = null;
            } else if (changeInfo.oldHolder == item) {
                changeInfo.oldHolder = null;
                oldItem = true;
            } else {
                return false;
            }
            item.itemView.setAlpha(1.0f);
            item.itemView.setTranslationX(0.0f);
            item.itemView.setTranslationY(0.0f);
            try {
                this.dispatchChangeFinished(item, oldItem);
            }
            catch (Exception e) {
                if (this.mOnErrorListener == null) break block6;
                this.mOnErrorListener.onError(item);
            }
        }
        return true;
    }

    public void endAnimation(RecyclerView.ViewHolder item) {
        int i;
        View view;
        block23: {
            block22: {
                view = item.itemView;
                view.animate().cancel();
                for (i = this.mPendingMoves.size() - 1; i >= 0; --i) {
                    block21: {
                        MoveInfo moveInfo = this.mPendingMoves.get(i);
                        if (moveInfo.holder != item) continue;
                        view.setTranslationY(0.0f);
                        view.setTranslationX(0.0f);
                        try {
                            this.dispatchMoveFinished(item);
                        }
                        catch (Exception e) {
                            if (this.mOnErrorListener == null) break block21;
                            this.mOnErrorListener.onError(item);
                        }
                    }
                    this.mPendingMoves.remove(i);
                }
                this.endChangeAnimation(this.mPendingChanges, item);
                if (this.mPendingRemovals.remove(item)) {
                    view.setAlpha(1.0f);
                    try {
                        this.dispatchRemoveFinished(item);
                    }
                    catch (Exception e) {
                        if (this.mOnErrorListener == null) break block22;
                        this.mOnErrorListener.onError(item);
                    }
                }
            }
            if (this.mPendingAdditions.remove(item)) {
                view.setAlpha(1.0f);
                try {
                    this.dispatchAddFinished(item);
                }
                catch (Exception e) {
                    if (this.mOnErrorListener == null) break block23;
                    this.mOnErrorListener.onError(item);
                }
            }
        }
        for (i = this.mChangesList.size() - 1; i >= 0; --i) {
            ArrayList<ChangeInfo> changes = this.mChangesList.get(i);
            this.endChangeAnimation(changes, item);
            if (!changes.isEmpty()) continue;
            this.mChangesList.remove(i);
        }
        block12: for (i = this.mMovesList.size() - 1; i >= 0; --i) {
            ArrayList<MoveInfo> moves = this.mMovesList.get(i);
            for (int j = moves.size() - 1; j >= 0; --j) {
                block24: {
                    MoveInfo moveInfo = moves.get(j);
                    if (moveInfo.holder != item) continue;
                    view.setTranslationY(0.0f);
                    view.setTranslationX(0.0f);
                    try {
                        this.dispatchMoveFinished(item);
                    }
                    catch (Exception e) {
                        if (this.mOnErrorListener == null) break block24;
                        this.mOnErrorListener.onError(item);
                    }
                }
                moves.remove(j);
                if (!moves.isEmpty()) continue block12;
                this.mMovesList.remove(i);
                continue block12;
            }
        }
        for (i = this.mAdditionsList.size() - 1; i >= 0; --i) {
            ArrayList<RecyclerView.ViewHolder> additions;
            block25: {
                additions = this.mAdditionsList.get(i);
                if (!additions.remove(item)) continue;
                view.setAlpha(1.0f);
                try {
                    this.dispatchAddFinished(item);
                }
                catch (Exception e) {
                    if (this.mOnErrorListener == null) break block25;
                    this.mOnErrorListener.onError(item);
                }
            }
            if (!additions.isEmpty()) continue;
            this.mAdditionsList.remove(i);
        }
        if (this.mRemoveAnimations.remove(item)) {
            // empty if block
        }
        if (this.mAddAnimations.remove(item)) {
            // empty if block
        }
        if (this.mChangeAnimations.remove(item)) {
            // empty if block
        }
        if (this.mMoveAnimations.remove(item)) {
            // empty if block
        }
        this.dispatchFinishedWhenDone();
    }

    private void resetAnimation(RecyclerView.ViewHolder holder) {
        if (sDefaultInterpolator == null) {
            sDefaultInterpolator = new ValueAnimator().getInterpolator();
        }
        holder.itemView.animate().setInterpolator(sDefaultInterpolator);
        this.endAnimation(holder);
    }

    public boolean isRunning() {
        return !this.mPendingAdditions.isEmpty() || !this.mPendingChanges.isEmpty() || !this.mPendingMoves.isEmpty() || !this.mPendingRemovals.isEmpty() || !this.mMoveAnimations.isEmpty() || !this.mRemoveAnimations.isEmpty() || !this.mAddAnimations.isEmpty() || !this.mChangeAnimations.isEmpty() || !this.mMovesList.isEmpty() || !this.mAdditionsList.isEmpty() || !this.mChangesList.isEmpty();
    }

    private void dispatchFinishedWhenDone() {
        if (!this.isRunning()) {
            this.dispatchAnimationsFinished();
        }
    }

    public void endAnimations() {
        int i;
        MoveInfo item;
        int i2;
        int count = this.mPendingMoves.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            block21: {
                item = this.mPendingMoves.get(i2);
                View view = item.holder.itemView;
                view.setTranslationY(0.0f);
                view.setTranslationX(0.0f);
                try {
                    this.dispatchMoveFinished(item.holder);
                }
                catch (Exception e) {
                    if (this.mOnErrorListener == null) break block21;
                    this.mOnErrorListener.onError(item.holder);
                }
            }
            this.mPendingMoves.remove(i2);
        }
        count = this.mPendingRemovals.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            block22: {
                item = this.mPendingRemovals.get(i2);
                try {
                    this.dispatchRemoveFinished((RecyclerView.ViewHolder)item);
                }
                catch (Exception e) {
                    if (this.mOnErrorListener == null) break block22;
                    this.mOnErrorListener.onError((RecyclerView.ViewHolder)item);
                }
            }
            this.mPendingRemovals.remove(i2);
        }
        count = this.mPendingAdditions.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            block23: {
                item = this.mPendingAdditions.get(i2);
                ((RecyclerView.ViewHolder)item).itemView.setAlpha(1.0f);
                try {
                    this.dispatchAddFinished((RecyclerView.ViewHolder)item);
                }
                catch (Exception e) {
                    if (this.mOnErrorListener == null) break block23;
                    this.mOnErrorListener.onError((RecyclerView.ViewHolder)item);
                }
            }
            this.mPendingAdditions.remove(i2);
        }
        count = this.mPendingChanges.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            this.endChangeAnimationIfNecessary(this.mPendingChanges.get(i2));
        }
        this.mPendingChanges.clear();
        if (!this.isRunning()) {
            return;
        }
        int listCount = this.mMovesList.size();
        for (i = listCount - 1; i >= 0; --i) {
            ArrayList<MoveInfo> moves = this.mMovesList.get(i);
            count = moves.size();
            for (int j = count - 1; j >= 0; --j) {
                block24: {
                    MoveInfo moveInfo = moves.get(j);
                    RecyclerView.ViewHolder item2 = moveInfo.holder;
                    View view = item2.itemView;
                    view.setTranslationY(0.0f);
                    view.setTranslationX(0.0f);
                    try {
                        this.dispatchMoveFinished(moveInfo.holder);
                    }
                    catch (Exception e) {
                        if (this.mOnErrorListener == null) break block24;
                        this.mOnErrorListener.onError(moveInfo.holder);
                    }
                }
                moves.remove(j);
                if (!moves.isEmpty()) continue;
                this.mMovesList.remove(moves);
            }
        }
        listCount = this.mAdditionsList.size();
        for (i = listCount - 1; i >= 0; --i) {
            ArrayList<RecyclerView.ViewHolder> additions = this.mAdditionsList.get(i);
            count = additions.size();
            for (int j = count - 1; j >= 0; --j) {
                block25: {
                    RecyclerView.ViewHolder item3 = additions.get(j);
                    View view = item3.itemView;
                    view.setAlpha(1.0f);
                    try {
                        this.dispatchAddFinished(item3);
                    }
                    catch (Exception e) {
                        if (this.mOnErrorListener == null) break block25;
                        this.mOnErrorListener.onError(item3);
                    }
                }
                additions.remove(j);
                if (!additions.isEmpty()) continue;
                this.mAdditionsList.remove(additions);
            }
        }
        listCount = this.mChangesList.size();
        for (i = listCount - 1; i >= 0; --i) {
            ArrayList<ChangeInfo> changes = this.mChangesList.get(i);
            count = changes.size();
            for (int j = count - 1; j >= 0; --j) {
                this.endChangeAnimationIfNecessary(changes.get(j));
                if (!changes.isEmpty()) continue;
                this.mChangesList.remove(changes);
            }
        }
        this.cancelAll(this.mRemoveAnimations);
        this.cancelAll(this.mMoveAnimations);
        this.cancelAll(this.mAddAnimations);
        this.cancelAll(this.mChangeAnimations);
        this.dispatchAnimationsFinished();
    }

    private void cancelAll(List<RecyclerView.ViewHolder> viewHolders) {
        for (int i = viewHolders.size() - 1; i >= 0; --i) {
            viewHolders.get((int)i).itemView.animate().cancel();
        }
    }

    public boolean canReuseUpdatedViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, @NonNull List<Object> payloads) {
        return !payloads.isEmpty() || super.canReuseUpdatedViewHolder(viewHolder, payloads);
    }

    public void setOnErrorListener(OnErrorListener listener) {
        this.mOnErrorListener = listener;
    }

    public static interface OnErrorListener {
        public void onError(RecyclerView.ViewHolder var1);
    }

    private static class ChangeInfo {
        public RecyclerView.ViewHolder oldHolder;
        public RecyclerView.ViewHolder newHolder;
        int fromX;
        int fromY;
        int toX;
        int toY;

        private ChangeInfo(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder) {
            this.oldHolder = oldHolder;
            this.newHolder = newHolder;
        }

        ChangeInfo(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder, int fromX, int fromY, int toX, int toY) {
            this(oldHolder, newHolder);
            this.fromX = fromX;
            this.fromY = fromY;
            this.toX = toX;
            this.toY = toY;
        }

        public String toString() {
            return "ChangeInfo{oldHolder=" + this.oldHolder + ", newHolder=" + this.newHolder + ", fromX=" + this.fromX + ", fromY=" + this.fromY + ", toX=" + this.toX + ", toY=" + this.toY + '}';
        }
    }

    private static class MoveInfo {
        RecyclerView.ViewHolder holder;
        int fromX;
        int fromY;
        int toX;
        int toY;

        MoveInfo(RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
            this.holder = holder;
            this.fromX = fromX;
            this.fromY = fromY;
            this.toX = toX;
            this.toY = toY;
        }
    }
}

