/*
 * Decompiled with CFR 0.152.
 */
package com.wuyr.pathlayoutmanager;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.graphics.Path;
import android.graphics.PointF;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.wuyr.pathlayoutmanager.RepairedItemAnimator;
import com.wuyr.pathlayoutmanager.keyframes.Keyframes;
import com.wuyr.pathlayoutmanager.keyframes.PosTan;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class PathLayoutManager
extends RecyclerView.LayoutManager
implements RecyclerView.SmoothScroller.ScrollVectorProvider {
    public static final int SCROLL_MODE_NORMAL = 0;
    public static final int SCROLL_MODE_OVERFLOW = 1;
    public static final int SCROLL_MODE_LOOP = 2;
    private Keyframes mKeyframes;
    private int mScrollMode;
    private int mOrientation;
    private int mItemOffset;
    private int mItemCountInScreen;
    private int mFirstVisibleItemPos;
    private float mOffsetX;
    private float mOffsetY;
    private boolean isItemDirectionFixed;
    private boolean isAutoSelect;
    private float mAutoSelectFraction = 0.5f;
    private float[] mScaleRatio;
    private long mFixingAnimationDuration = 250L;
    private boolean isAnimatorInitialized;
    private int mCacheCount = 2;
    private boolean isFlingEnable;
    private boolean isFlinging;
    private RepairedItemAnimator mItemAnimator;
    private RecyclerView.Recycler mRecycler;
    private RecyclerView.State mState;
    private ValueAnimator mAnimator;
    private OnItemSelectedListener mItemSelectedListener;
    private volatile boolean isPosting;

    public PathLayoutManager(Path path, int itemOffset) {
        this(path, itemOffset, 1);
    }

    public PathLayoutManager(Path path, int itemOffset, int orientation) {
        this.mOrientation = orientation;
        this.mItemOffset = itemOffset;
        this.isFlingEnable = true;
        this.updatePath(path);
        this.mItemAnimator = new RepairedItemAnimator();
        this.mItemAnimator.setOnErrorListener(new RepairedItemAnimator.OnErrorListener(){

            @Override
            public void onError(RecyclerView.ViewHolder holder) {
                if (PathLayoutManager.this.mRecycler != null && PathLayoutManager.this.mState != null) {
                    PathLayoutManager.this.removeAndRecycleAllViews(PathLayoutManager.this.mRecycler);
                    for (int i = 0; i < PathLayoutManager.this.mState.getItemCount(); ++i) {
                        View view = PathLayoutManager.this.mRecycler.getViewForPosition(i);
                        PathLayoutManager.this.mRecycler.recycleView(view);
                    }
                    PathLayoutManager.this.requestLayout();
                }
            }
        });
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (state.getItemCount() == 0) {
            this.removeAndRecycleAllViews(recycler);
            return;
        }
        this.mRecycler = recycler;
        this.mState = state;
        if (!this.isAnimatorInitialized) {
            this.initItemAnimator();
            this.isAnimatorInitialized = true;
        }
        this.detachAndScrapAttachedViews(recycler);
        this.relayoutChildren(recycler, state);
    }

    public void onMeasure(RecyclerView.Recycler recycler, RecyclerView.State state, int widthSpec, int heightSpec) {
        if (this.mKeyframes != null) {
            int widthMode = View.MeasureSpec.getMode((int)widthSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightSpec);
            if (widthMode == Integer.MIN_VALUE) {
                widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.mKeyframes.getMaxX(), (int)0x40000000);
            }
            if (heightMode == Integer.MIN_VALUE) {
                heightSpec = View.MeasureSpec.makeMeasureSpec((int)this.mKeyframes.getMaxY(), (int)0x40000000);
            }
        }
        super.onMeasure(recycler, state, widthSpec, heightSpec);
    }

    public boolean isAutoMeasureEnabled() {
        return false;
    }

    private void initItemAnimator() {
        try {
            Field field = RecyclerView.LayoutManager.class.getDeclaredField("mRecyclerView");
            field.setAccessible(true);
            RecyclerView recyclerView = (RecyclerView)field.get((Object)this);
            if (recyclerView != null) {
                recyclerView.setOverScrollMode(2);
                recyclerView.setHorizontalScrollBarEnabled(false);
                recyclerView.setVerticalScrollBarEnabled(false);
                if (recyclerView.getItemAnimator() != this.mItemAnimator) {
                    recyclerView.setItemAnimator((RecyclerView.ItemAnimator)this.mItemAnimator);
                }
            }
            this.mRecycler.setViewCacheSize(this.mCacheCount);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void relayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        List<PosTan> needLayoutItems = this.getNeedLayoutItems();
        if (needLayoutItems.isEmpty() || state.getItemCount() == 0 || this.mKeyframes == null) {
            this.removeAndRecycleAllViews(recycler);
            return;
        }
        this.onLayout(recycler, needLayoutItems);
        this.recycleChildren(recycler);
    }

    private void onLayout(RecyclerView.Recycler recycler, List<PosTan> needLayoutItems) {
        for (PosTan tmp : needLayoutItems) {
            View item = recycler.getViewForPosition(tmp.index);
            this.addView(item);
            this.measureChild(item, 0, 0);
            int x = (int)tmp.x - this.getDecoratedMeasuredWidth(item) / 2;
            int y = (int)tmp.y - this.getDecoratedMeasuredHeight(item) / 2;
            this.layoutDecorated(item, x, y, x + this.getDecoratedMeasuredWidth(item), y + this.getDecoratedMeasuredHeight(item));
            item.setRotation(this.isItemDirectionFixed ? 0.0f : tmp.getChildAngle());
            if (this.mScaleRatio == null) continue;
            float scale = this.getScale(tmp.fraction);
            item.setScaleX(scale);
            item.setScaleY(scale);
        }
    }

    private float getScale(float fraction) {
        float distance;
        float scale;
        float result;
        float scalePosition;
        int i;
        boolean isHasMin = false;
        boolean isHasMax = false;
        float minScale = 0.0f;
        float maxScale = 0.0f;
        float minFraction = 1.0f;
        float maxFraction = 1.0f;
        for (i = 1; i < this.mScaleRatio.length && (scalePosition = this.mScaleRatio[i]) <= fraction; i += 2) {
            minScale = this.mScaleRatio[i - 1];
            minFraction = this.mScaleRatio[i];
            isHasMin = true;
        }
        for (i = this.mScaleRatio.length - 1; i >= 1 && (scalePosition = this.mScaleRatio[i]) >= fraction; i -= 2) {
            maxScale = this.mScaleRatio[i - 1];
            maxFraction = this.mScaleRatio[i];
            isHasMax = true;
        }
        if (!isHasMin) {
            minScale = 1.0f;
        }
        if (!isHasMax) {
            maxScale = 1.0f;
        }
        return this.isFinite(result = minScale + (scale = (distance = maxScale - minScale) * (fraction = this.solveTwoPointForm(minFraction, maxFraction, fraction)))) ? result : minScale;
    }

    private float solveTwoPointForm(float startX, float endX, float currentX) {
        return (currentX - startX) / (endX - startX);
    }

    private boolean isFinite(float value) {
        return !Float.isNaN(value) && !Float.isInfinite(value);
    }

    private List<PosTan> getNeedLayoutItems() {
        this.checkKeyframes();
        ArrayList<PosTan> result = new ArrayList<PosTan>();
        int itemCount = this.getItemCount();
        if (this.isSatisfiedLoopScroll()) {
            this.initNeedLayoutLoopScrollItems(result, itemCount);
        } else {
            this.initNeedLayoutItems(result, itemCount);
        }
        return result;
    }

    private void initNeedLayoutLoopScrollItems(List<PosTan> result, int itemCount) {
        int overflowCount = this.getOverflowCount();
        for (int i = this.mFirstVisibleItemPos = overflowCount - this.mItemCountInScreen - 1; i < overflowCount; ++i) {
            float currentDistance;
            float fraction;
            PosTan posTan;
            int pos = i % itemCount;
            if (pos < 0) {
                pos = pos == -itemCount ? 0 : (pos += itemCount);
            }
            if ((posTan = this.mKeyframes.getValue(fraction = (currentDistance = (float)((i + itemCount) * this.mItemOffset) - this.getScrollOffset()) / (float)this.mKeyframes.getPathLength())) == null) continue;
            result.add(new PosTan(posTan, pos, fraction));
        }
    }

    private void initNeedLayoutItems(List<PosTan> result, int itemCount) {
        int totalItemCount;
        float currentDistance;
        for (int i = 0; i < itemCount; ++i) {
            currentDistance = (float)(i * this.mItemOffset) - this.getScrollOffset();
            if (!(currentDistance >= 0.0f)) continue;
            this.mFirstVisibleItemPos = i;
            break;
        }
        int endIndex = this.mFirstVisibleItemPos + this.mItemCountInScreen;
        int n = totalItemCount = this.mState == null ? this.getItemCount() : this.mState.getItemCount();
        if (endIndex > totalItemCount) {
            endIndex = totalItemCount;
        }
        for (int i = this.mFirstVisibleItemPos; i < endIndex; ++i) {
            currentDistance = (float)(i * this.mItemOffset) - this.getScrollOffset();
            float fraction = currentDistance / (float)this.mKeyframes.getPathLength();
            PosTan posTan = this.mKeyframes.getValue(fraction);
            if (posTan == null) continue;
            result.add(new PosTan(posTan, i, fraction));
        }
    }

    private int getOverflowCount() {
        int itemLength = this.getItemLength();
        int pathLength = this.mKeyframes.getPathLength();
        int firstItemScrollOffset = (int)(this.getScrollOffset() + (float)pathLength);
        int lastItemScrollOffset = firstItemScrollOffset - itemLength;
        int lengthOffset = itemLength + pathLength;
        int lastItemOverflowOffset = firstItemScrollOffset > lengthOffset ? firstItemScrollOffset - lengthOffset : 0;
        int vacantDistance = lastItemScrollOffset % itemLength + lastItemOverflowOffset;
        return vacantDistance / this.mItemOffset;
    }

    private void recycleChildren(RecyclerView.Recycler recycler) {
        List scrapList = recycler.getScrapList();
        for (int i = 0; i < scrapList.size(); ++i) {
            RecyclerView.ViewHolder holder = (RecyclerView.ViewHolder)scrapList.get(i);
            this.removeView(holder.itemView);
            recycler.recycleView(holder.itemView);
        }
    }

    private int fixOverflowIndex(int index, int count) {
        while (index < 0) {
            index += count;
        }
        return index % count;
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.mRecycler = recycler;
        this.mState = state;
        this.checkKeyframes();
        this.detachAndScrapAttachedViews(recycler);
        float lastOffset = this.mOffsetX;
        this.updateOffsetX(dx);
        this.relayoutChildren(recycler, state);
        return lastOffset == this.mOffsetX ? 0 : dx;
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.mRecycler = recycler;
        this.mState = state;
        this.checkKeyframes();
        this.detachAndScrapAttachedViews(recycler);
        float lastOffset = this.mOffsetY;
        this.updateOffsetY(dy);
        this.relayoutChildren(recycler, state);
        return lastOffset == this.mOffsetY ? 0 : dy;
    }

    private void updateOffsetY(float offsetY) {
        int itemLength;
        if (this.isFlinging && !this.isFlingEnable) {
            return;
        }
        this.mOffsetY += offsetY;
        int pathLength = this.mKeyframes.getPathLength();
        if (this.isSatisfiedLoopScroll(pathLength, itemLength = this.getItemLength())) {
            if (this.mOffsetY > (float)itemLength) {
                this.mOffsetY %= (float)itemLength;
                this.mOffsetY -= (float)this.mItemOffset;
            } else if (this.mOffsetY <= (float)(-pathLength)) {
                this.mOffsetY += (float)itemLength;
                this.mOffsetY += (float)this.mItemOffset;
            }
        } else if (this.isOverflowMode()) {
            if (this.mOffsetY < (float)(-pathLength)) {
                this.mOffsetY = -pathLength;
            } else if (this.mOffsetY > (float)itemLength) {
                this.mOffsetY = itemLength;
            }
        } else {
            int overflowLength = itemLength - pathLength;
            if (this.mOffsetY < 0.0f) {
                this.mOffsetY = 0.0f;
            } else if (this.mOffsetY > (float)overflowLength) {
                this.mOffsetY = itemLength > pathLength ? (float)overflowLength : (this.mOffsetY -= offsetY);
            }
        }
    }

    private void updateOffsetX(float offsetX) {
        int itemLength;
        if (this.isFlinging && !this.isFlingEnable) {
            return;
        }
        this.mOffsetX += offsetX;
        int pathLength = this.mKeyframes.getPathLength();
        if (this.isSatisfiedLoopScroll(pathLength, itemLength = this.getItemLength())) {
            if (this.mOffsetX > (float)itemLength) {
                this.mOffsetX %= (float)itemLength;
                this.mOffsetX -= (float)this.mItemOffset;
            } else if (this.mOffsetX <= (float)(-pathLength)) {
                this.mOffsetX += (float)itemLength;
                this.mOffsetX += (float)this.mItemOffset;
            }
        } else if (this.isOverflowMode()) {
            if (this.mOffsetX < (float)(-pathLength)) {
                this.mOffsetX = -pathLength;
            } else if (this.mOffsetX > (float)itemLength) {
                this.mOffsetX = itemLength;
            }
        } else {
            int overflowLength = itemLength - pathLength;
            if (this.mOffsetX < 0.0f) {
                this.mOffsetX = 0.0f;
            } else if (this.mOffsetX > (float)overflowLength) {
                this.mOffsetX = itemLength > pathLength ? (float)overflowLength : (this.mOffsetX -= offsetX);
            }
        }
    }

    private boolean isSatisfiedLoopScroll() {
        this.checkKeyframes();
        int pathLength = this.mKeyframes.getPathLength();
        int itemLength = this.getItemLength();
        return this.isLoopScrollMode() && itemLength - pathLength > this.mItemOffset;
    }

    private boolean isSatisfiedLoopScroll(int pathLength, int itemLength) {
        return this.isLoopScrollMode() && itemLength - pathLength > this.mItemOffset;
    }

    private boolean isLoopScrollMode() {
        return this.mScrollMode == 2;
    }

    private boolean isOverflowMode() {
        return this.mScrollMode == 1;
    }

    private int getItemLength() {
        return this.getItemCount() * this.mItemOffset - this.mItemOffset + 1;
    }

    private float getScrollOffset() {
        return this.mOrientation == 1 ? this.mOffsetY : this.mOffsetX;
    }

    public boolean canScrollVertically() {
        return this.mOrientation == 1;
    }

    public boolean canScrollHorizontally() {
        return this.mOrientation == 0;
    }

    public void updatePath(Path path) {
        if (path != null) {
            this.mKeyframes = new Keyframes(path);
            if (this.mItemOffset == 0) {
                throw new IllegalStateException("itemOffset must be > 0 !!!");
            }
            this.mItemCountInScreen = this.mKeyframes.getPathLength() / this.mItemOffset + 1;
        }
        this.requestLayout();
    }

    public void setItemOffset(int itemOffset) {
        if (this.mItemOffset != itemOffset && itemOffset > 0) {
            this.mItemOffset = itemOffset;
            if (this.mKeyframes != null) {
                this.mItemCountInScreen = this.mKeyframes.getPathLength() / this.mItemOffset + 1;
                this.requestLayout();
            }
        }
    }

    public void setItemDirectionFixed(boolean isFixed) {
        if (this.isItemDirectionFixed != isFixed) {
            this.isItemDirectionFixed = isFixed;
            this.requestLayout();
        }
    }

    public void setScrollMode(int mode) {
        if (mode != this.mScrollMode) {
            this.mScrollMode = mode;
            this.requestLayout();
        }
    }

    public void setOrientation(int orientation) {
        if (this.mOrientation != orientation) {
            this.mOrientation = orientation;
            if (orientation == 0) {
                this.mOffsetX = this.mOffsetY;
                this.mOffsetY = 0.0f;
            } else {
                this.mOffsetY = this.mOffsetX;
                this.mOffsetX = 0.0f;
            }
        }
    }

    public void setCacheCount(int count) {
        if (this.mRecycler != null) {
            this.mRecycler.setViewCacheSize(count);
        }
        this.mCacheCount = count;
    }

    public void onScrollStateChanged(int state) {
        this.isFlinging = state == 2;
        switch (state) {
            case 1: {
                this.stopFixingAnimation();
                break;
            }
            case 0: {
                if (!this.isAutoSelect) break;
                this.smoothScrollToPosition(this.findClosestPosition());
                break;
            }
        }
    }

    private void stopFixingAnimation() {
        if (this.mAnimator != null && this.mAnimator.isRunning()) {
            this.mAnimator.cancel();
        }
    }

    public void scrollToPosition(int position) {
        int itemCount = this.getItemCount();
        if (position > -1 && position < itemCount) {
            this.checkKeyframes();
            int distance = this.getDistance(position);
            if (this.canScrollVertically()) {
                this.updateOffsetY(distance);
            } else {
                this.updateOffsetX(distance);
            }
            this.requestLayout();
        }
    }

    private int getDistance(int position) {
        float distance;
        PosTan posTan = this.getVisiblePosTanByPosition(position);
        if (posTan == null) {
            int itemCount = this.getItemCount();
            int closestPosition = this.findClosestPosition();
            int count = 0;
            while (this.fixOverflowIndex(closestPosition + ++count, itemCount) != position) {
            }
            if (this.isSatisfiedLoopScroll() && count < Math.abs(closestPosition - position)) {
                position = closestPosition + count;
            }
            distance = (float)(position * this.mItemOffset) - this.getScrollOffset();
        } else {
            distance = (float)this.mKeyframes.getPathLength() * posTan.fraction;
        }
        return (int)(distance -= (float)this.mKeyframes.getPathLength() * this.mAutoSelectFraction);
    }

    @Nullable
    private PosTan getVisiblePosTanByPosition(int position) {
        List<PosTan> needLayoutList = this.getNeedLayoutItems();
        PosTan posTan = null;
        for (int i = 0; i < needLayoutList.size(); ++i) {
            PosTan tmp = needLayoutList.get(i);
            if (tmp.index != position) continue;
            posTan = tmp;
            break;
        }
        return posTan;
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        this.smoothScrollToPosition(position);
    }

    public void smoothScrollToPosition(int position) {
        if (position > -1 && position < this.getItemCount() && this.mState != null) {
            this.checkKeyframes();
            this.startValueAnimator(position);
        }
    }

    private void startValueAnimator(final int position) {
        this.stopFixingAnimation();
        int distance = this.getDistance(position);
        this.mAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, distance}).setDuration(this.mFixingAnimationDuration);
        this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            private float mLastScrollOffset;

            public void onAnimationUpdate(ValueAnimator animation) {
                float currentValue = ((Float)animation.getAnimatedValue()).floatValue();
                float offset = currentValue - this.mLastScrollOffset;
                if (PathLayoutManager.this.canScrollVertically()) {
                    PathLayoutManager.this.updateOffsetY(offset);
                } else {
                    PathLayoutManager.this.updateOffsetX(offset);
                }
                PathLayoutManager.this.requestLayout();
                this.mLastScrollOffset = currentValue;
            }
        });
        this.mAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
            boolean isCanceled;

            public void onAnimationCancel(Animator animation) {
                this.isCanceled = true;
            }

            public void onAnimationEnd(Animator animation) {
                if (!this.isCanceled && PathLayoutManager.this.isAutoSelect && PathLayoutManager.this.mItemSelectedListener != null) {
                    PathLayoutManager.this.mItemSelectedListener.onSelected(position);
                }
            }
        });
        this.mAnimator.start();
    }

    private int findClosestPosition() {
        int hitPos = -1;
        List<PosTan> posTanList = this.getNeedLayoutItems();
        if (posTanList.size() > 1) {
            hitPos = posTanList.get((int)0).index;
            float hitFraction = Math.abs(posTanList.get((int)0).fraction - this.mAutoSelectFraction);
            for (PosTan tmp : posTanList) {
                float tempFraction = Math.abs(tmp.fraction - this.mAutoSelectFraction);
                if (!(tempFraction < hitFraction)) continue;
                hitPos = tmp.index;
                hitFraction = tempFraction;
            }
        }
        if (hitPos < 0 && !posTanList.isEmpty()) {
            hitPos = posTanList.get((int)0).index;
        }
        return hitPos;
    }

    public void setAutoSelectFraction(@FloatRange(from=0.0, to=1.0) float position) {
        if (this.mAutoSelectFraction != position) {
            this.mAutoSelectFraction = position;
            this.requestLayout();
        }
    }

    public void setAutoSelect(boolean isAutoSelect) {
        if (this.isAutoSelect != isAutoSelect) {
            this.isAutoSelect = isAutoSelect;
            if (isAutoSelect && this.mKeyframes != null) {
                this.onScrollStateChanged(0);
            }
        }
    }

    public void setItemScaleRatio(float ... ratios) {
        if (ratios.length == 0) {
            ratios = new float[]{1.0f, 1.0f};
        }
        for (float tmp : ratios) {
            if (!(tmp < 0.0f)) continue;
            throw new IllegalArgumentException("Array value can not be negative!");
        }
        if (this.mScaleRatio != ratios) {
            if (ratios.length < 2 || ratios.length % 2 != 0) {
                throw new IllegalArgumentException("Array length no match!");
            }
            this.mScaleRatio = ratios;
            if (this.mScaleRatio[1] != 0.0f) {
                this.mScaleRatio = this.insertElement(true, this.mScaleRatio, 1.0f, 0.0f);
            }
            if (this.mScaleRatio[this.mScaleRatio.length - 1] != 1.0f) {
                this.mScaleRatio = this.insertElement(false, this.mScaleRatio, 1.0f, 1.0f);
            }
            float min = this.mScaleRatio[1];
            for (int i = 1; i < this.mScaleRatio.length; i += 2) {
                float temp = this.mScaleRatio[i];
                if (min > temp) {
                    throw new IllegalArgumentException("Incorrect array value! position must be from small to large");
                }
                min = temp;
            }
            this.requestLayout();
        }
    }

    private float[] insertElement(boolean isAddFromHead, @NonNull float[] target, float ... elements) {
        float[] result = new float[target.length + elements.length];
        if (isAddFromHead) {
            System.arraycopy(elements, 0, result, 0, elements.length);
            System.arraycopy(target, 0, result, elements.length, target.length);
        } else {
            System.arraycopy(target, 0, result, 0, target.length);
            System.arraycopy(elements, 0, result, target.length, elements.length);
        }
        return result;
    }

    public void setFixingAnimationDuration(long duration) {
        this.mFixingAnimationDuration = duration;
    }

    public void setFlingEnable(boolean enable) {
        this.isFlingEnable = enable;
    }

    public void setOnItemSelectedListener(OnItemSelectedListener listener) {
        this.mItemSelectedListener = listener;
    }

    private void checkKeyframes() {
        if (this.mKeyframes == null) {
            throw new NullPointerException("Path not set!");
        }
    }

    public void onDetachedFromWindow(RecyclerView view, RecyclerView.Recycler recycler) {
        this.removeAndRecycleAllViews(recycler);
        if (this.mKeyframes != null) {
            this.mKeyframes.release();
            this.mKeyframes = null;
        }
        this.mScaleRatio = null;
        this.mItemAnimator = null;
        this.mRecycler = null;
        this.mState = null;
        this.stopFixingAnimation();
        this.mAnimator = null;
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-2, -2);
    }

    public PointF computeScrollVectorForPosition(int targetPosition) {
        return null;
    }

    public void onItemsAdded(RecyclerView recyclerView, int positionStart, int itemCount) {
        this.delayNotifyDataSetChanged(recyclerView);
    }

    public void onItemsRemoved(RecyclerView recyclerView, int positionStart, int itemCount) {
        this.delayNotifyDataSetChanged(recyclerView);
    }

    public void onItemsUpdated(RecyclerView recyclerView, int positionStart, int itemCount) {
        this.delayNotifyDataSetChanged(recyclerView);
    }

    public void onItemsUpdated(RecyclerView recyclerView, int positionStart, int itemCount, Object payload) {
        this.delayNotifyDataSetChanged(recyclerView);
    }

    public void onItemsMoved(RecyclerView recyclerView, int from, int to, int itemCount) {
        this.delayNotifyDataSetChanged(recyclerView);
    }

    private void delayNotifyDataSetChanged(final RecyclerView recyclerView) {
        if (recyclerView.isComputingLayout()) {
            this.isPosting = true;
            recyclerView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    PathLayoutManager.this.delayNotifyDataSetChanged(recyclerView);
                }
            }, 5L);
        } else if (this.isPosting) {
            this.isPosting = false;
            recyclerView.getAdapter().notifyDataSetChanged();
        }
    }

    public static interface OnItemSelectedListener {
        public void onSelected(int var1);
    }
}

