/*
 * Decompiled with CFR 0.152.
 */
package com.wunderlist.slidinglayer.transformer;

import android.view.View;
import com.wunderlist.slidinglayer.LayerTransformer;
import com.wunderlist.slidinglayer.utils.Transitions;

public final class SlideJoyTransformer
extends LayerTransformer {
    private final float[] mCuePoints = new float[]{0.7f, 0.9f, 1.0f};
    private float[] mRotationXValues;
    private float[] mRotationYValues;

    @Override
    protected void onMeasure(View layerView, int screenSide) {
        float[] rotationXY = this.rotationValueForScreenSide(-4.75f, screenSide);
        this.mRotationXValues = new float[]{0.0f, rotationXY[0], 0.0f};
        this.mRotationYValues = new float[]{0.0f, rotationXY[1], 0.0f};
        int[] pivotPosition = this.pivotPositionForScreenSide(layerView, screenSide);
        layerView.setPivotX((float)pivotPosition[0]);
        layerView.setPivotY((float)pivotPosition[1]);
    }

    @Override
    public void transform(View layerView, float previewProgress, float layerProgress) {
    }

    @Override
    protected void internalTransform(View layerView, float previewProgress, float layerProgress, int screenSide) {
        float progressRatioToAnimate = Math.max(previewProgress, layerProgress);
        float scaleValue = Transitions.intermediateValueForCuePoints(progressRatioToAnimate, new float[]{0.9f, 1.0f});
        layerView.setScaleX(scaleValue);
        layerView.setScaleY(scaleValue);
        float rotationX = Transitions.intermediateValueForRange(progressRatioToAnimate, this.mCuePoints, this.mRotationXValues);
        layerView.setRotationX(rotationX);
        float rotationY = Transitions.intermediateValueForRange(progressRatioToAnimate, this.mCuePoints, this.mRotationYValues);
        layerView.setRotationY(rotationY);
    }

    private float[] rotationValueForScreenSide(float value, int screenSide) {
        switch (screenSide) {
            case -2: {
                return new float[]{0.0f, value};
            }
            case -3: {
                return new float[]{-value, 0.0f};
            }
            case -1: {
                return new float[]{0.0f, -value};
            }
            case -4: {
                return new float[]{value, 0.0f};
            }
        }
        return new float[]{0.0f, 0.0f};
    }

    private int[] pivotPositionForScreenSide(View layerView, int screenSide) {
        switch (screenSide) {
            case -2: {
                return new int[]{0, layerView.getMeasuredHeight() / 2};
            }
            case -3: {
                return new int[]{layerView.getMeasuredWidth() / 2, 0};
            }
            case -1: {
                return new int[]{layerView.getMeasuredWidth(), layerView.getMeasuredHeight() / 2};
            }
            case -4: {
                return new int[]{layerView.getMeasuredWidth() / 2, layerView.getMeasuredHeight()};
            }
        }
        return new int[]{0, 0};
    }
}

