/*
 * Decompiled with CFR 0.152.
 */
package com.wshunli.assets;

import android.content.Context;
import com.wshunli.assets.CopyListener;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;

public final class CopyCreator {
    private final Context mContext;
    private String oriPath;
    private String desPath;
    private CopyListener copyListener;

    CopyCreator(Context context) {
        this.mContext = context;
    }

    public CopyCreator from(String string) {
        this.oriPath = string;
        return this;
    }

    public CopyCreator to(String string) {
        this.desPath = string;
        return this;
    }

    public CopyCreator setListener(CopyListener copyListener) {
        this.copyListener = copyListener;
        return this;
    }

    public boolean copy() {
        return this.copy(this.mContext, this.oriPath, this.desPath);
    }

    public boolean copy(Context context, String string, String string2) {
        string = string == null ? "" : string;
        string2 = string2 == null ? context.getFilesDir().getAbsolutePath() : string2;
        ArrayList<String> arrayList = this.getAssetsFilePath(context, string, null);
        if (this.copyListener != null) {
            this.copyListener.pending(this, string, string2, arrayList);
        }
        HashMap<File, Boolean> hashMap = new HashMap<File, Boolean>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string3 = arrayList.get(i);
            File file = this.getFileByPath(string2 + "/" + string3);
            if (file == null) {
                return false;
            }
            try {
                InputStream inputStream = context.getAssets().open(string3);
                boolean bl = this.writeFileFromIS(file, inputStream);
                if (!bl) {
                    return false;
                }
                if (this.copyListener != null) {
                    int n2 = 100 * (i + 1) / n;
                    this.copyListener.progress(this, file, n2);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.copyListener != null) {
                    this.copyListener.error(this, fileNotFoundException);
                }
                return false;
            }
            catch (IOException iOException) {
                if (this.copyListener != null) {
                    this.copyListener.error(this, iOException);
                }
                return false;
            }
            hashMap.put(file, true);
        }
        if (this.copyListener != null) {
            this.copyListener.completed(this, hashMap);
        }
        return true;
    }

    private ArrayList<String> getAssetsFilePath(Context context, String string, ArrayList<String> arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        try {
            String[] stringArray;
            for (String string2 : stringArray = context.getAssets().list(string)) {
                String string3;
                int n = context.getAssets().list(string2).length;
                String string4 = string3 = string.equals("") ? string2 : string + "/" + string2;
                if (n == 0) {
                    arrayList.add(string3);
                    continue;
                }
                this.getAssetsFilePath(context, string3, arrayList);
            }
            return arrayList;
        }
        catch (IOException iOException) {
            if (this.copyListener != null) {
                this.copyListener.error(this, iOException);
            }
            return arrayList;
        }
    }

    private File getFileByPath(String string) {
        return string == null || string.trim().length() == 0 ? null : new File(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeFileFromIS(File file, InputStream inputStream) {
        boolean bl;
        if (file == null || inputStream == null) {
            return false;
        }
        if (!this.createOrExistsFile(file)) {
            return false;
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray, 0, 1024)) != -1) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            }
            bl = true;
        }
        catch (IOException iOException) {
            boolean bl2;
            try {
                if (this.copyListener != null) {
                    this.copyListener.error(this, iOException);
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                this.closeIO(inputStream, bufferedOutputStream);
                throw throwable;
            }
            this.closeIO(inputStream, bufferedOutputStream);
            return bl2;
        }
        this.closeIO(inputStream, bufferedOutputStream);
        return bl;
    }

    private boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!this.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException iOException) {
            if (this.copyListener != null) {
                this.copyListener.error(this, iOException);
            }
            return false;
        }
    }

    private boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private void closeIO(Closeable ... closeableArray) {
        if (closeableArray == null) {
            return;
        }
        for (Closeable closeable : closeableArray) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                if (this.copyListener == null) continue;
                this.copyListener.error(this, iOException);
            }
        }
    }
}

