/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.camera;

import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import com.eegeo.mapapi.R;
import com.eegeo.mapapi.geometry.ElevationMode;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.geometry.LatLngAlt;

public final class CameraPosition {
    public final LatLng target;
    public final double targetElevation;
    public final ElevationMode targetElevationMode;
    public final String targetIndoorMapId;
    public final int targetIndoorMapFloorId;
    public final double zoom;
    public final double tilt;
    public final double bearing;

    public CameraPosition(LatLng target, double zoom, double tilt, double bearing) {
        if (target == null) {
            throw new NullPointerException("A non-null target LatLng must be specified");
        }
        this.target = target;
        this.targetElevation = 0.0;
        this.targetElevationMode = ElevationMode.HeightAboveGround;
        this.targetIndoorMapId = "";
        this.targetIndoorMapFloorId = 0;
        this.zoom = zoom;
        this.tilt = tilt;
        this.bearing = bearing;
    }

    private CameraPosition(LatLng target, double targetElevation, ElevationMode targetElevationMode, String targetIndoorMapId, int targetIndoorMapFloorId, double zoom, double tilt, double bearing) {
        if (target == null) {
            throw new NullPointerException("A non-null target LatLng must be specified");
        }
        this.target = target;
        this.targetElevation = targetElevation;
        this.targetElevationMode = targetElevationMode;
        this.targetIndoorMapId = targetIndoorMapId;
        this.targetIndoorMapFloorId = targetIndoorMapFloorId;
        this.zoom = zoom;
        this.tilt = tilt;
        this.bearing = bearing;
    }

    public static final class Builder {
        private static double ms_defaultZoom = 17.0;
        private static double ms_defaultTilt = 45.0;
        private static double[] ms_zoomToDistances = new double[]{2.74287E7, 1.4720762E7, 8000000.0, 4512909.0, 2087317.0, 1248854.0, 660556.0, 351205.0, 185652.0, 83092.0, 41899.0, 21377.0, 11294.0, 5818.0, 3106.0, 1890.0, 1300.0, 821.0, 500.0, 300.0, 108.0, 58.0, 31.0, 17.0, 9.0, 5.0};
        private LatLng m_target = null;
        private double m_targetElevation = 0.0;
        private ElevationMode m_targetElevationMode = ElevationMode.HeightAboveGround;
        private String m_targetIndoorMapId = "";
        private int m_targetIndoorMapFloorId = 0;
        private double m_zoom = ms_defaultZoom;
        private double m_tilt = ms_defaultTilt;
        private double m_bearing = 0.0;

        public Builder() {
        }

        public Builder(CameraPosition previous) {
            this.m_target = previous.target;
            this.m_targetElevation = previous.targetElevation;
            this.m_targetElevationMode = previous.targetElevationMode;
            this.m_targetIndoorMapId = previous.targetIndoorMapId;
            this.m_targetIndoorMapFloorId = previous.targetIndoorMapFloorId;
            this.m_zoom = previous.zoom;
            this.m_tilt = previous.tilt;
            this.m_bearing = previous.bearing;
        }

        public Builder(@NonNull TypedArray typedArray) {
            double lat = typedArray.getFloat(R.styleable.eegeo_MapView_camera_target_latitude, 0.0f);
            double lng = typedArray.getFloat(R.styleable.eegeo_MapView_camera_target_longitude, 0.0f);
            this.target(lat, lng);
            if (typedArray.hasValue(R.styleable.eegeo_MapView_camera_target_altitude)) {
                double altitude = typedArray.getFloat(R.styleable.eegeo_MapView_camera_target_altitude, 0.0f);
                this.elevationMode(ElevationMode.HeightAboveSeaLevel);
                this.elevation(altitude);
            }
            if (typedArray.hasValue(R.styleable.eegeo_MapView_camera_distance)) {
                double distance = typedArray.getFloat(R.styleable.eegeo_MapView_camera_distance, 0.0f);
                this.distance(distance);
            } else if (typedArray.hasValue(R.styleable.eegeo_MapView_camera_zoom)) {
                double zoom = typedArray.getFloat(R.styleable.eegeo_MapView_camera_zoom, 0.0f);
                this.zoom(zoom);
            }
            if (typedArray.hasValue(R.styleable.eegeo_MapView_camera_tilt)) {
                double tilt = typedArray.getFloat(R.styleable.eegeo_MapView_camera_tilt, 0.0f);
                this.tilt(tilt);
            }
            if (typedArray.hasValue(R.styleable.eegeo_MapView_camera_bearing)) {
                double bearing = typedArray.getFloat(R.styleable.eegeo_MapView_camera_bearing, 0.0f);
                this.bearing(bearing);
            }
            if (typedArray.hasValue(R.styleable.eegeo_MapView_camera_indoor_map_id) && typedArray.hasValue(R.styleable.eegeo_MapView_camera_indoor_map_floor_id)) {
                String indoorMapId = typedArray.getString(R.styleable.eegeo_MapView_camera_indoor_map_id);
                int indoorMapFloorId = typedArray.getInt(R.styleable.eegeo_MapView_camera_indoor_map_floor_id, 0);
                this.indoor(indoorMapId, indoorMapFloorId);
            }
        }

        private static double DistanceToZoom(double distance) {
            int i1 = Builder.FirstZoomLevelLessThanDistance(distance);
            if (i1 < 0) {
                return ms_zoomToDistances.length - 1;
            }
            if (i1 == 0) {
                return i1;
            }
            int i0 = i1 - 1;
            double a = ms_zoomToDistances[i0];
            double b = ms_zoomToDistances[i1];
            double t = (a - distance) / (a - b);
            return (double)i0 + t;
        }

        private static int FirstZoomLevelLessThanDistance(double distance) {
            for (int i = 0; i < ms_zoomToDistances.length; ++i) {
                if (!(ms_zoomToDistances[i] < distance)) continue;
                return i;
            }
            return -1;
        }

        public Builder target(double latitude, double longitude) {
            this.m_target = new LatLng(latitude, longitude);
            return this;
        }

        public Builder target(double latitude, double longitude, double altitude) {
            this.m_target = new LatLng(latitude, longitude);
            this.m_targetElevation = altitude;
            this.m_targetElevationMode = ElevationMode.HeightAboveSeaLevel;
            return this;
        }

        public Builder target(@NonNull LatLng latLon) {
            this.m_target = new LatLng(latLon.latitude, latLon.longitude);
            return this;
        }

        public Builder target(@NonNull LatLngAlt latLonAlt) {
            this.m_target = latLonAlt.toLatLng();
            this.m_targetElevation = latLonAlt.altitude;
            this.m_targetElevationMode = ElevationMode.HeightAboveSeaLevel;
            return this;
        }

        public Builder elevation(@NonNull double elevation) {
            this.m_targetElevation = elevation;
            return this;
        }

        public Builder elevationMode(@NonNull ElevationMode elevationMode) {
            this.m_targetElevationMode = elevationMode;
            return this;
        }

        public Builder indoor(String indoorMapId, int indoorMapFloorId) {
            this.m_targetIndoorMapId = indoorMapId;
            this.m_targetIndoorMapFloorId = indoorMapFloorId;
            return this;
        }

        public Builder zoom(double zoom) {
            this.m_zoom = zoom;
            return this;
        }

        public Builder tilt(double tilt) {
            this.m_tilt = Math.min(Math.max(tilt, 0.0), 90.0);
            return this;
        }

        public Builder bearing(double bearing) {
            while (bearing >= 360.0) {
                bearing -= 360.0;
            }
            while (bearing < 0.0) {
                bearing += 360.0;
            }
            this.m_bearing = bearing;
            return this;
        }

        public Builder distance(double distance) {
            return this.zoom(Builder.DistanceToZoom(distance));
        }

        public final CameraPosition build() {
            return new CameraPosition(this.m_target, this.m_targetElevation, this.m_targetElevationMode, this.m_targetIndoorMapId, this.m_targetIndoorMapFloorId, this.m_zoom, this.m_tilt, this.m_bearing);
        }
    }
}

