/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.location;

import android.app.Activity;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import java.util.ArrayDeque;

public class HeadingService
implements SensorEventListener {
    private SensorManager m_sensorManager;
    private OrientationEventListener m_orientationEventListener = null;
    private Activity m_activity;
    private boolean m_hasAzimuthAngle = false;
    private boolean m_listeningForUpdates = false;
    private int m_deviceRotation = 0;
    private final boolean m_useDeprecatedOrientationMethod = true;
    private float m_azimuthDegrees = 0.0f;
    private final int NumBufferedResults = 16;
    private float m_sumSin;
    private float m_sumCos;
    private ArrayDeque<Float> m_resultsBuffer = new ArrayDeque();
    private float[] m_gravity = new float[3];
    private float[] m_geomagnetic = new float[3];

    public boolean hasHeading() {
        return this.m_hasAzimuthAngle;
    }

    public double heading() {
        return this.m_azimuthDegrees;
    }

    public HeadingService(Activity activity) {
        this.m_activity = activity;
    }

    public void startListening() {
        if (this.m_listeningForUpdates) {
            return;
        }
        this.m_listeningForUpdates = true;
        this.m_sensorManager = (SensorManager)this.m_activity.getSystemService("sensor");
        Sensor orientation = this.m_sensorManager.getDefaultSensor(3);
        this.m_sensorManager.registerListener((SensorEventListener)this, orientation, 1);
        this.m_orientationEventListener = new OrientationEventListener((Context)this.m_activity, 3){

            public void onOrientationChanged(int orientation) {
                HeadingService.this.m_deviceRotation = ((WindowManager)HeadingService.this.m_activity.getSystemService("window")).getDefaultDisplay().getRotation();
            }
        };
        this.m_orientationEventListener.enable();
    }

    public void stopListening() {
        if (this.m_listeningForUpdates) {
            this.m_sensorManager.unregisterListener((SensorEventListener)this);
            this.m_orientationEventListener.disable();
        }
        this.m_listeningForUpdates = false;
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() == 3) {
            float smoothing = 0.6f;
            float heading = event.values[0];
            if (Float.isNaN(heading)) {
                return;
            }
            float newAzimuth = this.adjustHeadingForDeviceOrientation(heading);
            if (Math.abs(newAzimuth - this.m_azimuthDegrees) >= 180.0f) {
                if (newAzimuth > this.m_azimuthDegrees) {
                    this.m_azimuthDegrees += 360.0f;
                } else {
                    newAzimuth += 360.0f;
                }
            }
            this.m_azimuthDegrees = (float)((double)(newAzimuth * smoothing) + (double)this.m_azimuthDegrees * (1.0 - (double)smoothing));
            this.m_azimuthDegrees %= 360.0f;
            this.m_hasAzimuthAngle = true;
            return;
        }
    }

    private void addResultForFiltering(float radians) {
        this.m_sumSin += (float)Math.sin(radians);
        this.m_sumCos += (float)Math.cos(radians);
        this.m_resultsBuffer.add(Float.valueOf(radians));
        if (this.m_resultsBuffer.size() > 16) {
            float old = this.m_resultsBuffer.poll().floatValue();
            this.m_sumSin = (float)((double)this.m_sumSin - Math.sin(old));
            this.m_sumCos = (float)((double)this.m_sumCos - Math.cos(old));
        }
    }

    private float filteredResultDegrees() {
        int size = this.m_resultsBuffer.size();
        if (size == 0) {
            return 0.0f;
        }
        float resultRadians = (float)Math.atan2(this.m_sumSin / (float)size, this.m_sumCos / (float)size);
        float resultDegrees = (float)Math.toDegrees(resultRadians);
        return (resultDegrees + 360.0f) % 360.0f;
    }

    private float adjustHeadingForDeviceOrientation(float heading) {
        switch (this.m_deviceRotation) {
            case 0: {
                heading += 0.0f;
                break;
            }
            case 1: {
                heading += 90.0f;
                break;
            }
            case 2: {
                heading += 180.0f;
                break;
            }
            default: {
                heading += 90.0f;
            }
        }
        heading = (heading + 360.0f) % 360.0f;
        return heading;
    }
}

