/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.polygons;

import com.eegeo.mapapi.geometry.ElevationMode;
import com.eegeo.mapapi.geometry.LatLng;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class PolygonOptions {
    private double m_elevation;
    private ElevationMode m_elevationMode = ElevationMode.HeightAboveGround;
    private String m_indoorMapId = "";
    private int m_indoorFloorId;
    private List<LatLng> m_points = new ArrayList<LatLng>();
    private List<List<LatLng>> m_holes = new ArrayList<List<LatLng>>();
    private int m_fillColorARGB = -16777216;

    public PolygonOptions add(LatLng ... points) {
        Collections.addAll(this.m_points, points);
        return this;
    }

    public PolygonOptions add(LatLng point) {
        this.m_points.add(point);
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> pointsList = new ArrayList<LatLng>();
        for (LatLng point : points) {
            pointsList.add(point);
        }
        this.m_holes.add(pointsList);
        return this;
    }

    public PolygonOptions elevation(double elevation) {
        this.m_elevation = elevation;
        return this;
    }

    public PolygonOptions elevationMode(ElevationMode ElevationMode2) {
        this.m_elevationMode = ElevationMode2;
        return this;
    }

    public PolygonOptions indoor(String indoorMapId, int indoorFloorId) {
        this.m_indoorMapId = indoorMapId;
        this.m_indoorFloorId = indoorFloorId;
        return this;
    }

    public PolygonOptions fillColor(int fillColor) {
        this.m_fillColorARGB = fillColor;
        return this;
    }

    public double getElevation() {
        return this.m_elevation;
    }

    public ElevationMode getElevationMode() {
        return this.m_elevationMode;
    }

    public String getIndoorMapId() {
        return this.m_indoorMapId;
    }

    public int getIndoorFloorId() {
        return this.m_indoorFloorId;
    }

    public List<LatLng> getPoints() {
        return this.m_points;
    }

    public List<List<LatLng>> getHoles() {
        return this.m_holes;
    }

    public int getFillColor() {
        return this.m_fillColorARGB;
    }
}

