/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.polylines;

import com.eegeo.mapapi.geometry.ElevationMode;
import com.eegeo.mapapi.geometry.LatLng;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class PolylineOptions {
    private double m_elevation;
    private ElevationMode m_elevationMode = ElevationMode.HeightAboveGround;
    private String m_indoorMapId = "";
    private int m_indoorFloorId;
    private List<LatLng> m_points = new ArrayList<LatLng>();
    private List<Double> m_perPointElevations = new ArrayList<Double>();
    private float m_width = 10.0f;
    private int m_colorARGB = -16777216;
    private float m_miterLimit = 10.0f;

    public PolylineOptions add(LatLng ... points) {
        Collections.addAll(this.m_points, points);
        for (int i = 0; i < points.length; ++i) {
            this.m_perPointElevations.add(0.0);
        }
        return this;
    }

    public PolylineOptions add(LatLng point) {
        this.m_points.add(point);
        this.m_perPointElevations.add(0.0);
        return this;
    }

    public PolylineOptions add(LatLng point, double heightOffset) {
        this.m_points.add(point);
        this.m_perPointElevations.add(heightOffset);
        return this;
    }

    public PolylineOptions elevation(double elevation) {
        this.m_elevation = elevation;
        return this;
    }

    public PolylineOptions elevationMode(ElevationMode ElevationMode2) {
        this.m_elevationMode = ElevationMode2;
        return this;
    }

    public PolylineOptions indoor(String indoorMapId, int indoorFloorId) {
        this.m_indoorMapId = indoorMapId;
        this.m_indoorFloorId = indoorFloorId;
        return this;
    }

    public PolylineOptions width(float width) {
        this.m_width = width;
        return this;
    }

    public PolylineOptions color(int color) {
        this.m_colorARGB = color;
        return this;
    }

    public PolylineOptions miterLimit(float miterLimit) {
        this.m_miterLimit = miterLimit;
        return this;
    }

    public double getElevation() {
        return this.m_elevation;
    }

    public ElevationMode getElevationMode() {
        return this.m_elevationMode;
    }

    public String getIndoorMapId() {
        return this.m_indoorMapId;
    }

    public int getIndoorFloorId() {
        return this.m_indoorFloorId;
    }

    public List<LatLng> getPoints() {
        return this.m_points;
    }

    public List<Double> getPerPointElevations() {
        return this.m_perPointElevations;
    }

    public float getWidth() {
        return this.m_width;
    }

    public int getColor() {
        return this.m_colorARGB;
    }

    public float getMiterLimit() {
        return this.m_miterLimit;
    }
}

