/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.services.routing;

import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.services.routing.OnRoutingQueryCompletedListener;
import com.eegeo.mapapi.services.routing.RoutingApi;
import com.eegeo.mapapi.services.routing.RoutingQueryOptions;
import com.eegeo.mapapi.services.routing.RoutingQueryResponse;
import com.eegeo.mapapi.util.NativeApiObject;
import java.util.concurrent.Callable;

public class RoutingQuery
extends NativeApiObject {
    private RoutingApi m_routingApi;
    private OnRoutingQueryCompletedListener m_callback;

    @UiThread
    RoutingQuery(final RoutingApi routingApi, final RoutingQueryOptions options) {
        super(routingApi.getNativeRunner(), routingApi.getUiRunner(), new Callable<Integer>(){

            @Override
            @WorkerThread
            public Integer call() throws Exception {
                Integer id2 = routingApi.beginRouteQuery(options);
                return id2;
            }
        });
        this.m_routingApi = routingApi;
        this.m_callback = options.getOnRoutingQueryCompletedListener();
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                RoutingQuery.this.m_routingApi.register(RoutingQuery.this, RoutingQuery.this.getNativeHandle());
            }
        });
    }

    @UiThread
    public void cancel() {
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                RoutingQuery.this.m_routingApi.cancelQuery(RoutingQuery.this.getNativeHandle());
            }
        });
    }

    @UiThread
    void returnQueryResponse(RoutingQueryResponse response) {
        if (this.m_callback != null) {
            this.m_callback.onRoutingQueryCompleted(this, response);
        }
    }
}

