/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.buildings;

import android.graphics.Point;
import com.eegeo.mapapi.buildings.OnBuildingInformationReceivedListener;
import com.eegeo.mapapi.geometry.LatLng;

public final class BuildingHighlightOptions {
    private LatLng m_selectionLocation = new LatLng(0.0, 0.0);
    private Point m_selectionScreenPoint = new Point(0, 0);
    private int m_colorARGB = -16777216;
    private SelectionMode m_selectionMode = SelectionMode.SelectAtLocation;
    private boolean m_shouldCreateView = true;
    private OnBuildingInformationReceivedListener m_onBuildingInformationReceivedListener = null;

    public BuildingHighlightOptions highlightBuildingAtLocation(LatLng location) {
        this.m_selectionLocation = location;
        this.m_selectionMode = SelectionMode.SelectAtLocation;
        return this;
    }

    public BuildingHighlightOptions highlightBuildingAtScreenPoint(Point screenPoint) {
        this.m_selectionScreenPoint = screenPoint;
        this.m_selectionMode = SelectionMode.SelectAtScreenPoint;
        return this;
    }

    public BuildingHighlightOptions color(int color) {
        this.m_colorARGB = color;
        return this;
    }

    public BuildingHighlightOptions informationOnly() {
        this.m_shouldCreateView = false;
        return this;
    }

    public BuildingHighlightOptions buildingInformationReceivedListener(OnBuildingInformationReceivedListener listener) {
        this.m_onBuildingInformationReceivedListener = listener;
        return this;
    }

    public SelectionMode getSelectionMode() {
        return this.m_selectionMode;
    }

    public LatLng getSelectionLocation() {
        return this.m_selectionLocation;
    }

    public Point getSelectionScreenPoint() {
        return this.m_selectionScreenPoint;
    }

    public int getColor() {
        return this.m_colorARGB;
    }

    public boolean getShouldCreateView() {
        return this.m_shouldCreateView;
    }

    public OnBuildingInformationReceivedListener getOnBuildingInformationReceivedListener() {
        return this.m_onBuildingInformationReceivedListener;
    }

    static enum SelectionMode {
        SelectAtLocation,
        SelectAtScreenPoint;

    }
}

