/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.markers;

import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.geometry.ElevationMode;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.markers.MarkerApi;
import com.eegeo.mapapi.markers.MarkerOptions;
import com.eegeo.mapapi.util.NativeApiObject;
import java.util.concurrent.Callable;

public class Marker
extends NativeApiObject {
    private static final AllowHandleAccess m_allowHandleAccess = new AllowHandleAccess();
    private final MarkerApi m_markerApi;
    private final String m_styleName;
    private final String m_userData;
    private final String m_indoorMapId;
    private final int m_indoorFloorId;
    private LatLng m_position;
    private double m_elevation;
    private ElevationMode m_elevationMode;
    private String m_title;
    private String m_iconKey;
    private int m_drawOrder;

    @UiThread
    public Marker(final @NonNull MarkerApi markerApi, final @NonNull MarkerOptions markerOptions) {
        super(markerApi.getNativeRunner(), markerApi.getUiRunner(), new Callable<Integer>(){

            @Override
            @WorkerThread
            public Integer call() throws Exception {
                return markerApi.createMarker(markerOptions, m_allowHandleAccess);
            }
        });
        this.m_markerApi = markerApi;
        this.m_position = markerOptions.getPosition();
        this.m_elevation = markerOptions.getElevation();
        this.m_elevationMode = markerOptions.getElevationMode();
        this.m_title = markerOptions.getTitle();
        this.m_iconKey = markerOptions.getIconKey();
        this.m_drawOrder = markerOptions.getDrawOrder();
        this.m_styleName = markerOptions.getStyleName();
        this.m_indoorMapId = markerOptions.getIndoorMapId();
        this.m_indoorFloorId = markerOptions.getIndoorFloorId();
        this.m_userData = markerOptions.getUserData();
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                markerApi.registerMarker(Marker.this, m_allowHandleAccess);
            }
        });
    }

    @UiThread
    public LatLng getPosition() {
        return this.m_position;
    }

    @UiThread
    public void setPosition(@NonNull LatLng position) {
        this.m_position = position;
        this.updateLocation();
    }

    @UiThread
    public double getElevation() {
        return this.m_elevation;
    }

    @UiThread
    public void setElevation(double elevation) {
        this.m_elevation = elevation;
        this.updateLocation();
    }

    @UiThread
    public ElevationMode getElevationMode() {
        return this.m_elevationMode;
    }

    @UiThread
    public void setElevationMode(ElevationMode elevationMode) {
        this.m_elevationMode = elevationMode;
        this.updateLocation();
    }

    @UiThread
    public String getTitle() {
        return this.m_title;
    }

    @UiThread
    public void setTitle(@NonNull String title) {
        this.m_title = title;
        this.updateLabel();
    }

    @UiThread
    public String getIconKey() {
        return this.m_iconKey;
    }

    @UiThread
    public void setIconKey(@NonNull String iconKey) {
        this.m_iconKey = iconKey;
        this.updateLabel();
    }

    @UiThread
    public int getDrawOrder() {
        return this.m_drawOrder;
    }

    @UiThread
    public void setDrawOrder(int drawOrder) {
        this.m_drawOrder = drawOrder;
        this.updateLabel();
    }

    @UiThread
    public String getIndoorMapId() {
        return this.m_indoorMapId;
    }

    @UiThread
    public int getIndoorFloorId() {
        return this.m_indoorFloorId;
    }

    @UiThread
    public String getUserData() {
        return this.m_userData;
    }

    @UiThread
    public String getStyleName() {
        return this.m_styleName;
    }

    @UiThread
    public void destroy() {
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Marker.this.m_markerApi.destroy(Marker.this, m_allowHandleAccess);
            }
        });
    }

    @UiThread
    private void updateLocation() {
        final LatLng position = this.m_position;
        final double elevation = this.m_elevation;
        final ElevationMode elevationMode = this.m_elevationMode;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Marker.this.m_markerApi.updateLocation(Marker.this.getNativeHandle(), m_allowHandleAccess, position, elevation, elevationMode);
            }
        });
    }

    @UiThread
    private void updateLabel() {
        final String title = this.m_title;
        final String iconKey = this.m_iconKey;
        final int drawOrder = this.m_drawOrder;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Marker.this.m_markerApi.updateLabel(Marker.this.getNativeHandle(), m_allowHandleAccess, title, iconKey, drawOrder);
            }
        });
    }

    @WorkerThread
    int getNativeHandle(AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for use by MarkerApi");
        }
        if (!this.hasNativeHandle()) {
            throw new IllegalStateException("Native handle not available");
        }
        return this.getNativeHandle();
    }

    static final class AllowHandleAccess {
        @WorkerThread
        private AllowHandleAccess() {
        }
    }
}

