/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.location;

import android.app.Activity;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import java.util.List;

public class LocationService {
    static boolean isListening = false;
    static boolean lastQuerySucceeded = false;
    static boolean locationValid = false;
    static Location bestLocation = null;
    static boolean isAuthorized = false;
    static Activity activity;
    static LocationListener locationListener;
    static LocationManager locationManager;
    private static final int ONE_MINUTE = 60000;

    public static double lat() {
        if (bestLocation == null) {
            return 0.0;
        }
        return bestLocation.getLatitude();
    }

    public static double lon() {
        if (bestLocation == null) {
            return 0.0;
        }
        return bestLocation.getLongitude();
    }

    public static double alt() {
        if (bestLocation == null) {
            return 0.0;
        }
        return bestLocation.getAltitude();
    }

    public static boolean hasAlt() {
        if (bestLocation == null) {
            return false;
        }
        return bestLocation.hasAltitude();
    }

    public static double accuracy() {
        if (bestLocation == null) {
            return 0.0;
        }
        return bestLocation.getAccuracy();
    }

    public static boolean hasAccuracy() {
        if (bestLocation == null) {
            return false;
        }
        return bestLocation.hasAccuracy();
    }

    public static boolean getIsAuthorized() {
        return isAuthorized;
    }

    public static boolean lastQuerySucceeded() {
        return bestLocation != null;
    }

    public static boolean locationValid() {
        return bestLocation != null;
    }

    public static void startListeningToUpdates(Activity a) {
        if (!isListening) {
            LocationService.setupListenerAndLocationManager(a);
            LocationService.forceLocationFromCachedProviders(locationManager);
            a.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (locationListener != null) {
                            locationManager.requestLocationUpdates("gps", 0L, 0.0f, locationListener);
                            locationManager.requestLocationUpdates("network", 0L, 0.0f, locationListener);
                        }
                    }
                    catch (SecurityException e) {
                        Log.v((String)"Location", (String)e.getMessage());
                    }
                }
            });
        }
    }

    public static void stopListeningToUpdates(Activity a) {
        if (isListening) {
            locationManager.removeUpdates(locationListener);
            LocationService.tearDownListener();
        }
    }

    public static void updateLocation(Activity a) {
        LocationService.startListeningToUpdates(a);
    }

    private static void forceLocationFromCachedProviders(LocationManager locationManager) {
        List providers = locationManager.getProviders(true);
        Location bestCachedLocation = null;
        for (String provider : providers) {
            Location l = null;
            try {
                l = locationManager.getLastKnownLocation(provider);
            }
            catch (SecurityException e) {
                continue;
            }
            if (l == null || !LocationService.isBetterLocation(l, bestCachedLocation)) continue;
            bestCachedLocation = l;
        }
        bestLocation = bestCachedLocation;
        Log.v((String)"Location", (String)"best location set from cache");
    }

    private static void tearDownListener() {
        if (locationManager != null) {
            locationManager = null;
        }
        if (locationListener != null) {
            locationListener = null;
            isListening = false;
        }
    }

    private static boolean isAnyProviderEnabled(LocationManager locationManager) {
        boolean gpsIsAuthorized = locationManager.isProviderEnabled("gps");
        boolean networkIsAuthorized = locationManager.isProviderEnabled("network");
        return gpsIsAuthorized || networkIsAuthorized;
    }

    private static void setupListenerAndLocationManager(Activity a) {
        locationManager = (LocationManager)a.getSystemService("location");
        isAuthorized = LocationService.isAnyProviderEnabled(locationManager);
        if (locationListener == null) {
            locationListener = new LocationListener(){

                public void onLocationChanged(Location location) {
                    if (LocationService.isBetterLocation(location, bestLocation)) {
                        bestLocation = location;
                        Log.v((String)"Location", (String)("best updated from onLocationChanged : " + location.getLatitude() + " , " + location.getLongitude() + " , " + location.getAltitude()));
                    }
                }

                public void onStatusChanged(String provider, int status, Bundle extras) {
                    Log.v((String)"Location", (String)"onStatusChanged");
                }

                public void onProviderEnabled(String provider) {
                    isAuthorized = LocationService.isAnyProviderEnabled(locationManager);
                    Log.v((String)"Location", (String)("onProviderEnabled, LocationService.isAuthorized : " + isAuthorized));
                }

                public void onProviderDisabled(String provider) {
                    isAuthorized = LocationService.isAnyProviderEnabled(locationManager);
                    Log.v((String)"Location", (String)("onProviderDisabled, LocationService.isAuthorized : " + isAuthorized));
                }
            };
        }
        isListening = true;
    }

    protected static boolean isBetterLocation(Location location, Location currentBestLocation) {
        boolean isNewer;
        if (currentBestLocation == null) {
            return true;
        }
        long timeDelta = location.getTime() - currentBestLocation.getTime();
        boolean isSignificantlyNewer = timeDelta > 60000L;
        boolean isSignificantlyOlder = timeDelta < -60000L;
        boolean bl = isNewer = timeDelta > 0L;
        if (isSignificantlyNewer) {
            return true;
        }
        if (isSignificantlyOlder) {
            return false;
        }
        int accuracyDelta = (int)(location.getAccuracy() - currentBestLocation.getAccuracy());
        boolean isLessAccurate = accuracyDelta > 0;
        boolean isMoreAccurate = accuracyDelta < 0;
        boolean isSignificantlyLessAccurate = accuracyDelta > 200;
        boolean isFromSameProvider = LocationService.isSameProvider(location.getProvider(), currentBestLocation.getProvider());
        if (isMoreAccurate) {
            return true;
        }
        if (isNewer && !isLessAccurate) {
            return true;
        }
        return isNewer && !isSignificantlyLessAccurate && isFromSameProvider;
    }

    private static boolean isSameProvider(String provider1, String provider2) {
        if (provider1 == null) {
            return provider2 == null;
        }
        return provider1.equals(provider2);
    }
}

