/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.services.routing;

import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.services.routing.OnRoutingQueryCompletedListener;
import java.util.ArrayList;
import java.util.List;

public final class RoutingQueryOptions {
    private List<Waypoint> m_waypoints = new ArrayList<Waypoint>();
    private OnRoutingQueryCompletedListener m_onRoutingQueryCompletedListener = null;

    public RoutingQueryOptions addWaypoint(LatLng latLng) {
        this.m_waypoints.add(new Waypoint(latLng, false, 0));
        return this;
    }

    public RoutingQueryOptions addIndoorWaypoint(LatLng latLng, int indoorFloorId) {
        this.m_waypoints.add(new Waypoint(latLng, true, indoorFloorId));
        return this;
    }

    List<Waypoint> getWaypoints() {
        return this.m_waypoints;
    }

    public RoutingQueryOptions onRoutingQueryCompletedListener(OnRoutingQueryCompletedListener onRoutingQueryCompletedListener) {
        this.m_onRoutingQueryCompletedListener = onRoutingQueryCompletedListener;
        return this;
    }

    OnRoutingQueryCompletedListener getOnRoutingQueryCompletedListener() {
        return this.m_onRoutingQueryCompletedListener;
    }

    class Waypoint {
        public final LatLng latLng;
        public final boolean isIndoors;
        public final int indoorFloorId;

        public Waypoint(LatLng latLng, boolean isIndoors, int indoorFloorId) {
            this.latLng = latLng;
            this.isIndoors = isIndoors;
            this.indoorFloorId = indoorFloorId;
        }
    }
}

