/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.polygons;

import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.geometry.ElevationMode;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.polygons.PolygonApi;
import com.eegeo.mapapi.polygons.PolygonOptions;
import com.eegeo.mapapi.util.NativeApiObject;
import java.util.List;
import java.util.concurrent.Callable;

public class Polygon
extends NativeApiObject {
    private static final AllowHandleAccess m_allowHandleAccess = new AllowHandleAccess();
    private final PolygonApi m_polygonApi;
    private String m_indoorMapId;
    private int m_indoorFloorId;
    private double m_elevation;
    private ElevationMode m_elevationMode;
    private List<LatLng> m_points;
    private List<List<LatLng>> m_holes;
    private int m_fillColorARGB;

    @UiThread
    public Polygon(final @NonNull PolygonApi polygonApi, final @NonNull PolygonOptions polygonOptions) {
        super(polygonApi.getNativeRunner(), polygonApi.getUiRunner(), new Callable<Integer>(){

            @Override
            @WorkerThread
            public Integer call() throws Exception {
                return polygonApi.create(polygonOptions, m_allowHandleAccess);
            }
        });
        this.m_polygonApi = polygonApi;
        this.m_indoorMapId = polygonOptions.getIndoorMapId();
        this.m_indoorFloorId = polygonOptions.getIndoorFloorId();
        this.m_elevation = polygonOptions.getElevation();
        this.m_elevationMode = polygonOptions.getElevationMode();
        this.m_points = polygonOptions.getPoints();
        this.m_holes = polygonOptions.getHoles();
        this.m_fillColorARGB = polygonOptions.getFillColor();
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                polygonApi.register(Polygon.this, m_allowHandleAccess);
            }
        });
    }

    @UiThread
    public double getElevation() {
        return this.m_elevation;
    }

    @UiThread
    public void setElevation(double elevation) {
        this.m_elevation = elevation;
        this.updateNativeElevation();
    }

    @UiThread
    public ElevationMode getElevationMode() {
        return this.m_elevationMode;
    }

    @UiThread
    public void setElevationMode(ElevationMode elevationMode) {
        this.m_elevationMode = elevationMode;
        this.updateNativeElevation();
    }

    @UiThread
    public String getIndoorMapId() {
        return this.m_indoorMapId;
    }

    @UiThread
    public void setIndoorMapId(String indoorMapId) {
        this.m_indoorMapId = indoorMapId;
        this.updateNativeIndoorMap();
    }

    @UiThread
    public int getIndoorFloorId() {
        return this.m_indoorFloorId;
    }

    @UiThread
    public void setIndoorFloorId(int indoorFloorId) {
        this.m_indoorFloorId = indoorFloorId;
        this.updateNativeIndoorMap();
    }

    @UiThread
    public int getFillColor() {
        return this.m_fillColorARGB;
    }

    @UiThread
    public void setFillColor(int fillColor) {
        this.m_fillColorARGB = fillColor;
        this.updateNativeStyleAttributes();
    }

    @UiThread
    public List<LatLng> getPoints() {
        return this.m_points;
    }

    @UiThread
    public List<List<LatLng>> getHoles() {
        return this.m_holes;
    }

    @UiThread
    public void destroy() {
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Polygon.this.m_polygonApi.destroy(Polygon.this, m_allowHandleAccess);
            }
        });
    }

    @UiThread
    private void updateNativeIndoorMap() {
        final String indoorMapId = this.m_indoorMapId;
        final int indoorFloorId = this.m_indoorFloorId;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Polygon.this.m_polygonApi.setIndoorMap(Polygon.this.getNativeHandle(), m_allowHandleAccess, indoorMapId, indoorFloorId);
            }
        });
    }

    @UiThread
    private void updateNativeElevation() {
        final double elevation = this.m_elevation;
        final ElevationMode elevationMode = this.m_elevationMode;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Polygon.this.m_polygonApi.setElevation(Polygon.this.getNativeHandle(), m_allowHandleAccess, elevation, elevationMode);
            }
        });
    }

    @UiThread
    private void updateNativeStyleAttributes() {
        final int fillColorARGB = this.m_fillColorARGB;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Polygon.this.m_polygonApi.setStyleAttributes(Polygon.this.getNativeHandle(), m_allowHandleAccess, fillColorARGB);
            }
        });
    }

    @WorkerThread
    int getNativeHandle(AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for use by PolygonApi");
        }
        if (!this.hasNativeHandle()) {
            throw new IllegalStateException("Native handle not available");
        }
        return this.getNativeHandle();
    }

    static final class AllowHandleAccess {
        @WorkerThread
        private AllowHandleAccess() {
        }
    }
}

